/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.library.global.task;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.exceptions.AuthenticationException;
import java.util.Date;
import moe.plushie.armourers_workshop.common.library.global.MultipartForm;
import moe.plushie.armourers_workshop.common.library.global.auth.PlushieAuth;
import moe.plushie.armourers_workshop.common.library.global.auth.PlushieSession;
import moe.plushie.armourers_workshop.common.library.global.permission.PermissionSystem;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTask;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTaskResult;

public class GlobalTaskSkinReport
extends GlobalTask<SkinReportResult> {
    private static final String URL = "user-skin-report.php";
    private final SkinReport report;

    public GlobalTaskSkinReport(SkinReport report) {
        super(PermissionSystem.PlushieAction.SKIN_REPORT, true);
        this.report = report;
    }

    @Override
    public SkinReportResult call() throws Exception {
        this.permissionCheck();
        if (!GlobalTaskSkinReport.authenticateUser()) {
            throw new AuthenticationException();
        }
        PlushieSession plushieSession = PlushieAuth.PLUSHIE_SESSION;
        MultipartForm multipartForm = new MultipartForm(this.getBaseUrl() + URL);
        multipartForm.addText("userId", String.valueOf(plushieSession.getServerId()));
        multipartForm.addText("accessToken", plushieSession.getAccessToken());
        multipartForm.addText("reportSkinId", String.valueOf(this.report.getSkinId()));
        multipartForm.addText("reportType", this.report.getReportType().toString());
        multipartForm.addText("reportMessage", this.report.getMessage());
        String downloadString = multipartForm.upload();
        JsonObject jsonObject = new JsonParser().parse(downloadString).getAsJsonObject();
        if (jsonObject.has("valid")) {
            boolean valid = jsonObject.get("valid").getAsBoolean();
            if (valid) {
                return new SkinReportResult(GlobalTaskResult.SUCCESS);
            }
            if (jsonObject.has("reason")) {
                return new SkinReportResult(GlobalTaskResult.FAILED, jsonObject.get("reason").getAsString());
            }
        }
        return new SkinReportResult(GlobalTaskResult.FAILED, downloadString);
    }

    public class SkinReportResult {
        private GlobalTaskResult result;
        private String message;

        public SkinReportResult(GlobalTaskResult result, String message) {
            this.result = result;
            this.message = message;
        }

        public SkinReportResult(GlobalTaskResult result) {
            this.result = result;
            this.message = null;
        }

        public GlobalTaskResult getResult() {
            return this.result;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class SkinReport {
        private final int userId;
        private final int skinId;
        private final SkinReportType reportType;
        private final String message;
        private final Date date;

        public SkinReport(int userId, int skinId, SkinReportType reportType, String message, Date date) {
            this.userId = userId;
            this.skinId = skinId;
            this.reportType = reportType;
            this.message = message;
            this.date = date;
        }

        public SkinReport(int skinId, SkinReportType reportType, String message) {
            this.userId = -1;
            this.skinId = skinId;
            this.reportType = reportType;
            this.message = message;
            this.date = null;
        }

        public int getUserId() {
            return this.userId;
        }

        public int getSkinId() {
            return this.skinId;
        }

        public SkinReportType getReportType() {
            return this.reportType;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "SkinReport [userId=" + this.userId + ", skinId=" + this.skinId + ", reportType=" + (Object)((Object)this.reportType) + ", message=" + this.message + ", date=" + this.date + "]";
        }

        public static enum SkinReportType {
            SEXUAL,
            INAPPROPRIATE,
            STOLEN,
            SPAM,
            OTHER;

        }
    }
}

