/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.library.global.task;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.exceptions.AuthenticationException;
import moe.plushie.armourers_workshop.common.library.global.auth.PlushieAuth;
import moe.plushie.armourers_workshop.common.library.global.auth.PlushieSession;
import moe.plushie.armourers_workshop.common.library.global.permission.PermissionSystem;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTask;

public class GlobalTaskUserSkinRate
extends GlobalTask<JsonObject> {
    private static final String URL = "user-skin-action.php?userId=%d&accessToken=%s&action=%s&skinId=%d";
    private final int skinID;
    private final int rating;

    public GlobalTaskUserSkinRate(int skinID, int rating) {
        super(PermissionSystem.PlushieAction.SKIN_RATE, true);
        this.skinID = skinID;
        this.rating = rating;
    }

    @Override
    public JsonObject call() throws Exception {
        this.permissionCheck();
        if (!GlobalTaskUserSkinRate.authenticateUser()) {
            throw new AuthenticationException();
        }
        PlushieSession plushieSession = PlushieAuth.PLUSHIE_SESSION;
        boolean like = this.rating > 0;
        String action = "";
        action = like ? "like" : "unlike";
        String url = String.format(this.getBaseUrl() + URL, plushieSession.getServerId(), plushieSession.getAccessToken(), action, this.skinID);
        String data = GlobalTaskUserSkinRate.downloadString(url);
        return new JsonParser().parse(data).getAsJsonObject();
    }
}

