/*
 * Decompiled with CFR 0.152.
 */
package com.ramonrpa.customhud;

import com.ramonrpa.customhud.Hud;
import com.ramonrpa.customhud.PlayerInfoMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="customhud", name="customhud", version="1.0")
public class Main {
    public static final String MODID = "customhud";
    public static final String NAME = "customhud";
    public static final String VERSION = "1.0";
    public static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("customhud");
    public static Hud hud;
    public FontRenderer regular;
    public Minecraft minecraft;

    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.minecraft = Minecraft.func_71410_x();
        hud = new Hud(this, new Hud.PlayerInfo());
    }

    @SideOnly(value=Side.SERVER)
    @Mod.EventHandler
    public void initServer(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        INSTANCE.registerMessage(PlayerInfoMessage.PlayerInfoHandler.class, PlayerInfoMessage.class, 0, Side.CLIENT);
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventHandler
    public void initClient(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        INSTANCE.registerMessage(PlayerInfoMessage.PlayerInfoHandler.class, PlayerInfoMessage.class, 0, Side.CLIENT);
        this.regular = new FontRenderer(this.minecraft.field_71474_y, new ResourceLocation("customhud:textures/font/saqui-regular.png"), this.minecraft.func_110434_K(), true);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGameOverlayRender(RenderGameOverlayEvent event) {
        switch (event.getType()) {
            case HEALTH: {
                if (event instanceof RenderGameOverlayEvent.Post) break;
                event.setCanceled(true);
                break;
            }
            case ALL: {
                if (event instanceof RenderGameOverlayEvent.Pre) break;
                hud.render();
            }
        }
    }

    @SideOnly(value=Side.SERVER)
    @SubscribeEvent
    public void onTickEvent(TickEvent.ServerTickEvent event) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
            NBTTagCompound data = player.getEntityData().func_74775_l("PlayerPersisted");
            float health = data.func_74762_e("snohp");
            float maxHealth = data.func_74762_e("snomaxhp");
            float mana = data.func_74762_e("snoep");
            float maxMana = data.func_74762_e("snomaxep");
            int lvl = data.func_74762_e("snolvl");
            maxHealth = maxHealth != 0.0f ? maxHealth : player.func_110138_aP();
            maxMana = maxMana != 0.0f ? maxMana : 20.0f;
            PlayerInfoMessage message = new PlayerInfoMessage(health, maxHealth, mana, maxMana, lvl);
            INSTANCE.sendTo((IMessage)message, player);
        }
    }
}

