/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary;

import com.lycanitesmobs.GuiHandler;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.client.gui.beastiary.BeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureFilterList;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureList;
import com.lycanitesmobs.client.gui.beastiary.lists.PetTypeList;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.pets.PetEntry;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;

public class PetsBeastiaryScreen
extends BeastiaryScreen {
    public CreatureFilterList petTypeList;
    public CreatureList petList;
    private int petCommandIdStart = 200;
    private int releaseConfirmId = 300;
    private int releaseCancelId = 301;

    public static void openToPlayer(EntityPlayer player) {
        if (player != null) {
            player.openGui((Object)LycanitesMobs.instance, (int)GuiHandler.GuiType.BEASTIARY.id, player.func_130014_f_(), (int)GuiHandler.Beastiary.PETS.id, 0, 0);
        }
    }

    public PetsBeastiaryScreen(EntityPlayer player) {
        super(player);
        this.playerExt.selectedSubspecies = 0;
        this.playerExt.selectedVariant = 0;
    }

    @Override
    public String getTitle() {
        if (this.playerExt.selectedPet != null) {
            String title = this.playerExt.selectedPet.getDisplayName();
            title = title + " " + LanguageManager.translate("creature.stat.level") + " " + this.playerExt.selectedPet.getLevel();
            if (this.playerExt.selectedPet.releaseEntity) {
                title = LanguageManager.translate("gui.pet.release") + " " + title;
            }
            return title;
        }
        if (this.playerExt.petManager.entries.isEmpty()) {
            return LanguageManager.translate("gui.beastiary.pets.empty.title");
        }
        return LanguageManager.translate("gui.beastiary.pets");
    }

    @Override
    public void initControls() {
        super.initControls();
        int petTypeListHeight = Math.round((float)this.colLeftHeight * 0.225f);
        int petTypeListY = this.colLeftY;
        this.petTypeList = new PetTypeList(this, this.colLeftWidth, petTypeListHeight, petTypeListY, petTypeListY + petTypeListHeight, this.colLeftX);
        int petListHeight = Math.round((float)this.colLeftHeight * 0.7f);
        int petListY = petTypeListY + petTypeListHeight + Math.round((float)this.colLeftHeight * 0.025f);
        this.petList = new CreatureList(CreatureList.Type.PET, this, this.petTypeList, this.colLeftWidth, petListHeight, petListY, petListY + petListHeight, this.colLeftX);
        int buttonWidth = 80;
        int buttonHeight = 20;
        int buttonSpacing = 2;
        int buttonMarginX = 10 + Math.max(Math.max(this.getFontRenderer().func_78256_a(LanguageManager.translate("gui.pet.actions")), this.getFontRenderer().func_78256_a(LanguageManager.translate("gui.pet.stance"))), this.getFontRenderer().func_78256_a(LanguageManager.translate("gui.pet.movement")));
        int buttonX = this.colRightX + buttonMarginX;
        int buttonY = this.colRightY + this.colRightHeight - (buttonHeight + buttonSpacing) * 3;
        GuiButton button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.ACTIVE.id + this.petCommandIdStart, buttonX, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.active"));
        this.field_146292_n.add(button);
        button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.TELEPORT.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.teleport"));
        this.field_146292_n.add(button);
        button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.PVP.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.pvp"));
        this.field_146292_n.add(button);
        button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.RELEASE.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.release"));
        this.field_146292_n.add(button);
        buttonX = this.colRightX + buttonMarginX;
        button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.PASSIVE.id + this.petCommandIdStart, buttonX, buttonY += buttonHeight + 2, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.passive"));
        this.field_146292_n.add(button);
        button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.DEFENSIVE.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.defensive"));
        this.field_146292_n.add(button);
        button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.ASSIST.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.assist"));
        this.field_146292_n.add(button);
        button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.AGGRESSIVE.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.aggressive"));
        this.field_146292_n.add(button);
        buttonX = this.colRightX + buttonMarginX;
        button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.FOLLOW.id + this.petCommandIdStart, buttonX, buttonY += buttonHeight + 2, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.follow"));
        this.field_146292_n.add(button);
        button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.WANDER.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.wander"));
        this.field_146292_n.add(button);
        button = new GuiButton(BaseCreatureEntity.PET_COMMAND_ID.SIT.id + this.petCommandIdStart, buttonX += buttonWidth + buttonSpacing, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("gui.pet.sit"));
        this.field_146292_n.add(button);
        buttonX = this.colRightX + Math.round((float)this.colRightWidth / 2.0f) - (buttonWidth + buttonSpacing);
        buttonY = this.colRightY + Math.round((float)this.colRightHeight / 2.0f) - Math.round((float)buttonHeight / 2.0f);
        button = new GuiButton(this.releaseConfirmId, buttonX, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("common.yes"));
        this.field_146292_n.add(button);
        button = new GuiButton(this.releaseCancelId, (buttonX += buttonSpacing) + buttonWidth, buttonY, buttonWidth, buttonHeight, LanguageManager.translate("common.no"));
        this.field_146292_n.add(button);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void updateControls(int mouseX, int mouseY, float partialTicks) {
        super.updateControls(mouseX, mouseY, partialTicks);
        boolean empty = this.playerExt.petManager.entries.isEmpty();
        if (!empty) {
            this.petTypeList.drawScreen(mouseX, mouseY, partialTicks);
            this.petList.drawScreen(mouseX, mouseY, partialTicks);
        }
        for (GuiButton button : this.field_146292_n) {
            if (button.field_146127_k >= this.petCommandIdStart && button.field_146127_k < this.releaseConfirmId) {
                if (this.playerExt.selectedPet != null && !this.playerExt.selectedPet.releaseEntity) {
                    boolean bl = button.field_146125_m = !empty;
                    if (button.field_146127_k == BaseCreatureEntity.PET_COMMAND_ID.ACTIVE.id + this.petCommandIdStart) {
                        if (!this.playerExt.selectedPet.spawningActive) {
                            button.field_146126_j = LanguageManager.translate("gui.pet.summon");
                            continue;
                        }
                        button.field_146126_j = LanguageManager.translate("gui.pet.dismiss");
                        continue;
                    }
                    if (button.field_146127_k == BaseCreatureEntity.PET_COMMAND_ID.PVP.id + this.petCommandIdStart) {
                        if (this.playerExt.selectedPet.summonSet.getPVP()) {
                            button.field_146126_j = LanguageManager.translate("gui.pet.pvp") + ": " + LanguageManager.translate("common.yes");
                            continue;
                        }
                        button.field_146126_j = LanguageManager.translate("gui.pet.pvp") + ": " + LanguageManager.translate("common.no");
                        continue;
                    }
                    if (button.field_146127_k == BaseCreatureEntity.PET_COMMAND_ID.PASSIVE.id + this.petCommandIdStart) {
                        button.field_146124_l = !this.playerExt.selectedPet.summonSet.passive;
                        continue;
                    }
                    if (button.field_146127_k == BaseCreatureEntity.PET_COMMAND_ID.DEFENSIVE.id + this.petCommandIdStart) {
                        button.field_146124_l = this.playerExt.selectedPet.summonSet.getPassive() || this.playerExt.selectedPet.summonSet.getAssist() || this.playerExt.selectedPet.summonSet.getAggressive();
                        continue;
                    }
                    if (button.field_146127_k == BaseCreatureEntity.PET_COMMAND_ID.ASSIST.id + this.petCommandIdStart) {
                        button.field_146124_l = this.playerExt.selectedPet.summonSet.getPassive() || !this.playerExt.selectedPet.summonSet.getAssist() || this.playerExt.selectedPet.summonSet.getAggressive();
                        continue;
                    }
                    if (button.field_146127_k == BaseCreatureEntity.PET_COMMAND_ID.AGGRESSIVE.id + this.petCommandIdStart) {
                        button.field_146124_l = this.playerExt.selectedPet.summonSet.getPassive() || !this.playerExt.selectedPet.summonSet.getAggressive();
                        continue;
                    }
                    if (button.field_146127_k == BaseCreatureEntity.PET_COMMAND_ID.FOLLOW.id + this.petCommandIdStart) {
                        button.field_146124_l = this.playerExt.selectedPet.summonSet.getSitting() || !this.playerExt.selectedPet.summonSet.getFollowing();
                        continue;
                    }
                    if (button.field_146127_k == BaseCreatureEntity.PET_COMMAND_ID.WANDER.id + this.petCommandIdStart) {
                        button.field_146124_l = this.playerExt.selectedPet.summonSet.getSitting() || this.playerExt.selectedPet.summonSet.getFollowing();
                        continue;
                    }
                    if (button.field_146127_k != BaseCreatureEntity.PET_COMMAND_ID.SIT.id + this.petCommandIdStart) continue;
                    button.field_146124_l = !this.playerExt.selectedPet.summonSet.getSitting();
                    continue;
                }
                button.field_146125_m = false;
                continue;
            }
            if (button.field_146127_k != this.releaseConfirmId && button.field_146127_k != this.releaseCancelId) continue;
            button.field_146125_m = this.playerExt.selectedPet != null && this.playerExt.selectedPet.releaseEntity && !empty;
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY, float partialTicks) {
        super.drawForeground(mouseX, mouseY, partialTicks);
        int marginX = 0;
        int nextX = this.colRightX + marginX;
        int nextY = this.colRightY + 20;
        int width = this.colRightWidth - marginX;
        if (this.playerExt.petManager.entries.isEmpty()) {
            String text = LanguageManager.translate("gui.beastiary.pets.empty.info");
            this.drawSplitString(text, nextX, nextY, width, 0xFFFFFF, true);
            return;
        }
        if (this.playerExt.selectedPet != null) {
            this.renderCreature(this.playerExt.selectedPet.getCreatureInfo(), this.colRightX + marginX / 2 + this.colRightWidth / 2, this.colRightY + Math.round((float)this.colRightHeight / 2.0f), mouseX, mouseY, partialTicks);
        }
        String text = "\u00a7l" + LanguageManager.translate("gui.beastiary.player.spirit") + ": ";
        this.getFontRenderer().func_175065_a(text, (float)nextX, (float)nextY, 0xFFFFFF, true);
        int barX = nextX + this.getFontRenderer().func_78256_a(text);
        int spiritMax = Math.round((float)this.playerExt.spiritMax / (float)this.playerExt.spiritCharge);
        int spiritReserved = (int)Math.floor((double)this.playerExt.spiritReserved / (double)this.playerExt.spiritCharge);
        int spiritAvailable = (int)Math.floor((double)this.playerExt.spirit / (double)this.playerExt.spiritCharge);
        float spiritFilling = (float)this.playerExt.spirit / (float)this.playerExt.spiritCharge - (float)spiritAvailable;
        this.drawBar(AssetManager.getTexture("GUIPetSpiritEmpty"), barX, nextY, 0.0f, 9.0f, 9.0f, spiritMax, 10);
        this.drawBar(AssetManager.getTexture("GUIPetSpirit"), barX, nextY, 0.0f, 9.0f, 9.0f, spiritAvailable, 10);
        if (spiritFilling > 0.0f) {
            this.drawTexture(AssetManager.getTexture("GUIPetSpiritFilling"), barX + 9 * spiritAvailable, nextY, 0.0f, spiritFilling, 1.0f, spiritFilling * 9.0f, 9.0f);
        }
        this.drawBar(AssetManager.getTexture("GUIPetSpiritUsed"), barX, nextY, 0.0f, 9.0f, 9.0f, spiritReserved, -10);
        if (this.playerExt.selectedPet != null) {
            nextY += 4 + this.getFontRenderer().func_78267_b(text, this.colRightWidth);
            text = "\u00a7l" + LanguageManager.translate("creature.stat.spirit") + ": ";
            this.getFontRenderer().func_175065_a(text, (float)nextX, (float)nextY, 0xFFFFFF, true);
            this.drawLevel(this.playerExt.selectedPet.getCreatureInfo(), AssetManager.getTexture("GUIPetLevel"), nextX + this.getFontRenderer().func_78256_a(text), nextY);
            nextY += 4 + this.getFontRenderer().func_78267_b(text, this.colRightWidth);
            text = this.playerExt.selectedPet.respawnTime <= 0 ? "\u00a7l" + LanguageManager.translate("creature.stat.health") + ": " : "\u00a7l" + LanguageManager.translate("creature.stat.respawning") + ": ";
            this.getFontRenderer().func_175065_a(text, (float)nextX, (float)nextY, 0xFFFFFF, true);
            int barY = nextY - 1;
            int barWidth = 80;
            int barHeight = 10;
            barX = nextX + this.getFontRenderer().func_78256_a(text);
            int barCenter = barX + barWidth / 2;
            this.drawTexture(AssetManager.getTexture("GUIPetBarEmpty"), barX, barY, 0.0f, 1.0f, 1.0f, barWidth, barHeight);
            if (this.playerExt.selectedPet.respawnTime <= 0) {
                float healthNormal = Math.min(this.playerExt.selectedPet.getHealth() / this.playerExt.selectedPet.getMaxHealth(), 1.0f);
                this.drawTexture(AssetManager.getTexture("GUIPetBarHealth"), barX, barY, 0.0f, healthNormal, 1.0f, (float)barWidth * healthNormal, barHeight);
                String healthText = String.format("%.0f", Float.valueOf(this.playerExt.selectedPet.getHealth())) + "/" + String.format("%.0f", Float.valueOf(this.playerExt.selectedPet.getMaxHealth()));
                this.getFontRenderer().func_78276_b(healthText, barCenter - this.getFontRenderer().func_78256_a(healthText) / 2, barY + 1, 0xFFFFFF);
            } else {
                float respawnNormal = 1.0f - (float)this.playerExt.selectedPet.respawnTime / (float)this.playerExt.selectedPet.respawnTimeMax;
                this.drawTexture(AssetManager.getTexture("GUIPetBarRespawn"), barX, barY, 0.0f, respawnNormal, 1.0f, (float)barWidth * respawnNormal, barHeight);
                this.getFontRenderer().func_78276_b("" + this.playerExt.selectedPet.respawnTime / 20 + "s", barX + barWidth + 10, nextY, 0xFFFFFF);
            }
            nextY += 4 + this.getFontRenderer().func_78267_b(text, this.colRightWidth);
            text = "\u00a7l" + LanguageManager.translate("creature.stat.experience") + ": ";
            this.getFontRenderer().func_175065_a(text, (float)nextX, (float)nextY, 0xFFFFFF, true);
            barY = nextY - 1;
            barWidth = 80;
            barHeight = 10;
            barX = nextX + this.getFontRenderer().func_78256_a(text);
            barCenter = barX + barWidth / 2;
            this.drawTexture(AssetManager.getTexture("GUIPetBarEmpty"), barX, barY, 0.0f, 1.0f, 1.0f, barWidth, barHeight);
            float experienceNormal = (float)this.playerExt.selectedPet.getExperience() / (float)this.playerExt.selectedPet.getMaxExperience();
            this.drawTexture(AssetManager.getTexture("GUIBarExperience"), barX, barY, 0.0f, experienceNormal, 1.0f, (float)barWidth * experienceNormal, barHeight);
            String experienceText = this.playerExt.selectedPet.getExperience() + "/" + this.playerExt.selectedPet.getMaxExperience();
            this.getFontRenderer().func_78276_b(experienceText, barCenter - this.getFontRenderer().func_78256_a(experienceText) / 2, barY + 1, 0xFFFFFF);
        } else {
            nextY += 4 + this.getFontRenderer().func_78267_b(text, this.colRightWidth);
            text = LanguageManager.translate("gui.beastiary.pets.select");
            this.drawSplitString(text, nextX, nextY, width, 0xFFFFFF, true);
        }
        int buttonHeight = 20;
        int buttonSpacing = 2;
        int buttonY = this.colRightY + this.colRightHeight - (buttonHeight + buttonSpacing) * 3;
        if (this.playerExt.selectedPet != null && !this.playerExt.selectedPet.releaseEntity) {
            this.getFontRenderer().func_175065_a("\u00a7l" + LanguageManager.translate("gui.pet.actions"), (float)this.colRightX, (float)(buttonY + 6), 0xFFFFFF, true);
            this.getFontRenderer().func_175065_a("\u00a7l" + LanguageManager.translate("gui.pet.stance"), (float)this.colRightX, (float)((buttonY += buttonHeight + buttonSpacing) + 6), 0xFFFFFF, true);
            this.getFontRenderer().func_175065_a("\u00a7l" + LanguageManager.translate("gui.pet.movement"), (float)this.colRightX, (float)((buttonY += buttonHeight + buttonSpacing) + 6), 0xFFFFFF, true);
        }
        if (this.playerExt.selectedPet != null && this.playerExt.selectedPet.releaseEntity) {
            text = LanguageManager.translate("gui.pet.release.confirm");
            nextX = this.colRightX;
            nextY = this.colRightY + Math.round((float)this.colRightHeight / 2.0f) - Math.round((float)buttonHeight / 2.0f) - this.getFontRenderer().func_78267_b(text, this.colRightWidth) - 2;
            this.drawSplitString(text, nextX, nextY, this.colRightWidth, 0xFFFFFF, true);
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        if (this.playerExt.selectedPet != null && this.playerExt.selectedPet.summonSet != null) {
            PetEntry petEntry = this.playerExt.selectedPet;
            if (button.field_146127_k >= this.petCommandIdStart && button.field_146127_k < this.releaseConfirmId) {
                int petCommandId = button.field_146127_k - this.petCommandIdStart;
                if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.ACTIVE.id) {
                    petEntry.spawningActive = !petEntry.spawningActive;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.TELEPORT.id) {
                    petEntry.teleportEntity = true;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.PVP.id) {
                    petEntry.summonSet.pvp = !petEntry.summonSet.pvp;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.RELEASE.id) {
                    petEntry.releaseEntity = true;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.PASSIVE.id) {
                    petEntry.summonSet.passive = true;
                    petEntry.summonSet.assist = false;
                    petEntry.summonSet.aggressive = false;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.DEFENSIVE.id) {
                    petEntry.summonSet.passive = false;
                    petEntry.summonSet.assist = false;
                    petEntry.summonSet.aggressive = false;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.ASSIST.id) {
                    petEntry.summonSet.passive = false;
                    petEntry.summonSet.assist = true;
                    petEntry.summonSet.aggressive = false;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.AGGRESSIVE.id) {
                    petEntry.summonSet.passive = false;
                    petEntry.summonSet.assist = true;
                    petEntry.summonSet.aggressive = true;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.FOLLOW.id) {
                    petEntry.summonSet.following = true;
                    petEntry.summonSet.sitting = false;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.WANDER.id) {
                    petEntry.summonSet.following = false;
                    petEntry.summonSet.sitting = false;
                } else if (petCommandId == BaseCreatureEntity.PET_COMMAND_ID.SIT.id) {
                    petEntry.summonSet.following = false;
                    petEntry.summonSet.sitting = true;
                }
                this.playerExt.sendPetEntryToServer(petEntry);
                if (this.playerExt.selectedPet == null) {
                    PetsBeastiaryScreen.openToPlayer(this.player);
                }
                return;
            }
            if (button.field_146127_k == this.releaseCancelId) {
                petEntry.releaseEntity = false;
                return;
            }
            if (button.field_146127_k == this.releaseConfirmId) {
                this.playerExt.selectedPet = null;
                this.playerExt.sendPetEntryRemoveRequest(petEntry);
                return;
            }
        }
        super.func_146284_a(button);
    }

    @Override
    public int getDisplaySubspecies(CreatureInfo creatureInfo) {
        return this.playerExt.selectedPet.subspeciesIndex;
    }

    @Override
    public int getDisplayVariant(CreatureInfo creatureInfo) {
        return this.playerExt.selectedPet.variantIndex;
    }

    @Override
    public void playCreatureSelectSound(CreatureInfo creatureInfo) {
        String soundSuffix = "";
        if (this.playerExt.selectedPet != null && creatureInfo.getSubspecies((int)this.playerExt.selectedPet.subspeciesIndex).name != null) {
            soundSuffix = soundSuffix + "." + creatureInfo.getSubspecies((int)this.playerExt.selectedPet.subspeciesIndex).name;
        }
        SoundEvent soundEvent = AssetManager.getSound(creatureInfo.getName() + soundSuffix + "_say");
        this.player.func_130014_f_().func_184148_a(this.player, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, soundEvent, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }
}

