/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.renderer;

import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.CustomProjectileEntity;
import com.lycanitesmobs.core.entity.EntityParticle;
import com.lycanitesmobs.core.entity.EntityProjectileLaser;
import com.lycanitesmobs.core.entity.LaserEndProjectileEntity;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderProjectileSprite
extends Render {
    private float scale;
    private int renderTime = 0;
    Class projectileClass;
    protected ModelBase laserModel = new ModelBase(){};
    private ModelRenderer laserBox;

    public RenderProjectileSprite(RenderManager renderManager, Class projectileClass) {
        super(renderManager);
        this.projectileClass = projectileClass;
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float par8, float par9) {
        if (this.renderTime++ > 0x7FFFFFFE) {
            this.renderTime = 0;
        }
        if (entity instanceof CustomProjectileEntity && ((CustomProjectileEntity)entity).getLaserEnd() != null) {
            this.renderLaser((CustomProjectileEntity)entity, x, y, z, par8, par9, ((CustomProjectileEntity)entity).laserWidth);
            return;
        }
        if (entity instanceof EntityProjectileLaser) {
            this.renderOldLaser((BaseProjectileEntity)entity, ((EntityProjectileLaser)entity).getLaserEnd(), x, y, z, par8, par9, ((EntityProjectileLaser)entity).getLaserWidth(), ((EntityProjectileLaser)entity).getLength());
            return;
        }
        this.renderProjectile(entity, x, y, z, par8, par9);
    }

    public void renderProjectile(Entity entity, double x, double y, double z, float par8, float par9) {
        ResourceLocation texture;
        double scale = 1.0;
        if (entity instanceof CustomProjectileEntity && ((CustomProjectileEntity)entity).projectileInfo == null) {
            return;
        }
        if (entity instanceof BaseProjectileEntity) {
            BaseProjectileEntity baseProjectileEntity = (BaseProjectileEntity)entity;
            scale *= (double)baseProjectileEntity.getProjectileScale();
            y += (double)baseProjectileEntity.getTextureOffsetY();
        }
        if ((texture = this.func_110775_a(entity)) == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179091_B();
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        this.func_110776_a(texture);
        this.renderTexture(Tessellator.func_178181_a(), entity);
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
    }

    private void renderTexture(Tessellator tessellator, Entity entity) {
        double minU = 0.0;
        double maxU = 1.0;
        double minV = 0.0;
        double maxV = 1.0;
        double textureWidth = 0.5;
        double textureHeight = 0.5;
        double offsetY = 0.0;
        if (entity instanceof BaseProjectileEntity) {
            BaseProjectileEntity entityProjectile = (BaseProjectileEntity)entity;
            if (entityProjectile.animationFrameMax > 0) {
                minV = (float)entityProjectile.animationFrame / (float)entityProjectile.animationFrameMax;
                maxV = minV + (double)(1.0f / (float)entityProjectile.animationFrameMax);
                textureWidth *= (double)entityProjectile.textureScale;
                textureHeight *= (double)entityProjectile.textureScale;
                offsetY = entityProjectile.textureOffsetY;
            }
        }
        GlStateManager.func_179114_b((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)(this.field_76990_c.field_78733_k.field_74320_O == 2 ? -1 : 1) * this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(-this.scale / 2.0f), (float)(-this.scale / 2.0f), (float)(-this.scale / 2.0f));
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c(entity));
        }
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        vertexbuffer.func_181662_b(-textureWidth, -textureHeight + textureHeight / 2.0 + offsetY, 0.0).func_187315_a(minU, maxV).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(textureWidth, -textureHeight + textureHeight / 2.0 + offsetY, 0.0).func_187315_a(maxU, maxV).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(textureWidth, textureHeight + textureHeight / 2.0 + offsetY, 0.0).func_187315_a(maxU, minV).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_181662_b(-textureWidth, textureHeight + textureHeight / 2.0 + offsetY, 0.0).func_187315_a(minU, minV).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    public void renderLaser(CustomProjectileEntity entity, double x, double y, double z, float par8, float par9, float scale) {
        if (this.laserBox == null) {
            this.laserBox = new ModelRenderer(this.laserModel, 0, 0);
            this.laserBox.func_78789_a(-(scale / 2.0f), -(scale / 2.0f), 0.0f, (int)scale, (int)scale, 16);
            this.laserBox.field_78800_c = 0.0f;
            this.laserBox.field_78797_d = 0.0f;
            this.laserBox.field_78798_e = 0.0f;
        }
        float factor = 0.0625f;
        float lastSegment = 0.0f;
        double length = entity.func_174791_d().func_72438_d(entity.getLaserEnd());
        if (length <= 0.0) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        this.func_110776_a(this.getLaserTexture(entity));
        float[] angles = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float dx = (float)(entity.getLaserEnd().field_72450_a - entity.field_70165_t);
        float dy = (float)(entity.getLaserEnd().field_72448_b - entity.field_70163_u);
        float dz = (float)(entity.getLaserEnd().field_72449_c - entity.field_70161_v);
        angles[0] = (float)Math.toDegrees(Math.atan2(dz, dy)) - 90.0f;
        angles[1] = (float)Math.toDegrees(Math.atan2(dx, dz));
        angles[2] = (float)Math.toDegrees(Math.atan2(dx, dy)) - 90.0f;
        float dr = (float)Math.sqrt(dx * dx + dz * dz);
        angles[3] = (float)Math.toDegrees(Math.atan2(dr, dy)) - 90.0f;
        GlStateManager.func_179114_b((float)angles[1], (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angles[3], (float)1.0f, (float)0.0f, (float)0.0f);
        float segment = 0.0f;
        while ((double)segment <= length - 1.0) {
            this.laserBox.func_78785_a(factor);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            lastSegment = segment;
            segment += 1.0f;
        }
        GlStateManager.func_179139_a((double)(length - (double)(lastSegment += 1.0f)), (double)1.0, (double)1.0);
        this.laserBox.func_78785_a(factor);
        GlStateManager.func_179121_F();
    }

    public void renderOldLaser(BaseProjectileEntity entity, LaserEndProjectileEntity laserEnd, double x, double y, double z, float par8, float par9, float scale, float length) {
        if (this.laserBox == null) {
            this.laserBox = new ModelRenderer(this.laserModel, 0, 0);
            this.laserBox.func_78789_a(-(scale / 2.0f), -(scale / 2.0f), 0.0f, (int)scale, (int)scale, 16);
            this.laserBox.field_78800_c = 0.0f;
            this.laserBox.field_78797_d = 0.0f;
            this.laserBox.field_78798_e = 0.0f;
        }
        float factor = 0.0625f;
        float lastSegment = 0.0f;
        if (length <= 0.0f) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        this.func_110776_a(this.getLaserTexture(entity));
        float[] angles = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        if (laserEnd != null) {
            float dx = (float)(laserEnd.field_70165_t - entity.field_70165_t);
            float dy = (float)(laserEnd.field_70163_u - entity.field_70163_u);
            float dz = (float)(laserEnd.field_70161_v - entity.field_70161_v);
            angles[0] = (float)Math.toDegrees(Math.atan2(dz, dy)) - 90.0f;
            angles[1] = (float)Math.toDegrees(Math.atan2(dx, dz));
            angles[2] = (float)Math.toDegrees(Math.atan2(dx, dy)) - 90.0f;
            float dr = (float)Math.sqrt(dx * dx + dz * dz);
            angles[3] = (float)Math.toDegrees(Math.atan2(dr, dy)) - 90.0f;
        }
        GlStateManager.func_179114_b((float)angles[1], (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)angles[3], (float)1.0f, (float)0.0f, (float)0.0f);
        for (float segment = 0.0f; segment <= length - 1.0f; segment += 1.0f) {
            this.laserBox.func_78785_a(factor);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            lastSegment = segment;
        }
        GlStateManager.func_179152_a((float)(length - (lastSegment += 1.0f)), (float)1.0f, (float)1.0f);
        this.laserBox.func_78785_a(factor);
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        if (entity instanceof BaseProjectileEntity) {
            return ((BaseProjectileEntity)entity).getTexture();
        }
        if (entity instanceof EntityParticle) {
            return ((EntityParticle)entity).getTexture();
        }
        return null;
    }

    protected ResourceLocation getLaserTexture(BaseProjectileEntity entity) {
        if (entity instanceof CustomProjectileEntity) {
            return ((CustomProjectileEntity)entity).getBeamTexture();
        }
        if (entity instanceof EntityProjectileLaser) {
            return ((EntityProjectileLaser)entity).getBeamTexture();
        }
        return this.func_110775_a((Entity)entity);
    }
}

