/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.renderer.layer;

import com.lycanitesmobs.client.renderer.RenderCreature;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerCreatureEffect
extends LayerCreatureBase {
    public String textureSuffix;
    public boolean subspecies = true;
    public boolean glow = false;
    public int blending = 0;
    public Vector2f scrollSpeed;

    public LayerCreatureEffect(RenderCreature renderer, String textureSuffix) {
        super(renderer);
        this.name = textureSuffix;
        this.textureSuffix = textureSuffix;
    }

    public LayerCreatureEffect(RenderCreature renderer, String textureSuffix, boolean glow, int blending, boolean subspecies) {
        super(renderer);
        this.name = textureSuffix;
        this.textureSuffix = textureSuffix;
        this.glow = glow;
        this.blending = blending;
        this.subspecies = subspecies;
    }

    public LayerCreatureEffect(RenderCreature renderer, String name, String textureSuffix, boolean glow, int blending, boolean subspecies) {
        super(renderer);
        this.name = name;
        this.textureSuffix = textureSuffix;
        this.glow = glow;
        this.blending = blending;
        this.subspecies = subspecies;
    }

    @Override
    public Vector4f getPartColor(String partName, BaseCreatureEntity entity, boolean trophy) {
        return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public ResourceLocation getLayerTexture(BaseCreatureEntity entity) {
        return entity.getTexture(this.textureSuffix);
    }

    @Override
    public void onRenderStart(Entity entity, boolean trophy) {
        int i = entity.func_70070_b();
        if (this.glow) {
            GlStateManager.func_179140_f();
            i = 0xF000F0;
        }
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        if (this.blending == BLEND.ADD.id) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        } else if (this.blending == BLEND.SUB.id) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
    }

    @Override
    public void onRenderFinish(Entity entity, boolean trophy) {
        if (this.glow) {
            GlStateManager.func_179145_e();
        }
    }

    @Override
    public Vector2f getTextureOffset(String partName, BaseCreatureEntity entity, boolean trophy, float loop) {
        if (this.scrollSpeed == null) {
            this.scrollSpeed = new Vector2f(0.0f, 0.0f);
        }
        return new Vector2f(loop * this.scrollSpeed.x, loop * this.scrollSpeed.y);
    }

    public static enum BLEND {
        NORMAL(0),
        ADD(1),
        SUB(2);

        public final int id;

        private BLEND(int value) {
            this.id = value;
        }

        public int getValue() {
            return this.id;
        }
    }
}

