/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.Variant;
import net.minecraft.world.EnumDifficulty;

public class CreatureStats {
    public static int BASE_LEVELUP_EXPERIENCE = 1000;
    public static String[] STAT_NAMES = new String[]{"health", "defense", "armor", "speed", "damage", "attackSpeed", "rangedSpeed", "effect", "amplifier", "pierce", "sight"};
    public BaseCreatureEntity entity;

    public CreatureStats(BaseCreatureEntity entity) {
        this.entity = entity;
    }

    public double getHealth() {
        String statName = "health";
        double statValue = this.entity.creatureInfo.health;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getVariantMultiplier(statName);
            if (this.entity.extraMobBehaviour != null) {
                statValue *= this.entity.extraMobBehaviour.multiplierHealth;
                statValue += (double)this.entity.extraMobBehaviour.boostHealth;
            }
        }
        return Math.max(0.0, statValue *= this.getLevelMultiplier(statName));
    }

    public double getDefense() {
        String statName = "defense";
        double statValue = this.entity.creatureInfo.defense;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getVariantMultiplier(statName);
            if (this.entity.extraMobBehaviour != null) {
                statValue *= this.entity.extraMobBehaviour.multiplierDefense;
                statValue += (double)this.entity.extraMobBehaviour.boostDefense;
            }
        }
        return statValue *= this.getLevelMultiplier(statName);
    }

    public double getArmor() {
        String statName = "armor";
        double statValue = this.entity.creatureInfo.armor;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getVariantMultiplier(statName);
            if (this.entity.extraMobBehaviour != null) {
                statValue *= this.entity.extraMobBehaviour.multiplierArmor;
                statValue += (double)this.entity.extraMobBehaviour.boostArmor;
            }
        }
        return statValue *= this.getLevelMultiplier(statName);
    }

    public double getSpeed() {
        String statName = "speed";
        double statValue = this.entity.creatureInfo.speed / 100.0;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getVariantMultiplier(statName);
            if (this.entity.extraMobBehaviour != null) {
                statValue *= this.entity.extraMobBehaviour.multiplierSpeed;
                statValue += (double)this.entity.extraMobBehaviour.boostSpeed;
            }
        }
        return statValue *= this.getLevelMultiplier(statName);
    }

    public double getDamage() {
        String statName = "damage";
        double statValue = this.entity.creatureInfo.damage;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getVariantMultiplier(statName);
            if (this.entity.extraMobBehaviour != null) {
                statValue *= this.entity.extraMobBehaviour.multiplierDamage;
                statValue += (double)this.entity.extraMobBehaviour.boostDamage;
            }
        }
        return statValue *= this.getLevelMultiplier(statName);
    }

    public double getAttackSpeed() {
        String statName = "attackSpeed";
        double statValue = this.entity.creatureInfo.attackSpeed;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getVariantMultiplier(statName);
            if (this.entity.extraMobBehaviour != null) {
                statValue *= this.entity.extraMobBehaviour.multiplierHaste;
                statValue += (double)this.entity.extraMobBehaviour.boostHaste;
            }
        }
        return statValue *= this.getLevelMultiplier(statName);
    }

    public double getRangedSpeed() {
        String statName = "rangedSpeed";
        double statValue = this.entity.creatureInfo.rangedSpeed;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getVariantMultiplier(statName);
            if (this.entity.extraMobBehaviour != null) {
                statValue *= this.entity.extraMobBehaviour.multiplierHaste;
                statValue += (double)this.entity.extraMobBehaviour.boostHaste;
            }
        }
        return statValue *= this.getLevelMultiplier(statName);
    }

    public double getEffect() {
        String statName = "effect";
        double statValue = this.entity.creatureInfo.effectDuration;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getVariantMultiplier(statName);
            if (this.entity.extraMobBehaviour != null) {
                statValue *= this.entity.extraMobBehaviour.multiplierEffect;
                statValue += (double)this.entity.extraMobBehaviour.boostEffect;
            }
        }
        return statValue *= this.getLevelMultiplier(statName);
    }

    public double getAmplifier() {
        String statName = "amplifier";
        double statValue = this.entity.creatureInfo.effectAmplifier;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getVariantMultiplier(statName);
        }
        return statValue *= this.getLevelMultiplier(statName);
    }

    public double getPierce() {
        String statName = "pierce";
        double statValue = this.entity.creatureInfo.pierce;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getVariantMultiplier(statName);
            if (this.entity.extraMobBehaviour != null) {
                statValue *= this.entity.extraMobBehaviour.multiplierPierce;
                statValue += (double)this.entity.extraMobBehaviour.boostPierce;
            }
        }
        return statValue *= this.getLevelMultiplier(statName);
    }

    public double getSight() {
        String statName = "sight";
        double statValue = this.entity.creatureInfo.sight;
        if (!this.entity.isTamed()) {
            statValue *= this.getDifficultyMultiplier(statName);
            statValue *= this.getVariantMultiplier(statName);
        }
        return statValue *= this.getLevelMultiplier(statName);
    }

    public double getKnockbackResistance() {
        return this.entity.creatureInfo.knockbackResistance;
    }

    protected double getDifficultyMultiplier(String stat) {
        EnumDifficulty difficulty = this.entity.func_130014_f_().func_175659_aa();
        String difficultyName = "Easy";
        if (difficulty.func_151525_a() >= 3) {
            difficultyName = "Hard";
        } else if (difficulty == EnumDifficulty.NORMAL) {
            difficultyName = "Normal";
        }
        return CreatureManager.getInstance().getDifficultyMultiplier(difficultyName.toUpperCase(), stat.toUpperCase());
    }

    protected double getVariantMultiplier(String stat) {
        if (this.entity.getVariant() != null && Variant.STAT_MULTIPLIERS.containsKey(this.entity.getVariant().rarity.toUpperCase() + "-" + stat.toUpperCase())) {
            return Variant.STAT_MULTIPLIERS.get(this.entity.getVariant().rarity.toUpperCase() + "-" + stat.toUpperCase());
        }
        return 1.0;
    }

    protected double getLevelMultiplier(String stat) {
        double statLevel = Math.max(0, this.entity.getLevel() - 1);
        return 1.0 + statLevel * CreatureManager.getInstance().getLevelMultiplier(stat.toUpperCase());
    }

    public int getExperienceForNextLevel() {
        return BASE_LEVELUP_EXPERIENCE + Math.round((float)(BASE_LEVELUP_EXPERIENCE * (this.entity.getLevel() - 1)) * 0.25f);
    }
}

