/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.PlayerControlGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindAttackTargetGoal;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityPinky
extends RideableCreatureEntity {
    PlayerControlGoal playerControlAI;

    public EntityPinky(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEAD;
        this.hasAttackSound = true;
        this.spreadFire = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setTargetClass(EntityPigZombie.class).setSpeed(1.5).setDamageScale(8.0).setRange(2.5));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setTargetClass(EntityEnderman.class).setSpeed(1.5).setDamageScale(8.0).setRange(2.5));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setSpeed(1.5));
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (EntityAIBase)new FindAttackTargetGoal(this).addTargets(EntityPigZombie.class));
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (EntityAIBase)new FindAttackTargetGoal(this).addTargets(EntityEnderman.class));
    }

    @Override
    public boolean shouldCreatureGroupFlee(EntityLivingBase target) {
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_130014_f_().func_175624_G().func_82747_f() != -1) {
            this.setFarmed();
        }
    }

    @Override
    public void riderEffects(EntityLivingBase rider) {
        if (rider.func_70644_a(MobEffects.field_82731_v)) {
            rider.func_184589_d(MobEffects.field_82731_v);
        }
        if (rider.func_70027_ad()) {
            rider.func_70015_d(0);
        }
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        this.specialAttack();
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 20.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    @Override
    public boolean attackMelee(Entity target, double damageScale) {
        if (!super.attackMelee(target, damageScale)) {
            return false;
        }
        if ((target instanceof EntityAnimal || target instanceof BaseCreatureEntity && ((BaseCreatureEntity)target).creatureInfo.isFarmable()) && target.field_70131_O >= 1.0f) {
            this.breed();
        }
        return true;
    }

    public void specialAttack() {
        double distance = 5.0;
        List possibleTargets = this.func_130014_f_().func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(distance, distance, distance), possibleTarget -> possibleTarget.func_70089_S() && possibleTarget != this && !this.func_184215_y((Entity)possibleTarget) && !this.func_184191_r((Entity)possibleTarget) && this.func_70686_a(possibleTarget.getClass()) && this.canAttackEntity((EntityLivingBase)possibleTarget));
        if (!possibleTargets.isEmpty()) {
            for (EntityLivingBase possibleTarget2 : possibleTargets) {
                boolean doDamage = true;
                if (this.getRider() instanceof EntityPlayer && MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((EntityPlayer)this.getRider(), (Entity)possibleTarget2))) {
                    doDamage = false;
                }
                if (!doDamage) continue;
                possibleTarget2.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 200, 0));
            }
        }
        this.playAttackSound();
        this.triggerAttackCooldown();
    }

    @Override
    public boolean canBeTempted() {
        return this.func_70631_g_();
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public float getFallResistance() {
        return 10.0f;
    }

    @Override
    public boolean isBreedingItem(ItemStack itemStack) {
        return false;
    }
}

