/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class EntitySpriggan
extends TameableCreatureEntity
implements IMob {
    public int farmingRate = 20;
    private int farmingTick = 0;
    BaseProjectileEntity projectile = null;

    public EntitySpriggan(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = false;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackRangedGoal(this).setSpeed(0.75).setStaminaTime(100).setRange(8.0f).setMinChaseDistance(4.0f));
    }

    @Override
    public void loadCreatureFlags() {
        this.farmingRate = this.creatureInfo.getFlag("farmingRate", this.farmingRate);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70086_ai() >= 0) {
            if (this.func_70090_H()) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 60, 2));
            } else if (this.waterContact()) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 60, 1));
            }
        }
        int currentFarmingRate = this.farmingRate;
        if (this.isTamed() && currentFarmingRate > 0) {
            if (this.isPetType("familiar")) {
                currentFarmingRate = this.farmingRate * 10;
            }
            if (this.subspecies != null) {
                currentFarmingRate = Math.max(1, Math.round((float)this.farmingRate / 3.0f));
            }
            ++this.farmingTick;
            int farmingRange = 16;
            int farmingHeight = 4;
            for (int x = (int)this.field_70165_t - farmingRange; x <= (int)this.field_70165_t + farmingRange; ++x) {
                for (int y = (int)this.field_70163_u - farmingHeight; y <= (int)this.field_70163_u + farmingHeight; ++y) {
                    for (int z = (int)this.field_70161_v - farmingRange; z <= (int)this.field_70161_v + farmingRange; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        Block farmingBlock = this.func_130014_f_().func_180495_p(pos).func_177230_c();
                        if (!(farmingBlock instanceof IPlantable) || !(farmingBlock instanceof IGrowable) || farmingBlock == Blocks.field_150329_H || farmingBlock == Blocks.field_150398_cm) continue;
                        if (!this.func_130014_f_().field_72995_K && this.farmingTick % currentFarmingRate == 0 && farmingBlock.func_149653_t()) {
                            this.func_130014_f_().func_180497_b(pos, farmingBlock, currentFarmingRate, 1);
                        }
                        if (!this.func_130014_f_().field_72995_K || this.farmingTick % 40 != 0) continue;
                        double d0 = this.func_70681_au().nextGaussian() * 0.02;
                        double d1 = this.func_70681_au().nextGaussian() * 0.02;
                        double d2 = this.func_70681_au().nextGaussian() * 0.02;
                        this.func_130014_f_().func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)((float)x + this.func_70681_au().nextFloat()), (double)y + (double)this.func_70681_au().nextFloat(), (double)((float)z + this.func_70681_au().nextFloat()), d0, d1, d2, new int[0]);
                    }
                }
            }
        }
        if (this.func_130014_f_().field_72995_K && !CreatureManager.getInstance().config.disableBlockParticles) {
            for (int i = 0; i < 2; ++i) {
                int[] nArray = new int[1];
                nArray[0] = BlockTallGrass.func_176210_f((IBlockState)Blocks.field_150329_H.func_176223_P());
                this.func_130014_f_().func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, nArray);
            }
        }
    }

    @Override
    public void attackRanged(Entity target, float range) {
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile("lifedrain");
        if (projectileInfo == null) {
            return;
        }
        if (this.projectile != null && this.projectile.func_70089_S()) {
            this.projectile.projectileLife = 20;
        } else {
            this.projectile = null;
        }
        if (this.projectile == null) {
            this.projectile = projectileInfo.createProjectile(this.func_130014_f_(), (EntityLivingBase)this);
            this.func_184185_a(this.projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.func_130014_f_().func_72838_d((Entity)this.projectile);
        }
        super.attackRanged(target, range);
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 2.0f;
        }
        if (damageSrc.func_76346_g() != null) {
            EntityLivingBase entityLiving;
            ItemStack heldItem = ItemStack.field_190927_a;
            if (damageSrc.func_76346_g() instanceof EntityLivingBase && !(entityLiving = (EntityLivingBase)damageSrc.func_76346_g()).func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
                heldItem = entityLiving.func_184586_b(EnumHand.MAIN_HAND);
            }
            if (ObjectLists.isAxe(heldItem)) {
                return 2.0f;
            }
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }
}

