/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info;

import com.google.gson.JsonObject;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.CreatureStats;
import com.lycanitesmobs.core.info.CreatureInfo;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;

public class Variant {
    public static int BASE_WEIGHT = 400;
    public static Map<String, Integer> COMMON_WEIGHTS = new HashMap<String, Integer>(){
        {
            this.put("common", 100);
            this.put("uncommon", 20);
            this.put("rare", 2);
            this.put("legendary", 1);
        }
    };
    public static Map<String, Double> STAT_MULTIPLIERS = new HashMap<String, Double>();
    public static int UNCOMMON_DROP_SCALE = 2;
    public static int RARE_DROP_SCALE = 5;
    public static double UNCOMMON_EXPERIENCE_SCALE = 2.0;
    public static double RARE_EXPERIENCE_SCALE = 10.0;
    public static int UNCOMMON_SPAWN_DAY_MIN = 0;
    public static int RARE_SPAWN_DAY_MIN = 0;
    public static boolean RARE_DESPAWNING = false;
    public static boolean RARE_HEALTH_BARS = false;
    public int index;
    public double scale = 1.0;
    public String color;
    public String rarity = "uncommon";
    public int weight = BASE_WEIGHT;

    public static void loadGlobalSettings(ConfigBase config) {
        BASE_WEIGHT = config.getInt("Mob Variations", "Variant Base Weight", BASE_WEIGHT, "The weight of base variants (regular mob colors).");
        COMMON_WEIGHTS.put("uncommon", config.getInt("Mob Variations", "Variant Uncommon Weight", COMMON_WEIGHTS.get("uncommon"), "The weight of uncommon variants (such as Azure, Verdant, Scarlet, etc)."));
        COMMON_WEIGHTS.put("rare", config.getInt("Mob Variations", "Variant Rare Weight", COMMON_WEIGHTS.get("rare"), "The weight of rare variants (such as Lunar or Celestial)."));
        String[] subspeciesNames = new String[]{"uncommon", "rare"};
        STAT_MULTIPLIERS = new HashMap<String, Double>();
        boolean foundOldStatsCategory = config.setCategoryReplacedComment("Subspecies Multipliers", "Variant Multipliers");
        config.setCategoryComment("Variant Multipliers", "Here you can scale the stats of every mob on a per variant basis.");
        for (String subspeciesName : subspeciesNames) {
            for (String statName : CreatureStats.STAT_NAMES) {
                double defaultValue = 1.0;
                if ("uncommon".equals(subspeciesName) && "health".equals(statName)) {
                    defaultValue = 2.0;
                }
                if ("rare".equals(subspeciesName)) {
                    if ("health".equals(statName)) {
                        defaultValue = 20.0;
                    } else if ("attackSpeed".equals(statName)) {
                        defaultValue = 2.0;
                    } else if ("rangedSpeed".equals(statName)) {
                        defaultValue = 2.0;
                    } else if ("effect".equals(statName)) {
                        defaultValue = 2.0;
                    }
                }
                if (foundOldStatsCategory) {
                    defaultValue = config.getDouble("Subspecies Multipliers", subspeciesName + " " + statName, defaultValue);
                }
                STAT_MULTIPLIERS.put((subspeciesName + "-" + statName).toUpperCase(), config.getDouble("Variant Multipliers", subspeciesName + " " + statName, defaultValue));
            }
        }
        UNCOMMON_DROP_SCALE = config.getInt("Mob Variations", "Variant Uncommon Item Drops Scale", UNCOMMON_DROP_SCALE, "When a creature with the uncommon subspecies (Azure, Verdant, etc) dies, its item drops amount is multiplied by this value.");
        RARE_DROP_SCALE = config.getInt("Mob Variations", "Variant Rare Item Drops Scale", RARE_DROP_SCALE, "When a creature with the rare subspecies (Celestial, Lunar, etc) dies, its item drops amount is multiplied by this value.");
        UNCOMMON_EXPERIENCE_SCALE = config.getDouble("Mob Variations", "Variant Uncommon Experience Scale", UNCOMMON_EXPERIENCE_SCALE, "When a creature with the uncommon subspecies (Azure, Verdant, etc) dies, its experience amount is multiplied by this value.");
        RARE_EXPERIENCE_SCALE = config.getDouble("Mob Variations", "Variant Rare Experience Scale", RARE_EXPERIENCE_SCALE, "When a creature with the rare subspecies (Celestial, Lunar, etc) dies, its experience amount is multiplied by this value.");
        UNCOMMON_SPAWN_DAY_MIN = config.getInt("Mob Variations", "Variant Uncommon Spawn Day Min", UNCOMMON_SPAWN_DAY_MIN, "The minimum amount of days before uncommon species start to spawn.");
        RARE_SPAWN_DAY_MIN = config.getInt("Mob Variations", "Variant Rare Spawn Day Min", RARE_SPAWN_DAY_MIN, "The minimum amount of days before rare species start to spawn.");
        RARE_DESPAWNING = config.getBool("Mob Variations", "Variant Rare Despawning", RARE_DESPAWNING, "If set to true, rare subspecies such as the Lunar Grue will despawn naturally over time.");
        RARE_HEALTH_BARS = config.getBool("Mob Variations", "Variant Rare Health Bars", RARE_HEALTH_BARS, "If set to true, rare subspecies such as the Lunar Grue or Celestial Geonach will display boss health bars.");
    }

    public static Variant createFromJSON(CreatureInfo creatureInfo, JsonObject json) {
        String rarity = "uncommon";
        if (json.has("rarity")) {
            rarity = json.get("rarity").getAsString().toLowerCase();
        } else if (json.has("type")) {
            rarity = json.get("type").getAsString().toLowerCase();
        }
        String color = null;
        if (json.has("color")) {
            color = json.get("color").getAsString().toLowerCase();
        } else if (json.has("name")) {
            color = json.get("name").getAsString().toLowerCase();
        }
        if (color == null) {
            throw new RuntimeException("Invalid subspecies variant added with no color defined!");
        }
        Variant variant = new Variant(color, rarity, json.get("index").getAsInt());
        if (json.has("scale")) {
            variant.scale = json.get("scale").getAsDouble();
        }
        return variant;
    }

    public Variant(String color, String rarity, int index) {
        this.color = color;
        this.rarity = rarity;
        this.index = index;
        this.weight = COMMON_WEIGHTS.get(rarity);
    }

    public String getTitle() {
        return LanguageManager.translate("subspecies." + this.color + ".name");
    }

    public double getScale() {
        return this.scale;
    }

    public boolean canSpawn(EntityLivingBase entityLiving) {
        if (entityLiving != null) {
            World world = entityLiving.func_130014_f_();
            int day = (int)Math.floor((double)world.func_82737_E() / 23999.0);
            int spawnDayMin = 0;
            if ("uncommon".equalsIgnoreCase(this.rarity)) {
                spawnDayMin = UNCOMMON_SPAWN_DAY_MIN;
            } else if ("rare".equalsIgnoreCase(this.rarity)) {
                spawnDayMin = RARE_SPAWN_DAY_MIN;
            }
            if (day < spawnDayMin) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.color + " - " + this.weight;
    }

    public static int getIndexFromOld(int oldIndex) {
        return oldIndex % 4;
    }
}

