/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment.features;

import com.google.gson.JsonObject;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class EffectEquipmentFeature
extends EquipmentFeature {
    public String effectType;
    public String effectTarget;
    public int effectDuration = 0;
    public int effectStrength = 0;

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
        this.effectType = json.get("effectType").getAsString();
        this.effectTarget = json.get("effectTarget").getAsString();
        if (json.has("effectDuration")) {
            this.effectDuration = json.get("effectDuration").getAsInt();
        }
        if (json.has("effectStrength")) {
            this.effectStrength = json.get("effectStrength").getAsInt();
        }
    }

    @Override
    public String getDescription(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        String description = LanguageManager.translate("equipment.feature." + this.featureType) + " " + this.getEffectTypeName();
        if (this.effectStrength > 0) {
            description = description + " " + LanguageManager.translate("entity.level") + " " + this.effectStrength;
        }
        if (!"self".equals(this.effectTarget) && this.effectDuration > 0) {
            description = description + " " + (float)this.effectDuration / 20.0f + "s";
        }
        description = description + " (" + this.effectTarget + ")";
        return description;
    }

    @Override
    public String getSummary(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        String summary = this.getEffectTypeName();
        if (this.effectStrength > 0) {
            summary = summary + " " + LanguageManager.translate("entity.level") + " " + this.effectStrength;
        }
        if (!"self".equals(this.effectTarget) && this.effectDuration > 0) {
            summary = summary + " " + (float)this.effectDuration / 20.0f + "s";
        }
        summary = summary + " (" + this.effectTarget + ")";
        return summary;
    }

    public String getEffectTypeName() {
        if ("burning".equals(this.effectType)) {
            return LanguageManager.translate("effect.burning");
        }
        ResourceLocation effectResource = new ResourceLocation(this.effectType);
        return LanguageManager.translate("effect." + effectResource.func_110623_a());
    }

    public void onHitEntity(ItemStack itemStack, EntityLivingBase target, EntityLivingBase attacker) {
        if (target == null || attacker == null) {
            return;
        }
        EntityLivingBase effectTarget = target;
        if ("self".equalsIgnoreCase(this.effectTarget)) {
            effectTarget = attacker;
        }
        if ("burning".equalsIgnoreCase(this.effectType)) {
            effectTarget.func_70015_d(Math.round((float)this.effectDuration / 20.0f));
            return;
        }
        Potion potion = (Potion)GameRegistry.findRegistry(Potion.class).getValue(new ResourceLocation(this.effectType));
        if (potion != null && this.effectStrength > 0) {
            effectTarget.func_70690_d(new PotionEffect(potion, this.effectDuration, this.effectStrength - 1));
        }
    }
}

