/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item.equipment.features;

import com.google.gson.JsonObject;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.item.equipment.features.EquipmentFeature;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SummonEquipmentFeature
extends EquipmentFeature {
    public String summonMobId;
    public double summonChance = 0.05;
    public int summonDuration = 60;
    public int summonCountMin = 1;
    public int summonCountMax = 1;
    public double sizeScale = 1.0;

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
        this.summonMobId = json.get("summonMobId").getAsString();
        if (json.has("summonChance")) {
            this.summonChance = json.get("summonChance").getAsDouble();
        }
        if (json.has("summonDuration")) {
            this.summonDuration = json.get("summonDuration").getAsInt();
        }
        if (json.has("summonCountMin")) {
            this.summonCountMin = json.get("summonCountMin").getAsInt();
        }
        if (json.has("summonCountMax")) {
            this.summonCountMax = json.get("summonCountMax").getAsInt();
        }
        if (json.has("sizeScale")) {
            this.sizeScale = json.get("sizeScale").getAsDouble();
        }
    }

    @Override
    public String getDescription(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        String description = LanguageManager.translate("equipment.feature." + this.featureType) + " " + LanguageManager.translate("entity." + this.summonMobId + ".name");
        description = this.summonCountMin != this.summonCountMax ? description + " x" + this.summonCountMin + " - " + this.summonCountMax : description + " x" + this.summonCountMax;
        description = description + " " + Math.round(this.summonChance * 100.0) + "%";
        if (this.summonDuration > 0) {
            description = description + " " + (float)this.summonDuration / 20.0f + "s";
        }
        return description;
    }

    @Override
    public String getSummary(ItemStack itemStack, int level) {
        if (!this.isActive(itemStack, level)) {
            return null;
        }
        return LanguageManager.translate("entity." + this.summonMobId + ".name");
    }

    public void onHitEntity(ItemStack itemStack, EntityLivingBase target, EntityLivingBase attacker) {
        if (target == null || attacker == null || attacker.func_130014_f_().field_72995_K) {
            return;
        }
        int summonCount = this.summonCountMin;
        if (this.summonCountMax > this.summonCountMin) {
            summonCount = this.summonCountMin + attacker.func_70681_au().nextInt(this.summonCountMax - this.summonCountMin);
        }
        for (int i = 0; i < summonCount; ++i) {
            if (!(attacker.func_70681_au().nextDouble() <= this.summonChance)) continue;
            try {
                EntityLiving entity;
                Class entityClass = null;
                CreatureInfo creatureInfo = CreatureManager.getInstance().getCreatureFromId(this.summonMobId);
                if (creatureInfo != null) {
                    entityClass = creatureInfo.entityClass;
                } else {
                    EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(this.summonMobId));
                    if (entry != null) {
                        entityClass = entry.getEntityClass();
                    }
                }
                if (entityClass == null || !((entity = entityClass.getConstructor(World.class).newInstance(attacker.func_130014_f_())) instanceof BaseCreatureEntity)) continue;
                BaseCreatureEntity entityCreature = (BaseCreatureEntity)entity;
                entityCreature.setMinion(true);
                entityCreature.setTemporary(this.summonDuration * 20);
                entityCreature.setSizeScale(this.sizeScale);
                if (attacker instanceof EntityPlayer && entityCreature instanceof TameableCreatureEntity) {
                    TameableCreatureEntity entityTameable = (TameableCreatureEntity)entityCreature;
                    entityTameable.setPlayerOwner((EntityPlayer)attacker);
                    entityTameable.setSitting(false);
                    entityTameable.setFollowing(true);
                    entityTameable.setPassive(false);
                    entityTameable.setAssist(true);
                    entityTameable.setAggressive(true);
                    entityTameable.setPVP(target instanceof EntityPlayer);
                }
                float randomAngle = 45.0f + 45.0f * attacker.func_70681_au().nextFloat();
                if (attacker.func_70681_au().nextBoolean()) {
                    randomAngle = -randomAngle;
                }
                BlockPos spawnPos = entityCreature.getFacingPosition((Entity)attacker, -1.0, randomAngle);
                entity.func_70012_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), attacker.field_70177_z, 0.0f);
                attacker.func_130014_f_().func_72838_d((Entity)entity);
                entityCreature.func_70624_b(target);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

