/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner.location;

import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.spawner.location.RandomSpawnLocation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class StructureSpawnLocation
extends RandomSpawnLocation {
    public String structureType = "Stronghold";
    public int structureRange = 128;

    @Override
    public void loadFromJSON(JsonObject json) {
        super.loadFromJSON(json);
        if (json.has("structureType")) {
            this.structureType = json.get("structureType").getAsString();
        }
        if (json.has("structureRange")) {
            this.structureRange = json.get("structureRange").getAsInt();
        }
    }

    @Override
    public List<BlockPos> getSpawnPositions(World world, EntityPlayer player, BlockPos triggerPos) {
        LycanitesMobs.logDebug("JSONSpawner", "Getting Nearest Structures Within Range");
        if (!(world instanceof WorldServer)) {
            LycanitesMobs.logWarning("", "[JSONSpawner] Structure spawn location was called with a non ServerWorld World instance.");
            return new ArrayList<BlockPos>();
        }
        BlockPos structurePos = null;
        try {
            structurePos = ((WorldServer)world).func_72863_F().func_180513_a(world, this.structureType, triggerPos, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (structurePos == null) {
            LycanitesMobs.logDebug("JSONSpawner", "No Structures found.");
            return new ArrayList<BlockPos>();
        }
        double structureDistance = Math.sqrt(structurePos.func_177951_i((Vec3i)triggerPos));
        if (structureDistance > (double)this.structureRange) {
            LycanitesMobs.logDebug("JSONSpawner", "No Structures within range, nearest was: " + structureDistance + " at: " + structurePos);
            return new ArrayList<BlockPos>();
        }
        LycanitesMobs.logDebug("JSONSpawner", "Found a Structures within range, at: " + structurePos);
        return super.getSpawnPositions(world, player, structurePos);
    }
}

