/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.worldgen.mobevents;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityAsmodeus;
import com.lycanitesmobs.core.entity.projectile.EntityHellfireWall;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.mobevent.MobEventPlayerServer;
import com.lycanitesmobs.core.mobevent.effects.StructureBuilder;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AsmodeusStructureBuilder
extends StructureBuilder {
    public AsmodeusStructureBuilder() {
        this.name = "asmodeus";
    }

    @Override
    public void build(World world, EntityPlayer player, BlockPos pos, int level, int ticks, int variant) {
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
        int originX = pos.func_177958_n();
        int originY = pos.func_177956_o();
        int originZ = pos.func_177952_p();
        originX += 20;
        int height = 40;
        if (originY < 5) {
            originY = 5;
        }
        if (world.func_72800_K() <= height) {
            originY = 5;
        } else if (originY + height >= world.func_72800_K()) {
            originY = Math.max(5, world.func_72800_K() - height - 1);
        }
        if (ticks == 1) {
            for (int i = 0; i < 5; ++i) {
                EntityHellfireWall baseProjectileEntity = new EntityHellfireWall(world, originX, originY + 10 * i, originZ);
                baseProjectileEntity.projectileLife = 400;
                world.func_72838_d((Entity)baseProjectileEntity);
                if (worldExt == null) continue;
                worldExt.bossUpdate((Entity)baseProjectileEntity);
                worldExt.overrideBossRange((Entity)baseProjectileEntity, CreatureManager.getInstance().getCreature((String)"asmodeus").bossNearbyRange);
            }
        }
        if (ticks == 60) {
            this.buildArenaFloor(world, originX, originY, originZ);
        }
        if (ticks == 100) {
            this.buildArenaWalls(world, originX, originY, originZ);
        }
        if (ticks == 140) {
            this.buildObstacles(world, originX, originY, originZ);
        }
        if (ticks >= 200 && ticks % 10 == 0) {
            world.func_72876_a(null, (double)(originX - 20 + world.field_73012_v.nextInt(40)), (double)(originY + 25 + world.field_73012_v.nextInt(10)), (double)(originZ - 20 + world.field_73012_v.nextInt(40)), 2.0f, true);
        }
        if (ticks == 400) {
            MobEventPlayerServer mobEventPlayerServer;
            EntityAsmodeus baseCreatureEntity = new EntityAsmodeus(world);
            baseCreatureEntity.func_70012_b(originX, originY + 1, originZ, 0.0f, 0.0f);
            world.func_72838_d((Entity)baseCreatureEntity);
            ((BaseCreatureEntity)baseCreatureEntity).setArenaCenter(new BlockPos(originX, originY + 1, originZ));
            if (worldExt != null && (mobEventPlayerServer = worldExt.getMobEventPlayerServer(this.name)) != null) {
                mobEventPlayerServer.mobEvent.onSpawn(baseCreatureEntity, world, player, pos, level, ticks, variant);
            }
        }
    }

    public void buildArenaFloor(World world, int originX, int originY, int originZ) {
        int radius = 80;
        int height = 30;
        int minX = originX - radius;
        int maxX = originX + radius;
        int minY = originY;
        int maxY = originY + height;
        int minZ = originZ - radius;
        int maxZ = originZ + radius;
        IBlockState floor = ObjectManager.getBlock("aberrantstonetile").func_176223_P();
        IBlockState light = ObjectManager.getBlock("aberrantcrystal").func_176223_P();
        IBlockState trimming = ObjectManager.getBlock("aberrantstonechiseled").func_176223_P();
        for (int x = minX; x <= maxX; ++x) {
            block1: for (int z = minZ; z <= maxZ; ++z) {
                int topY = world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o();
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos buildPos = new BlockPos(x, y, z);
                    if (y == minY) {
                        if (x == minX || x == maxX || z == minZ || z == maxZ) {
                            world.func_180501_a(buildPos, trimming, 2);
                            continue;
                        }
                        if (x % 6 == 0 && z % 6 == 0) {
                            world.func_180501_a(buildPos, light, 2);
                            continue;
                        }
                        world.func_180501_a(buildPos, floor, 2);
                        continue;
                    }
                    if (y > minY + 5 && y >= topY) continue block1;
                    world.func_180501_a(buildPos, Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        }
    }

    public void buildArenaWalls(World world, int originX, int originY, int originZ) {
        int radius = 80;
        int thickness = 4;
        int height = 20;
        int minX = originX - (radius + thickness);
        int maxX = originX + (radius + thickness);
        int minY = originY;
        int maxY = originY + height;
        int minZ = originZ - (radius + thickness);
        int maxZ = originZ + (radius + thickness);
        IBlockState base = ObjectManager.getBlock("aberrantstonebrick").func_176223_P();
        IBlockState light = ObjectManager.getBlock("aberrantcrystal").func_176223_P();
        IBlockState trimming = ObjectManager.getBlock("aberrantstonechiseled").func_176223_P();
        IBlockState top = ObjectManager.getBlock("aberrantstonepolished").func_176223_P();
        IBlockState fireBase = Blocks.field_150343_Z.func_176223_P();
        IBlockState fire = ObjectManager.getBlock("hellfire").func_176223_P();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (x > minX + thickness && x < maxX - thickness && z > minZ + thickness && z < maxZ - thickness) continue;
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos buildPos = new BlockPos(x, y, z);
                    if (y < maxY - 2) {
                        if (y - 1 == 0) {
                            world.func_180501_a(buildPos, light, 2);
                            continue;
                        }
                        if (y % 8 == 0) {
                            world.func_180501_a(buildPos, trimming, 2);
                            continue;
                        }
                        world.func_180501_a(buildPos, base, 2);
                        continue;
                    }
                    if (y == maxY - 2) {
                        world.func_180501_a(buildPos, top, 2);
                        continue;
                    }
                    if (y == maxY - 1) {
                        world.func_180501_a(buildPos, fireBase, 2);
                        continue;
                    }
                    world.func_180501_a(buildPos, fire, 2);
                }
            }
        }
    }

    public void buildObstacles(World world, int originX, int originY, int originZ) {
        int gap = 20;
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (x >= -1 && x <= 1 && z >= -1 && z <= 1) continue;
                this.buildPillar(world, originX + x * gap, originY, originZ + z * gap);
            }
        }
    }

    public void buildPillar(World world, int originX, int originY, int originZ) {
        int radius = 2;
        int height = 30;
        int minX = originX - radius;
        int maxX = originX + radius;
        int minY = originY;
        int maxY = originY + height;
        int minZ = originZ - radius;
        int maxZ = originZ + radius;
        IBlockState base = ObjectManager.getBlock("aberrantstonepillar").func_176223_P();
        IBlockState light = ObjectManager.getBlock("aberrantcrystal").func_176223_P();
        IBlockState trimming = ObjectManager.getBlock("aberrantstonechiseled").func_176223_P();
        IBlockState top = ObjectManager.getBlock("aberrantstonepolished").func_176223_P();
        IBlockState fireBase = Blocks.field_150343_Z.func_176223_P();
        IBlockState fire = ObjectManager.getBlock("hellfire").func_176223_P();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos buildPos = new BlockPos(x, y, z);
                    if (y < maxY - 2) {
                        if (y % 7 == 0) {
                            world.func_180501_a(buildPos, light, 2);
                            continue;
                        }
                        if (y % 8 == 0) {
                            world.func_180501_a(buildPos, trimming, 2);
                            continue;
                        }
                        world.func_180501_a(buildPos, base, 2);
                        continue;
                    }
                    if (y == maxY - 2) {
                        world.func_180501_a(buildPos, top, 2);
                        continue;
                    }
                    if (y == maxY - 1) {
                        world.func_180501_a(buildPos, fireBase, 2);
                        continue;
                    }
                    world.func_180501_a(buildPos, fire, 2);
                }
            }
        }
    }
}

