/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.globallibrary.panels;

import com.google.common.util.concurrent.FutureCallback;
import java.util.UUID;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.GuiCustomLabel;
import moe.plushie.armourers_workshop.client.gui.controls.GuiLabeledTextField;
import moe.plushie.armourers_workshop.client.gui.controls.GuiPanel;
import moe.plushie.armourers_workshop.client.gui.globallibrary.GuiGlobalLibrary;
import moe.plushie.armourers_workshop.common.library.global.GlobalSkinLibraryUtils;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTaskBetaJoin;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiGlobalLibraryPaneJoinBeta
extends GuiPanel {
    private final String guiName;
    private GuiLabeledTextField textBetaCode;
    private GuiButtonExt buttonCheckBetaCode;
    private GuiCustomLabel statsText;
    private boolean joining = false;
    private String joinState = "";
    private String joinFailMessage = null;

    public GuiGlobalLibraryPaneJoinBeta(GuiScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.guiName = ((GuiGlobalLibrary)parent).getGuiName() + ".joinBeta";
    }

    @Override
    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        this.textBetaCode = new GuiLabeledTextField(this.fontRenderer, this.x + 5, this.y + 35, 230, 12);
        this.textBetaCode.setEmptyLabel(GuiHelper.getLocalizedControlName(this.guiName, "enterBetaCode", new Object[0]));
        this.textBetaCode.func_146203_f(36);
        this.buttonCheckBetaCode = new GuiButtonExt(0, this.x + 5, this.y + 50, 230, 20, GuiHelper.getLocalizedControlName(this.guiName, "buttonJoinBeta", new Object[0]));
        this.buttonCheckBetaCode.field_146124_l = false;
        this.statsText = new GuiCustomLabel(this.fontRenderer, this.x + 5, this.y + 75, this.width - 10, this.height - 75 - 5);
        this.buttonList.add(this.buttonCheckBetaCode);
    }

    private void joinedBetaFailed(String reason) {
        this.joining = false;
        this.joinFailMessage = reason;
    }

    private void joinedBeta() {
        this.joining = false;
        this.joinFailMessage = "";
        ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.HOME);
    }

    @Override
    public boolean keyTyped(char c, int keycode) {
        if (!this.visible | !this.enabled) {
            return false;
        }
        if (this.textBetaCode.func_146201_a(c, keycode)) {
            boolean bl = this.buttonCheckBetaCode.field_146124_l = this.textBetaCode.func_146179_b().length() == 36;
            if (!GlobalSkinLibraryUtils.isValidJavaVersion()) {
                this.buttonCheckBetaCode.field_146124_l = false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (!this.visible | !this.enabled) {
            return false;
        }
        boolean clicked = super.mouseClicked(mouseX, mouseY, button);
        this.textBetaCode.func_146192_a(mouseX, mouseY, button);
        this.statsText.mouseClick(mouseX, mouseY, button);
        if (button == 1 && this.textBetaCode.func_146206_l()) {
            this.textBetaCode.func_146180_a("");
        }
        return clicked;
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button == this.buttonCheckBetaCode && this.textBetaCode.func_146179_b().length() == 36) {
            try {
                this.joining = true;
                this.joinFailMessage = "";
                UUID uuid = UUID.fromString(this.textBetaCode.func_146179_b());
                new GlobalTaskBetaJoin(uuid).createTaskAndRun(new FutureCallback<GlobalTaskBetaJoin.BetaJoinResult>(){

                    public void onSuccess(final GlobalTaskBetaJoin.BetaJoinResult result) {
                        Minecraft.func_71410_x().func_152344_a(new Runnable(){

                            @Override
                            public void run() {
                                switch (result.getJoinResult()) {
                                    case JOINED: {
                                        GuiGlobalLibraryPaneJoinBeta.this.joinedBeta();
                                        break;
                                    }
                                    case ALREADY_JOINED: {
                                        GuiGlobalLibraryPaneJoinBeta.this.joinedBetaFailed(result.getMessage());
                                        break;
                                    }
                                    case CODE_CHECK_FAILED: {
                                        GuiGlobalLibraryPaneJoinBeta.this.joinedBetaFailed(result.getMessage());
                                        break;
                                    }
                                    case CODE_INVALID: {
                                        GuiGlobalLibraryPaneJoinBeta.this.joinedBetaFailed(result.getMessage());
                                        break;
                                    }
                                    case MINECRAFT_AUTH_FAIL: {
                                        GuiGlobalLibraryPaneJoinBeta.this.joinedBetaFailed(result.getMessage());
                                        break;
                                    }
                                    case JOIN_FAILED: {
                                        GuiGlobalLibraryPaneJoinBeta.this.joinedBetaFailed(result.getMessage());
                                    }
                                }
                            }
                        });
                    }

                    public void onFailure(final Throwable t) {
                        t.printStackTrace();
                        Minecraft.func_71410_x().func_152344_a(new Runnable(){

                            @Override
                            public void run() {
                                GuiGlobalLibraryPaneJoinBeta.this.joinedBetaFailed(t.getMessage());
                            }
                        });
                    }
                });
            }
            catch (IllegalArgumentException e) {
                this.joinedBetaFailed(GlobalTaskBetaJoin.BetaJoinResult.JoinResult.CODE_INVALID.toString().toLowerCase());
            }
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTickTime) {
        int[] javaVersion;
        if (!this.visible) {
            return;
        }
        this.func_73733_a(this.x, this.y, this.x + this.width, this.y + this.height, -1072689136, -804253680);
        super.draw(mouseX, mouseY, partialTickTime);
        this.fontRenderer.func_78276_b(GuiHelper.getLocalizedControlName(this.guiName, "name", new Object[0]), this.x + 5, this.y + 5, 0xFFFFFF);
        this.fontRenderer.func_78276_b(GuiHelper.getLocalizedControlName(this.guiName, "betaCode", new Object[0]), this.x + 5, this.y + 25, 0xFFFFFF);
        this.textBetaCode.func_146194_f();
        this.statsText.clearText();
        this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, "closedBeta", new Object[0]));
        this.statsText.addNewLine();
        this.statsText.addNewLine();
        if (!StringUtils.func_151246_b((String)this.joinState)) {
            this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, this.joinState, new Object[0]));
            this.statsText.addNewLine();
            this.statsText.addNewLine();
        }
        if (!StringUtils.func_151246_b((String)this.joinFailMessage)) {
            this.statsText.addText(TextFormatting.RED.toString());
            this.statsText.addText(this.joinFailMessage);
            this.statsText.addText(TextFormatting.RESET.toString());
            this.statsText.addNewLine();
            this.statsText.addNewLine();
        }
        if (!GlobalSkinLibraryUtils.isValidJavaVersion(javaVersion = GlobalSkinLibraryUtils.getJavaVersion())) {
            this.statsText.addText(TextFormatting.RED.toString());
            this.statsText.addText(TranslateUtils.translate("inventory.armourers_workshop:global-skin-library.invalidJava", javaVersion[0], javaVersion[1]));
            this.statsText.addText(TextFormatting.RESET.toString());
            this.statsText.addNewLine();
            this.statsText.addNewLine();
        }
        this.statsText.draw(mouseX, mouseY);
    }
}

