/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.globallibrary.panels;

import com.google.common.util.concurrent.FutureCallback;
import com.google.gson.JsonObject;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.AbstractGuiDialog;
import moe.plushie.armourers_workshop.client.gui.controls.GuiCustomLabel;
import moe.plushie.armourers_workshop.client.gui.controls.GuiLabeledTextField;
import moe.plushie.armourers_workshop.client.gui.controls.GuiPanel;
import moe.plushie.armourers_workshop.client.gui.controls.GuiTextFieldCustom;
import moe.plushie.armourers_workshop.client.gui.controls.IDialogCallback;
import moe.plushie.armourers_workshop.client.gui.globallibrary.GuiGlobalLibrary;
import moe.plushie.armourers_workshop.client.gui.globallibrary.dialog.GuiGlobalLibraryDialogDelete;
import moe.plushie.armourers_workshop.common.library.global.GlobalSkinLibraryUtils;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTaskSkinDelete;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTaskSkinEdit;
import moe.plushie.armourers_workshop.utils.ModLogger;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import org.apache.logging.log4j.Level;

public class GuiGlobalLibraryPanelSkinEdit
extends GuiPanel
implements IDialogCallback {
    private static final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("armourers_workshop:textures/gui/global_library/global-library.png");
    private final String guiName;
    private boolean moderator = false;
    private GuiLabeledTextField textName;
    private GuiLabeledTextField textTags;
    private GuiTextFieldCustom textDescription;
    private GuiButtonExt buttonUpdate;
    private GuiButtonExt buttonDelete;
    private GuiCustomLabel statsText;
    private JsonObject skinJson = null;
    private GuiGlobalLibrary.Screen returnScreen;
    private boolean firstTick = false;

    public GuiGlobalLibraryPanelSkinEdit(GuiScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.guiName = ((GuiGlobalLibrary)parent).getGuiName() + ".edit";
    }

    @Override
    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        this.textName = new GuiLabeledTextField(this.fontRenderer, this.x + 5, this.y + 35, this.width - 15 - 162, 12);
        this.textName.setEmptyLabel(GuiHelper.getLocalizedControlName(this.guiName, "enterName", new Object[0]));
        this.textName.func_146203_f(80);
        this.textTags = new GuiLabeledTextField(this.fontRenderer, this.x + 5, this.y + 65, this.width - 15 - 162, 12);
        this.textTags.setEmptyLabel(GuiHelper.getLocalizedControlName(this.guiName, "enterTags", new Object[0]));
        this.textDescription = new GuiTextFieldCustom(this.x + 5, this.y + 95, this.width - 15 - 162, this.height - 95 - 40);
        this.textDescription.setEmptyLabel(GuiHelper.getLocalizedControlName(this.guiName, "enterDescription", new Object[0]));
        this.textDescription.setMaxStringLength(255);
        if (this.skinJson != null) {
            if (this.skinJson.has("name")) {
                this.textName.func_146180_a(this.skinJson.get("name").getAsString());
            }
            if (this.skinJson.has("description")) {
                this.textDescription.setText(this.skinJson.get("description").getAsString());
            }
        }
        this.buttonUpdate = new GuiButtonExt(0, this.x + 5, this.y + this.height - 25, 100, 20, GuiHelper.getLocalizedControlName(this.guiName, "buttonUpdate", new Object[0]));
        this.buttonDelete = new GuiButtonExt(0, this.x + this.width - 105, this.y + this.height - 25, 100, 20, GuiHelper.getLocalizedControlName(this.guiName, "buttonDelete", new Object[0]));
        this.statsText = new GuiCustomLabel(this.fontRenderer, this.x + this.width - 162 - 5, this.y + 5, 162, this.height - 90);
        this.buttonList.add(this.buttonUpdate);
        this.buttonList.add(this.buttonDelete);
    }

    public void setModerator(boolean moderator) {
        this.moderator = moderator;
    }

    @Override
    public boolean keyTyped(char c, int keycode) {
        if (!this.visible | !this.enabled) {
            return false;
        }
        if (this.textName.func_146201_a(c, keycode)) {
            return true;
        }
        if (this.textTags.func_146201_a(c, keycode)) {
            return true;
        }
        return this.textDescription.keyTyped(c, keycode);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (!this.visible | !this.enabled) {
            return false;
        }
        boolean clicked = super.mouseClicked(mouseX, mouseY, button);
        if (!clicked) {
            clicked = this.textName.func_146192_a(mouseX, mouseY, button);
            clicked = this.textTags.func_146192_a(mouseX, mouseY, button);
            clicked = this.textDescription.mouseClicked(mouseX, mouseY, button);
        }
        if (!clicked) {
            clicked = this.statsText.mouseClick(mouseX, mouseY, button);
        }
        if (button == 1) {
            if (this.textName.func_146206_l()) {
                this.textName.func_146180_a("");
            }
            if (this.textTags.func_146206_l()) {
                this.textTags.func_146180_a("");
            }
            if (this.textDescription.isFocused()) {
                this.textDescription.setText("");
            }
        }
        return clicked;
    }

    @Override
    public void update() {
        super.update();
        this.buttonUpdate.field_146124_l = false;
        if (!StringUtils.func_151246_b((String)this.textName.func_146179_b())) {
            this.buttonUpdate.field_146124_l = true;
        }
        this.firstTick = false;
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (!this.visible | !this.enabled) {
            return;
        }
        if (this.firstTick) {
            return;
        }
        if (button == this.buttonUpdate && this.skinJson != null && this.skinJson.has("id")) {
            this.updateSkin();
        }
        if (button == this.buttonDelete) {
            ((GuiGlobalLibrary)this.parent).openDialog(new GuiGlobalLibraryDialogDelete(this.parent, this.guiName + ".dialog.delete", this, 190, 100));
        }
    }

    public void displaySkinInfo(JsonObject jsonObject, GuiGlobalLibrary.Screen returnScreen) {
        this.skinJson = jsonObject;
        ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.SKIN_EDIT);
        this.returnScreen = returnScreen;
        this.firstTick = true;
    }

    public void updateSkin() {
        int skinID = this.skinJson.get("id").getAsInt();
        new GlobalTaskSkinEdit(skinID, this.textName.func_146179_b().trim(), this.textDescription.getText().trim(), this.moderator).createTaskAndRun(new FutureCallback<JsonObject>(){

            public void onSuccess(final JsonObject result) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        if (result.has("valid") & result.has("action")) {
                            String action = result.get("action").getAsString();
                            boolean valid = result.get("valid").getAsBoolean();
                            if (action.equals("user-skin-edit")) {
                                ((GuiGlobalLibrary)((GuiGlobalLibraryPanelSkinEdit)GuiGlobalLibraryPanelSkinEdit.this).parent).panelHome.updateSkinPanels();
                                ((GuiGlobalLibrary)GuiGlobalLibraryPanelSkinEdit.this.parent).switchScreen(GuiGlobalLibraryPanelSkinEdit.this.returnScreen);
                            } else {
                                ModLogger.log(Level.WARN, "Server send unknown action: " + action);
                            }
                        } else {
                            ModLogger.log(Level.ERROR, "Server returned invalid responce.");
                        }
                    }
                });
            }

            public void onFailure(Throwable t) {
                t.printStackTrace();
            }
        });
    }

    public void deleteSkin() {
        int skinID = this.skinJson.get("id").getAsInt();
        new GlobalTaskSkinDelete(skinID, this.moderator).createTaskAndRun(new FutureCallback<JsonObject>(){

            public void onSuccess(final JsonObject result) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        if (result.has("valid") & result.has("action")) {
                            String action = result.get("action").getAsString();
                            boolean valid = result.get("valid").getAsBoolean();
                            if (action.equals("user-skin-delete")) {
                                if (GuiGlobalLibraryPanelSkinEdit.this.returnScreen == GuiGlobalLibrary.Screen.HOME) {
                                    ((GuiGlobalLibrary)((GuiGlobalLibraryPanelSkinEdit)GuiGlobalLibraryPanelSkinEdit.this).parent).panelHome.updateSkinPanels();
                                }
                                if (GuiGlobalLibraryPanelSkinEdit.this.returnScreen == GuiGlobalLibrary.Screen.SEARCH) {
                                    ((GuiGlobalLibrary)((GuiGlobalLibraryPanelSkinEdit)GuiGlobalLibraryPanelSkinEdit.this).parent).panelSearchResults.refresh();
                                }
                                if (GuiGlobalLibraryPanelSkinEdit.this.returnScreen == GuiGlobalLibrary.Screen.USER_SKINS) {
                                    ((GuiGlobalLibrary)((GuiGlobalLibraryPanelSkinEdit)GuiGlobalLibraryPanelSkinEdit.this).parent).panelUserSkins.refresh();
                                }
                                ((GuiGlobalLibrary)GuiGlobalLibraryPanelSkinEdit.this.parent).switchScreen(GuiGlobalLibraryPanelSkinEdit.this.returnScreen);
                            } else {
                                ModLogger.log(Level.WARN, "Server send unknown action: " + action);
                            }
                        } else {
                            ModLogger.log(Level.ERROR, "Server returned invalid responce.");
                        }
                    }
                });
            }

            public void onFailure(Throwable t) {
                t.printStackTrace();
            }
        });
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTickTime) {
        if (!this.visible) {
            return;
        }
        this.func_73733_a(this.x, this.y, this.x + this.width, this.y + this.height, -1072689136, -804253680);
        super.draw(mouseX, mouseY, partialTickTime);
        this.fontRenderer.func_78276_b(GuiHelper.getLocalizedControlName(this.guiName, "name", new Object[0]), this.x + 5, this.y + 5, 0xFFFFFF);
        this.fontRenderer.func_78276_b(GuiHelper.getLocalizedControlName(this.guiName, "skinName", new Object[0]), this.x + 5, this.y + 25, 0xFFFFFF);
        this.textName.func_146194_f();
        this.fontRenderer.func_78276_b(GuiHelper.getLocalizedControlName(this.guiName, "skinTags", new Object[0]), this.x + 5, this.y + 55, 0xFFFFFF);
        this.textTags.func_146194_f();
        this.fontRenderer.func_78276_b(GuiHelper.getLocalizedControlName(this.guiName, "skinDescription", new Object[0]), this.x + 5, this.y + 85, 0xFFFFFF);
        this.textDescription.func_191745_a(this.mc, mouseX, mouseY, partialTickTime);
        this.statsText.clearText();
        int[] javaVersion = GlobalSkinLibraryUtils.getJavaVersion();
        if (!GlobalSkinLibraryUtils.isValidJavaVersion(javaVersion)) {
            this.statsText.addText(TextFormatting.RED.toString());
            this.statsText.addText(TranslateUtils.translate("inventory.armourers_workshop:global-skin-library.invalidJava", javaVersion[0], javaVersion[1]));
            this.statsText.addText(TextFormatting.RESET.toString());
            this.statsText.addNewLine();
            this.statsText.addNewLine();
        }
        this.statsText.draw(mouseX, mouseY);
    }

    @Override
    public void dialogResult(AbstractGuiDialog dialog, IDialogCallback.DialogResult result) {
        ModLogger.log((Object)result);
        if (result == IDialogCallback.DialogResult.OK && this.skinJson != null && this.skinJson.has("id")) {
            this.deleteSkin();
        }
        ((GuiGlobalLibrary)this.parent).closeDialog();
    }
}

