/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.handler;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.common.capability.IEntitySkinCapability;
import moe.plushie.armourers_workshop.api.common.capability.IPlayerWardrobeCap;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDescriptor;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDye;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.handler.ClientWardrobeHandler;
import moe.plushie.armourers_workshop.client.render.EntityTextureInfo;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.common.capability.entityskin.EntitySkinCapability;
import moe.plushie.armourers_workshop.common.capability.wardrobe.player.PlayerWardrobeCap;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinDye;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.proxies.ClientProxy;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PlayerTextureHandler {
    public static PlayerTextureHandler INSTANCE;
    public HashMap<GameProfile, EntityTextureInfo> playerTextureMap = new HashMap();
    private final Profiler profiler;
    private boolean useTexturePainting;

    public PlayerTextureHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.profiler = Minecraft.func_71410_x().field_71424_I;
        INSTANCE = this;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRender(RenderPlayerEvent.Pre event) {
        if (ClientProxy.getTexturePaintType() != ClientProxy.TexturePaintType.TEXTURE_REPLACE) {
            return;
        }
        if (!(event.getEntityPlayer() instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)event.getEntityPlayer();
        IEntitySkinCapability skinCapability = EntitySkinCapability.get((Entity)player);
        if (skinCapability == null) {
            return;
        }
        IPlayerWardrobeCap wardrobeCap = PlayerWardrobeCap.get((EntityPlayer)player);
        if (wardrobeCap == null) {
            return;
        }
        this.profiler.func_76320_a("textureBuild");
        if (this.playerTextureMap.containsKey(player.func_146103_bH())) {
            Map playerTextures;
            EntityTextureInfo textureInfo = this.playerTextureMap.get(player.func_146103_bH());
            textureInfo.updateTexture(player.func_110306_p());
            textureInfo.updateExtraColours(wardrobeCap.getExtraColours());
            ISkinType[] skinTypes = new ISkinType[]{SkinTypeRegistry.skinHead, SkinTypeRegistry.skinChest, SkinTypeRegistry.skinLegs, SkinTypeRegistry.skinFeet, SkinTypeRegistry.skinOutfit};
            Skin[] skins = new Skin[skinTypes.length * 10 + 4];
            ISkinDye[] dyes = new ISkinDye[skinTypes.length * 10 + 4];
            for (int skinIndex = 0; skinIndex < 10; ++skinIndex) {
                Skin[] skin = new Skin[skinTypes.length];
                ISkinDye[] dye = new ISkinDye[skinTypes.length];
                for (int i = 0; i < skinTypes.length; ++i) {
                    ISkinDescriptor descriptor = skinCapability.getSkinDescriptor(skinTypes[i], skinIndex);
                    if (descriptor == null) continue;
                    skin[i] = ClientSkinCache.INSTANCE.getSkin(descriptor, false);
                    dye[i] = descriptor.getSkinDye();
                }
                skins[0 + skinIndex * skinTypes.length] = skin[0];
                skins[1 + skinIndex * skinTypes.length] = skin[1];
                skins[2 + skinIndex * skinTypes.length] = skin[2];
                skins[3 + skinIndex * skinTypes.length] = skin[3];
                skins[4 + skinIndex * skinTypes.length] = skin[4];
                dyes[0 + skinIndex * skinTypes.length] = this.mixDye(wardrobeCap.getDye(), dye[0]);
                dyes[1 + skinIndex * skinTypes.length] = this.mixDye(wardrobeCap.getDye(), dye[1]);
                dyes[2 + skinIndex * skinTypes.length] = this.mixDye(wardrobeCap.getDye(), dye[2]);
                dyes[3 + skinIndex * skinTypes.length] = this.mixDye(wardrobeCap.getDye(), dye[3]);
                dyes[4 + skinIndex * skinTypes.length] = this.mixDye(wardrobeCap.getDye(), dye[4]);
            }
            ISkinType[] skinTypesArmour = new ISkinType[]{SkinTypeRegistry.skinHead, SkinTypeRegistry.skinChest, SkinTypeRegistry.skinLegs, SkinTypeRegistry.skinFeet};
            for (int i = 0; i < skinTypesArmour.length; ++i) {
                ISkinDescriptor skinDescriptor = this.getSkinDescriptorFromArmourer((Entity)player, skinTypesArmour[i]);
                if (skinDescriptor == null) continue;
            }
            textureInfo.updateSkins(skins);
            textureInfo.updateDyes(dyes);
            ResourceLocation replacmentTexture = textureInfo.preRender();
            NetworkPlayerInfo playerInfo = Minecraft.func_71410_x().func_147114_u().func_175102_a(player.func_110124_au());
            if (playerInfo != null && (playerTextures = (Map)ReflectionHelper.getPrivateValue(NetworkPlayerInfo.class, (Object)playerInfo, (String[])new String[]{"field_187107_a", "playerTextures"})) != null) {
                playerTextures.put(MinecraftProfileTexture.Type.SKIN, replacmentTexture);
            }
        }
        this.profiler.func_76319_b();
    }

    private ISkinDescriptor getSkinDescriptorFromArmourer(Entity entity, ISkinType skinType) {
        if (skinType.getVanillaArmourSlotId() >= 0 && skinType.getVanillaArmourSlotId() < 4) {
            int slot = 3 - skinType.getVanillaArmourSlotId();
            ItemStack armourStack = ClientWardrobeHandler.getArmourInSlot(slot);
            return SkinNBTHelper.getSkinDescriptorFromStack(armourStack);
        }
        return null;
    }

    private ISkinDye mixDye(ISkinDye wardrobeDye, ISkinDye itemDye) {
        SkinDye dye = new SkinDye(wardrobeDye);
        if (itemDye != null) {
            for (int i = 0; i < 8; ++i) {
                if (!itemDye.haveDyeInSlot(i)) continue;
                dye.addDye(i, itemDye.getDyeColour(i));
            }
        }
        return dye;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRender(RenderPlayerEvent.Post event) {
        if (ClientProxy.getTexturePaintType() != ClientProxy.TexturePaintType.TEXTURE_REPLACE) {
            return;
        }
        if (!(event.getEntityPlayer() instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)event.getEntityPlayer();
        if (player.func_146103_bH() == null) {
            return;
        }
        this.profiler.func_76320_a("textureReset");
        if (this.playerTextureMap.containsKey(player.func_146103_bH())) {
            ResourceLocation curTexture;
            Map playerTextures;
            EntityTextureInfo textureInfo = this.playerTextureMap.get(player.func_146103_bH());
            ResourceLocation replacmentTexture = textureInfo.getReplacementTexture();
            ResourceLocation normalTexture = textureInfo.postRender();
            NetworkPlayerInfo playerInfo = Minecraft.func_71410_x().func_147114_u().func_175102_a(player.func_110124_au());
            if (playerInfo != null && (playerTextures = (Map)ReflectionHelper.getPrivateValue(NetworkPlayerInfo.class, (Object)playerInfo, (String[])new String[]{"field_187107_a", "playerTextures"})) != null && (curTexture = player.func_110306_p()) == replacmentTexture) {
                playerTextures.put(MinecraftProfileTexture.Type.SKIN, normalTexture);
            }
        } else {
            this.playerTextureMap.put(player.func_146103_bH(), new EntityTextureInfo());
        }
        this.profiler.func_76319_b();
    }
}

