/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.render.tileentities;

import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.api.common.skin.cubes.ICubeColour;
import moe.plushie.armourers_workshop.client.render.IRenderBuffer;
import moe.plushie.armourers_workshop.client.render.ModRenderHelper;
import moe.plushie.armourers_workshop.client.render.RenderBridge;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import moe.plushie.armourers_workshop.common.painting.IBlockPainter;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityColourable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderBlockColourable
extends TileEntitySpecialRenderer<TileEntityColourable> {
    public static final ResourceLocation MARKERS = new ResourceLocation("armourers_workshop".toLowerCase(), "textures/tile-entities/markers.png");
    public static float markerAlpha = 0.0f;
    private static long lastWorldTimeUpdate;
    private final IRenderBuffer renderer = RenderBridge.INSTANCE;

    public void render(TileEntityColourable tileEntity, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        RenderBlockColourable.updateAlpha(tileEntity);
        if (!(markerAlpha > 0.0f)) {
            return;
        }
        ICubeColour cubeColour = tileEntity.getColour();
        GlStateManager.func_179123_a();
        GL11.glDisable((int)2896);
        ModRenderHelper.enableAlphaBlend();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)markerAlpha);
        this.func_147499_a(MARKERS);
        this.renderer.startDrawingQuads(DefaultVertexFormats.field_181707_g);
        for (int i = 0; i < 6; ++i) {
            EnumFacing dir = EnumFacing.func_82600_a((int)i);
            int paintType = cubeColour.getPaintType(i) & 0xFF;
            if (paintType == 255) continue;
            IPaintType pt = PaintTypeRegistry.getInstance().getPaintTypeFromIndex(paintType);
            RenderBlockColourable.renderFaceWithMarker(this.renderer, x, y, z, dir, pt.getMarkerIndex());
        }
        this.renderer.draw();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ModRenderHelper.disableAlphaBlend();
        ModRenderHelper.enableLighting();
        RenderHelper.func_74519_b();
        GlStateManager.func_179099_b();
    }

    public static void updateAlpha(TileEntity tileEntity) {
        if (lastWorldTimeUpdate != tileEntity.func_145831_w().func_82737_E()) {
            lastWorldTimeUpdate = tileEntity.func_145831_w().func_82737_E();
            if (RenderBlockColourable.isPlayerHoldingPaintingTool()) {
                if ((markerAlpha += 0.25f) > 1.0f) {
                    markerAlpha = 1.0f;
                }
            } else if ((markerAlpha -= 0.25f) < 0.0f) {
                markerAlpha = 0.0f;
            }
        }
    }

    public static void renderFaceWithMarker(IRenderBuffer renderer, double x, double y, double z, EnumFacing face, int marker) {
        Tessellator tess = Tessellator.func_178181_a();
        float tileScale = 0.125f;
        float ySrc = (float)Math.floor((double)marker / 8.0);
        float xSrc = (float)marker - ySrc * 8.0f;
        float xStart = tileScale * xSrc;
        float yStart = tileScale * ySrc;
        float xEnd = xStart + tileScale * 1.0f;
        float yEnd = yStart + tileScale * 1.0f;
        float offset = 0.001f;
        switch (face) {
            case DOWN: {
                tess.func_178180_c().func_181662_b(x, y - (double)offset, z).func_187315_a((double)xStart, (double)yEnd).func_181675_d();
                renderer.addVertexWithUV(x + 1.0, y - (double)offset, z, xEnd, yEnd);
                renderer.endVertex();
                renderer.addVertexWithUV(x + 1.0, y - (double)offset, z + 1.0, xEnd, yStart);
                renderer.endVertex();
                renderer.addVertexWithUV(x, y - (double)offset, z + 1.0, xStart, yStart);
                renderer.endVertex();
                break;
            }
            case UP: {
                renderer.addVertexWithUV(x, y + 1.0 + (double)offset, z + 1.0, xStart, yEnd);
                renderer.endVertex();
                renderer.addVertexWithUV(x + 1.0, y + 1.0 + (double)offset, z + 1.0, xEnd, yEnd);
                renderer.endVertex();
                renderer.addVertexWithUV(x + 1.0, y + 1.0 + (double)offset, z, xEnd, yStart);
                renderer.endVertex();
                renderer.addVertexWithUV(x, y + 1.0 + (double)offset, z, xStart, yStart);
                renderer.endVertex();
                break;
            }
            case NORTH: {
                renderer.addVertexWithUV(x + 1.0, y, z - (double)offset, xStart, yEnd);
                renderer.endVertex();
                renderer.addVertexWithUV(x, y, z - (double)offset, xEnd, yEnd);
                renderer.endVertex();
                renderer.addVertexWithUV(x, y + 1.0, z - (double)offset, xEnd, yStart);
                renderer.endVertex();
                renderer.addVertexWithUV(x + 1.0, y + 1.0, z - (double)offset, xStart, yStart);
                renderer.endVertex();
                break;
            }
            case SOUTH: {
                renderer.addVertexWithUV(x, y, z + 1.0 + (double)offset, xStart, yEnd);
                renderer.endVertex();
                renderer.addVertexWithUV(x + 1.0, y, z + 1.0 + (double)offset, xEnd, yEnd);
                renderer.endVertex();
                renderer.addVertexWithUV(x + 1.0, y + 1.0, z + 1.0 + (double)offset, xEnd, yStart);
                renderer.endVertex();
                renderer.addVertexWithUV(x, y + 1.0, z + 1.0 + (double)offset, xStart, yStart);
                renderer.endVertex();
                break;
            }
            case WEST: {
                renderer.addVertexWithUV(x - (double)offset, y, z, xStart, yEnd);
                renderer.endVertex();
                renderer.addVertexWithUV(x - (double)offset, y, z + 1.0, xEnd, yEnd);
                renderer.endVertex();
                renderer.addVertexWithUV(x - (double)offset, y + 1.0, z + 1.0, xEnd, yStart);
                renderer.endVertex();
                renderer.addVertexWithUV(x - (double)offset, y + 1.0, z, xStart, yStart);
                renderer.endVertex();
                break;
            }
            case EAST: {
                renderer.addVertexWithUV(x + 1.0 + (double)offset, y, z + 1.0, xStart, yEnd);
                renderer.endVertex();
                renderer.addVertexWithUV(x + 1.0 + (double)offset, y, z, xEnd, yEnd);
                renderer.endVertex();
                renderer.addVertexWithUV(x + 1.0 + (double)offset, y + 1.0, z, xEnd, yStart);
                renderer.endVertex();
                renderer.addVertexWithUV(x + 1.0 + (double)offset, y + 1.0, z + 1.0, xStart, yStart);
                renderer.endVertex();
            }
        }
    }

    private static boolean isPlayerHoldingPaintingTool() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_184614_ca();
        if (stack != null) {
            Item item = stack.func_77973_b();
            if (item instanceof IBlockPainter) {
                return true;
            }
            if (item == ModItems.COLOUR_PICKER) {
                return true;
            }
            if (item == ModItems.BLOCK_MARKER) {
                return true;
            }
        }
        return false;
    }
}

