/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.holiday;

import java.util.Calendar;
import moe.plushie.armourers_workshop.common.config.ConfigHandler;
import moe.plushie.armourers_workshop.common.holiday.ModHolidays;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Holiday {
    private final String name;
    private Calendar startDate;
    private Calendar endDate;
    private boolean enabled = true;

    public Holiday(String name, int dayOfMonth, int month, int lengthInDays, int lengthInHours) {
        this.name = name;
        this.startDate = Calendar.getInstance();
        this.startDate.set(12, 0);
        this.startDate.set(11, 0);
        this.startDate.set(2, month);
        this.startDate.set(5, dayOfMonth);
        this.endDate = (Calendar)this.startDate.clone();
        this.endDate.add(6, lengthInDays);
        this.endDate.add(11, lengthInHours);
        ModHolidays.getHolidays().add(this);
    }

    public String getName() {
        return this.name;
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ItemStack getGiftSack() {
        return ItemStack.field_190927_a;
    }

    public ItemStack getGift(EntityPlayer player) {
        return ItemStack.field_190927_a;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isHolidayActive() {
        Calendar current;
        if (ConfigHandler.disableAllHolidayEvents) {
            return false;
        }
        return this.enabled && (current = Calendar.getInstance()).after(this.startDate) & current.before(this.endDate);
    }

    public boolean hasGiftSack() {
        return !this.getGiftSack().func_190926_b();
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        return TranslateUtils.translate("holiday.armourers_workshop:" + this.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Holiday other = (Holiday)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

