/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.library.global.task;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.exceptions.AuthenticationException;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.common.library.global.MultipartForm;
import moe.plushie.armourers_workshop.common.library.global.auth.PlushieAuth;
import moe.plushie.armourers_workshop.common.library.global.auth.PlushieSession;
import moe.plushie.armourers_workshop.common.library.global.permission.PermissionSystem;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTask;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTaskResult;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTaskSkinReport;
import moe.plushie.armourers_workshop.utils.ModLogger;

public class GlobalTaskGetReportList
extends GlobalTask<Result> {
    private static final String URL = "mod-get-skin-reports.php";
    private final int page;
    private final int count;
    private final Filter filter;

    public GlobalTaskGetReportList(int page, int count, Filter filter) {
        super(PermissionSystem.PlushieAction.GET_REPORT_LIST, true);
        this.page = page;
        this.count = count;
        this.filter = filter;
    }

    @Override
    public Result call() throws Exception {
        this.permissionCheck();
        if (!GlobalTaskGetReportList.authenticateUser()) {
            throw new AuthenticationException();
        }
        PlushieSession plushieSession = PlushieAuth.PLUSHIE_SESSION;
        MultipartForm multipartForm = new MultipartForm(this.getBaseUrl() + URL);
        multipartForm.addText("userId", String.valueOf(plushieSession.getServerId()));
        multipartForm.addText("accessToken", plushieSession.getAccessToken());
        multipartForm.addText("page", String.valueOf(this.page));
        multipartForm.addText("size", String.valueOf(this.count));
        multipartForm.addText("filter", this.filter.toString().toLowerCase());
        String downloadString = multipartForm.upload();
        ModLogger.log(downloadString);
        JsonObject jsonObject = new JsonParser().parse(downloadString).getAsJsonObject();
        if (jsonObject.has("valid")) {
            boolean valid = jsonObject.get("valid").getAsBoolean();
            if (valid) {
                ArrayList<GlobalTaskSkinReport.SkinReport> skinReports = new ArrayList<GlobalTaskSkinReport.SkinReport>();
                JsonArray results = jsonObject.get("results").getAsJsonArray();
                for (int i = 0; i < results.size(); ++i) {
                    JsonObject jsonObject2 = results.get(i).getAsJsonObject();
                }
                return new Result(GlobalTaskResult.SUCCESS, jsonObject.toString(), skinReports);
            }
            if (jsonObject.has("reason")) {
                return new Result(GlobalTaskResult.FAILED, jsonObject.get("reason").getAsString(), new ArrayList<GlobalTaskSkinReport.SkinReport>());
            }
        }
        return new Result(GlobalTaskResult.FAILED, downloadString, new ArrayList<GlobalTaskSkinReport.SkinReport>());
    }

    public class Result {
        private GlobalTaskResult result;
        private String message;
        private ArrayList<GlobalTaskSkinReport.SkinReport> skinReports;

        public Result(GlobalTaskResult result, String message, ArrayList<GlobalTaskSkinReport.SkinReport> skinReports) {
            this.result = result;
            this.message = message;
        }

        public GlobalTaskResult getResult() {
            return this.result;
        }

        public String getMessage() {
            return this.message;
        }

        public ArrayList<GlobalTaskSkinReport.SkinReport> getSkinReports() {
            return this.skinReports;
        }
    }

    public static enum Filter {
        OPEN,
        CLOSED,
        ALL;

    }
}

