/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.skin.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.common.skin.entity.ISkinnableEntity;
import moe.plushie.armourers_workshop.api.common.skin.entity.ISkinnableEntityRegisty;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.common.config.ConfigHandler;
import moe.plushie.armourers_workshop.common.library.ILibraryManager;
import moe.plushie.armourers_workshop.common.library.LibraryFile;
import moe.plushie.armourers_workshop.common.library.LibraryFileList;
import moe.plushie.armourers_workshop.common.skin.entity.SkinnableEntityChicken;
import moe.plushie.armourers_workshop.common.skin.entity.SkinnableEntityCreeper;
import moe.plushie.armourers_workshop.common.skin.entity.SkinnableEntityGhast;
import moe.plushie.armourers_workshop.common.skin.entity.SkinnableEntityMannequin;
import moe.plushie.armourers_workshop.common.skin.entity.SkinnableEntityPlayer;
import moe.plushie.armourers_workshop.common.skin.entity.SkinnableEntitySkeleton;
import moe.plushie.armourers_workshop.common.skin.entity.SkinnableEntitySlime;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;

public final class SkinnableEntityRegisty
implements ISkinnableEntityRegisty {
    public static SkinnableEntityRegisty INSTANCE;
    private HashMap<Class<? extends Entity>, ISkinnableEntity> entityMap;

    public static void init() {
        INSTANCE = new SkinnableEntityRegisty();
    }

    public SkinnableEntityRegisty() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.entityMap = new HashMap();
        this.registerEntities();
    }

    private void registerEntities() {
        this.registerEntity(new SkinnableEntityChicken());
        this.registerEntity(new SkinnableEntityCreeper());
        this.registerEntity(new SkinnableEntityGhast());
        this.registerEntity(new SkinnableEntityPlayer());
        this.registerEntity(new SkinnableEntitySkeleton());
        this.registerEntity(new SkinnableEntitySlime());
        this.registerEntity(new SkinnableEntityMannequin());
    }

    @Override
    public void registerEntity(ISkinnableEntity skinnableEntity) {
        if (skinnableEntity == null) {
            return;
        }
        if (skinnableEntity.getEntityClass() == null) {
            return;
        }
        ModLogger.log(String.format("Registering %s as a skinnable entity.", skinnableEntity.getEntityClass()));
        this.entityMap.put(skinnableEntity.getEntityClass(), skinnableEntity);
    }

    @Override
    public ISkinnableEntity getSkinnableEntity(Entity entity) {
        if (this.entityMap.containsKey(entity.getClass())) {
            return this.entityMap.get(entity.getClass());
        }
        for (int i = 0; i < this.entityMap.size(); ++i) {
            Class entityClass = (Class)this.entityMap.keySet().toArray()[i];
            if (!entityClass.isAssignableFrom(entity.getClass())) continue;
            return this.entityMap.get(entityClass);
        }
        return null;
    }

    @Override
    public boolean isValidEntity(Entity entity) {
        return this.entityMap.containsKey(entity.getClass());
    }

    public boolean canUseWandOfStyleOnEntity(Entity entity, EntityPlayer user) {
        ISkinnableEntity skinnableEntity = this.getSkinnableEntity(entity);
        if (skinnableEntity != null) {
            return skinnableEntity.canUseWandOfStyle(user);
        }
        return false;
    }

    private void dropEntitySkins(Entity entity) {
        if (ConfigHandler.entityDropSkinChance <= 0) {
            return;
        }
        int rnd = entity.func_130014_f_().field_73012_v.nextInt(99) + 1;
    }

    public LibraryFile getRandomSkinOfType(ISkinType skinType) {
        ILibraryManager libraryManager = ArmourersWorkshop.getProxy().libraryManager;
        LibraryFileList fileList = null;
        fileList = ArmourersWorkshop.isDedicated() ? libraryManager.getServerPublicFileList() : libraryManager.getClientPublicFileList();
        ArrayList<LibraryFile> typeList = fileList.getCachedFileListForSkinType(skinType);
        if (typeList == null) {
            return null;
        }
        ArrayList<LibraryFile> validFiles = new ArrayList<LibraryFile>();
        for (int i = 0; i < typeList.size(); ++i) {
            if (!typeList.get((int)i).filePath.startsWith(ConfigHandler.enitiySpawnSkinTargetPath)) continue;
            validFiles.add(typeList.get(i));
        }
        Random random = new Random();
        if (!validFiles.isEmpty()) {
            return (LibraryFile)validFiles.get(random.nextInt(validFiles.size()));
        }
        return null;
    }

    public ArrayList<ISkinnableEntity> getRegisteredEntities() {
        ArrayList<ISkinnableEntity> entityList = new ArrayList<ISkinnableEntity>();
        for (int i = 0; i < this.entityMap.size(); ++i) {
            Class entityClass = (Class)this.entityMap.keySet().toArray()[i];
            ISkinnableEntity entity = this.entityMap.get(entityClass);
            if (entity == null) continue;
            entityList.add(entity);
        }
        return entityList;
    }
}

