/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.skin.exporter;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import moe.plushie.armourers_workshop.api.common.IPoint3D;
import moe.plushie.armourers_workshop.client.model.bake.ColouredFace;
import moe.plushie.armourers_workshop.client.skin.ClientSkinPartData;
import moe.plushie.armourers_workshop.common.painting.PaintTypeRegistry;
import moe.plushie.armourers_workshop.common.painting.PaintingHelper;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinPart;
import moe.plushie.armourers_workshop.common.skin.exporter.ISkinExporter;
import moe.plushie.armourers_workshop.proxies.ClientProxy;
import moe.plushie.armourers_workshop.utils.ModLogger;

public class SkinExporterWavefrontObj
implements ISkinExporter {
    private static final String CRLF = "\n";
    private int textureX;
    private int textureY;
    private int faceIndex;
    private float scale;

    @Override
    public String[] getFileExtensions() {
        return new String[]{"obj"};
    }

    @Override
    public void exportSkin(Skin skin, File filePath, String filename, float scale) {
        this.textureX = 0;
        this.textureY = 0;
        this.faceIndex = 0;
        this.scale = scale;
        File outputFile = new File(filePath, filename + ".obj");
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             OutputStreamWriter os = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
            int totalFaces = 0;
            for (int i = 0; i < skin.getPartCount(); ++i) {
                SkinPart skinPart = skin.getParts().get(i);
                for (int j = 0; j < ClientProxy.getNumberOfRenderLayers(); ++j) {
                    totalFaces += skinPart.getClientSkinPartData().vertexLists[j].size();
                }
            }
            ModLogger.log("Exporting skin with " + totalFaces + " total faces.");
            int textureSize = 0;
            while (textureSize * textureSize < totalFaces * 4) {
                ModLogger.log("Texture size " + textureSize);
                textureSize = this.getNextPowerOf2(textureSize + 1);
            }
            BufferedImage texture = new BufferedImage(textureSize, textureSize, 2);
            os.write("# WavefrontObj\n");
            os.write("# This file was exported from the Minecraft mod Armourer's Workshop\n");
            os.write("mtllib " + filename + ".mtl" + CRLF);
            for (int i = 0; i < skin.getPartCount(); ++i) {
                SkinPart skinPart = skin.getParts().get(i);
                this.exportPart(skinPart, skin, os, texture);
            }
            os.flush();
            fos.flush();
            ImageIO.write((RenderedImage)texture, "png", new File(filePath, filename + ".png"));
            this.createMtlFile(filePath, filename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createMtlFile(File filePath, String filename) {
        File outputFile = new File(filePath, filename + ".mtl");
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             OutputStreamWriter os = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
            os.write("newmtl basetexture\n");
            os.write("Ns 96.078431\n");
            os.write("Ka 1.000000 1.000000 1.000000\n");
            os.write("Kd 0.800000 0.800000 0.800000\n");
            os.write("Ks 0.500000 0.500000 0.500000\n");
            os.write("Ke 0.000000 0.000000 0.000000\n");
            os.write("Ni 1.000000\n");
            os.write("d 1.000000\n");
            os.write("illum 0\n");
            os.write("map_Kd " + filename + ".png" + CRLF);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void exportPart(SkinPart skinPart, Skin skin, OutputStreamWriter os, BufferedImage texture) throws IOException {
        ClientSkinPartData cspd = skinPart.getClientSkinPartData();
        for (int i = 0; i < ClientProxy.getNumberOfRenderLayers(); ++i) {
            this.exportLayer(skinPart, skin, os, texture, i);
        }
    }

    private void exportLayer(SkinPart skinPart, Skin skin, OutputStreamWriter os, BufferedImage texture, int layer) throws IOException {
        ColouredFace cf;
        int i;
        ClientSkinPartData cspd = skinPart.getClientSkinPartData();
        ArrayList<ColouredFace> faces = cspd.vertexLists[layer];
        if (faces.isEmpty()) {
            return;
        }
        ModLogger.log("Exporting part " + skinPart);
        os.write("o " + skinPart.getPartType().getRegistryName().replace(":", "_") + CRLF);
        os.write("usemtl basetexture\n");
        os.write("s 1\n");
        os.flush();
        ModLogger.log("faces to export " + faces.size());
        block16: for (int i2 = 0; i2 < faces.size(); ++i2) {
            ColouredFace cf2 = faces.get(i2);
            if (PaintTypeRegistry.getInstance().getPaintTypeFormByte(cf2.t) == PaintTypeRegistry.PAINT_TYPE_NONE) continue;
            switch (cf2.face) {
                case 0: {
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z), this.scale * (float)cf2.x, this.scale * (float)(-cf2.y) - this.scale);
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z) - this.scale, this.scale * (float)cf2.x, this.scale * (float)(-cf2.y) - this.scale);
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z) - this.scale, this.scale * (float)cf2.x + this.scale, this.scale * (float)(-cf2.y) - this.scale);
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z), this.scale * (float)cf2.x + this.scale, this.scale * (float)(-cf2.y) - this.scale);
                    continue block16;
                }
                case 1: {
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z), this.scale * (float)cf2.x + this.scale, this.scale * (float)(-cf2.y));
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z) - this.scale, this.scale * (float)cf2.x + this.scale, this.scale * (float)(-cf2.y));
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z) - this.scale, this.scale * (float)cf2.x, this.scale * (float)(-cf2.y));
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z), this.scale * (float)cf2.x, this.scale * (float)(-cf2.y));
                    continue block16;
                }
                case 2: {
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z), this.scale * (float)cf2.x, this.scale * (float)(-cf2.y) - this.scale);
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z), this.scale * (float)cf2.x + this.scale, this.scale * (float)(-cf2.y) - this.scale);
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z), this.scale * (float)cf2.x + this.scale, this.scale * (float)(-cf2.y));
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z), this.scale * (float)cf2.x, this.scale * (float)(-cf2.y));
                    continue block16;
                }
                case 3: {
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z) - this.scale, this.scale * (float)cf2.x, this.scale * (float)(-cf2.y));
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z) - this.scale, this.scale * (float)cf2.x + this.scale, this.scale * (float)(-cf2.y));
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z) - this.scale, this.scale * (float)cf2.x + this.scale, this.scale * (float)(-cf2.y) - this.scale);
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z) - this.scale, this.scale * (float)cf2.x, this.scale * (float)(-cf2.y) - this.scale);
                    continue block16;
                }
                case 4: {
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z), this.scale * (float)cf2.x + this.scale, this.scale * (float)(-cf2.y) - this.scale);
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z) - this.scale, this.scale * (float)cf2.x + this.scale, this.scale * (float)(-cf2.y) - this.scale);
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z) - this.scale, this.scale * (float)cf2.x + this.scale, this.scale * (float)(-cf2.y));
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z), this.scale * (float)cf2.x + this.scale, this.scale * (float)(-cf2.y));
                    continue block16;
                }
                case 5: {
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z), this.scale * (float)cf2.x, this.scale * (float)(-cf2.y));
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z) - this.scale, this.scale * (float)cf2.x, this.scale * (float)(-cf2.y));
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z) - this.scale, this.scale * (float)cf2.x, this.scale * (float)(-cf2.y) - this.scale);
                    this.writeVert(skinPart, os, this.scale * (float)(-cf2.z), this.scale * (float)cf2.x, this.scale * (float)(-cf2.y) - this.scale);
                    continue block16;
                }
            }
        }
        int textureSize = texture.getWidth();
        float pixelSize = 1.0f / (float)textureSize * 2.0f;
        for (i = 0; i < faces.size(); ++i) {
            cf = faces.get(i);
            if (PaintTypeRegistry.getInstance().getPaintTypeFormByte(cf.t) == PaintTypeRegistry.PAINT_TYPE_NONE) continue;
            int colour = PaintingHelper.bytesToInt(new byte[]{cf.r, cf.g, cf.b, -1});
            texture.setRGB(this.textureX, textureSize - 1 - this.textureY, colour);
            texture.setRGB(this.textureX + 1, textureSize - 1 - this.textureY, colour);
            texture.setRGB(this.textureX, textureSize - 1 - this.textureY - 1, colour);
            texture.setRGB(this.textureX + 1, textureSize - 1 - this.textureY - 1, colour);
            float shift = pixelSize / 4.0f;
            os.write(String.format("vt %f %f", Float.valueOf((float)this.textureX / 2.0f * pixelSize + pixelSize - shift), Float.valueOf((float)this.textureY / 2.0f * pixelSize + shift)) + CRLF);
            os.write(String.format("vt %f %f", Float.valueOf((float)this.textureX / 2.0f * pixelSize + pixelSize - shift), Float.valueOf((float)this.textureY / 2.0f * pixelSize + pixelSize - shift)) + CRLF);
            os.write(String.format("vt %f %f", Float.valueOf((float)this.textureX / 2.0f * pixelSize + shift), Float.valueOf((float)this.textureY / 2.0f * pixelSize + pixelSize - shift)) + CRLF);
            os.write(String.format("vt %f %f", Float.valueOf((float)this.textureX / 2.0f * pixelSize + shift), Float.valueOf((float)this.textureY / 2.0f * pixelSize + shift)) + CRLF);
            ++this.textureX;
            ++this.textureX;
            if (this.textureX < textureSize) continue;
            this.textureX = 0;
            ++this.textureY;
            ++this.textureY;
        }
        block18: for (i = 0; i < faces.size(); ++i) {
            cf = faces.get(i);
            if (PaintTypeRegistry.getInstance().getPaintTypeFormByte(faces.get((int)i).t) == PaintTypeRegistry.PAINT_TYPE_NONE) continue;
            switch (cf.face) {
                case 0: {
                    os.write("vn 0 -0.1 0\n");
                    continue block18;
                }
                case 1: {
                    os.write("vn 0 0.1 0\n");
                    continue block18;
                }
                case 2: {
                    os.write("vn 0.1 0 0\n");
                    continue block18;
                }
                case 3: {
                    os.write("vn -1 0 0\n");
                    continue block18;
                }
                case 4: {
                    os.write("vn 0 0 1\n");
                    continue block18;
                }
                case 5: {
                    os.write("vn 0 0 -1\n");
                    continue block18;
                }
            }
        }
        for (i = 0; i < faces.size(); ++i) {
            if (PaintTypeRegistry.getInstance().getPaintTypeFormByte(faces.get((int)i).t) == PaintTypeRegistry.PAINT_TYPE_NONE) continue;
            os.write("f");
            os.write(String.format(" %d/%d/%d", 4 * this.faceIndex + 1, 4 * this.faceIndex + 1, this.faceIndex + 1));
            os.write(String.format(" %d/%d/%d", 4 * this.faceIndex + 2, 4 * this.faceIndex + 2, this.faceIndex + 1));
            os.write(String.format(" %d/%d/%d", 4 * this.faceIndex + 3, 4 * this.faceIndex + 3, this.faceIndex + 1));
            os.write(String.format(" %d/%d/%d", 4 * this.faceIndex + 4, 4 * this.faceIndex + 4, this.faceIndex + 1));
            os.write(CRLF);
            ++this.faceIndex;
        }
    }

    private void writeVert(SkinPart skinPart, OutputStreamWriter os, float x, float y, float z) throws IOException {
        IPoint3D pos = skinPart.getPartType().getItemRenderOffset();
        os.write(String.format("v %f %f %f", Float.valueOf(x + -this.scale * (float)pos.getZ()), Float.valueOf(z + -this.scale * (float)pos.getY()), Float.valueOf(y * -1.0f + -this.scale * (float)pos.getX())) + CRLF);
    }

    private int getNextPowerOf2(int value) {
        return (int)Math.pow(2.0, 32 - Integer.numberOfLeadingZeros(value - 1));
    }
}

