/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.WorldServer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.INbt;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IRayTrace;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IEntityItem;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.api.wrapper.RayTraceWrapper;
import noppes.npcs.controllers.ServerCloneController;

public class EntityWrapper<T extends Entity>
implements IEntity {
    protected T entity;
    private Map<String, Object> tempData = new HashMap<String, Object>();
    private IWorld worldWrapper;
    private final IData tempdata = new IData(){

        @Override
        public void put(String key, Object value) {
            EntityWrapper.this.tempData.put(key, value);
        }

        @Override
        public Object get(String key) {
            return EntityWrapper.this.tempData.get(key);
        }

        @Override
        public void remove(String key) {
            EntityWrapper.this.tempData.remove(key);
        }

        @Override
        public boolean has(String key) {
            return EntityWrapper.this.tempData.containsKey(key);
        }

        @Override
        public void clear() {
            EntityWrapper.this.tempData.clear();
        }

        @Override
        public String[] getKeys() {
            return EntityWrapper.this.tempData.keySet().toArray(new String[EntityWrapper.this.tempData.size()]);
        }
    };
    private final IData storeddata = new IData(){

        @Override
        public void put(String key, Object value) {
            NBTTagCompound compound = this.getStoredCompound();
            if (value instanceof Number) {
                compound.func_74780_a(key, ((Number)value).doubleValue());
            } else if (value instanceof String) {
                compound.func_74778_a(key, (String)value);
            }
            this.saveStoredCompound(compound);
        }

        @Override
        public Object get(String key) {
            NBTTagCompound compound = this.getStoredCompound();
            if (!compound.func_74764_b(key)) {
                return null;
            }
            NBTBase base = compound.func_74781_a(key);
            if (base instanceof NBTPrimitive) {
                return ((NBTPrimitive)base).func_150286_g();
            }
            return ((NBTTagString)base).func_150285_a_();
        }

        @Override
        public void remove(String key) {
            NBTTagCompound compound = this.getStoredCompound();
            compound.func_82580_o(key);
            this.saveStoredCompound(compound);
        }

        @Override
        public boolean has(String key) {
            return this.getStoredCompound().func_74764_b(key);
        }

        @Override
        public void clear() {
            EntityWrapper.this.entity.getEntityData().func_82580_o("CNPCStoredData");
        }

        private NBTTagCompound getStoredCompound() {
            NBTTagCompound compound = EntityWrapper.this.entity.getEntityData().func_74775_l("CNPCStoredData");
            if (compound == null) {
                compound = new NBTTagCompound();
                EntityWrapper.this.entity.getEntityData().func_74782_a("CNPCStoredData", (NBTBase)compound);
            }
            return compound;
        }

        private void saveStoredCompound(NBTTagCompound compound) {
            EntityWrapper.this.entity.getEntityData().func_74782_a("CNPCStoredData", (NBTBase)compound);
        }

        @Override
        public String[] getKeys() {
            NBTTagCompound compound = this.getStoredCompound();
            return compound.func_150296_c().toArray(new String[compound.func_150296_c().size()]);
        }
    };

    public EntityWrapper(T entity) {
        this.entity = entity;
        this.worldWrapper = NpcAPI.Instance().getIWorld((WorldServer)((Entity)entity).field_70170_p);
    }

    @Override
    public double getX() {
        return ((Entity)this.entity).field_70165_t;
    }

    @Override
    public void setX(double x) {
        ((Entity)this.entity).field_70165_t = x;
    }

    @Override
    public double getY() {
        return ((Entity)this.entity).field_70163_u;
    }

    @Override
    public void setY(double y) {
        ((Entity)this.entity).field_70163_u = y;
    }

    @Override
    public double getZ() {
        return ((Entity)this.entity).field_70161_v;
    }

    @Override
    public void setZ(double z) {
        ((Entity)this.entity).field_70161_v = z;
    }

    @Override
    public int getBlockX() {
        return MathHelper.func_76128_c((double)((Entity)this.entity).field_70165_t);
    }

    @Override
    public int getBlockY() {
        return MathHelper.func_76128_c((double)((Entity)this.entity).field_70163_u);
    }

    @Override
    public int getBlockZ() {
        return MathHelper.func_76128_c((double)((Entity)this.entity).field_70161_v);
    }

    @Override
    public String getEntityName() {
        String s = EntityList.func_75621_b(this.entity);
        if (s == null) {
            s = "generic";
        }
        return I18n.func_74838_a((String)("entity." + s + ".name"));
    }

    @Override
    public String getName() {
        return this.entity.func_70005_c_();
    }

    @Override
    public void setName(String name) {
        this.entity.func_96094_a(name);
    }

    @Override
    public boolean hasCustomName() {
        return this.entity.func_145818_k_();
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.entity.func_70107_b(x, y, z);
    }

    @Override
    public IWorld getWorld() {
        if (((Entity)this.entity).field_70170_p != this.worldWrapper.getMCWorld()) {
            this.worldWrapper = NpcAPI.Instance().getIWorld((WorldServer)((Entity)this.entity).field_70170_p);
        }
        return this.worldWrapper;
    }

    @Override
    public boolean isAlive() {
        return this.entity.func_70089_S();
    }

    @Override
    public IData getTempdata() {
        return this.tempdata;
    }

    @Override
    public IData getStoreddata() {
        return this.storeddata;
    }

    @Override
    public long getAge() {
        return ((Entity)this.entity).field_70173_aa;
    }

    @Override
    public void damage(float amount) {
        this.entity.func_70097_a(DamageSource.field_76377_j, amount);
    }

    @Override
    public void despawn() {
        ((Entity)this.entity).field_70128_L = true;
    }

    @Override
    public void spawn() {
        if (this.worldWrapper.getMCWorld().func_175733_a(this.entity.func_110124_au()) != null) {
            throw new CustomNPCsException("Entity is already spawned", new Object[0]);
        }
        ((Entity)this.entity).field_70128_L = false;
        this.worldWrapper.getMCWorld().func_72838_d(this.entity);
    }

    @Override
    public void kill() {
        this.entity.func_70106_y();
    }

    @Override
    public boolean inWater() {
        return this.entity.func_70055_a(Material.field_151586_h);
    }

    @Override
    public boolean inLava() {
        return this.entity.func_70055_a(Material.field_151587_i);
    }

    @Override
    public boolean inFire() {
        return this.entity.func_70055_a(Material.field_151581_o);
    }

    @Override
    public boolean isBurning() {
        return this.entity.func_70027_ad();
    }

    @Override
    public void setBurning(int ticks) {
        this.entity.func_70015_d(ticks);
    }

    @Override
    public void extinguish() {
        this.entity.func_70066_B();
    }

    @Override
    public String getTypeName() {
        return EntityList.func_75621_b(this.entity);
    }

    @Override
    public IEntityItem dropItem(IItemStack item) {
        return (IEntityItem)NpcAPI.Instance().getIEntity((Entity)this.entity.func_70099_a(item.getMCItemStack(), 0.0f));
    }

    @Override
    public IEntity[] getRiders() {
        List list = this.entity.func_184188_bt();
        IEntity[] riders = new IEntity[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            riders[i] = NpcAPI.Instance().getIEntity((Entity)list.get(i));
        }
        return riders;
    }

    @Override
    public IRayTrace rayTraceBlock(double distance, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox) {
        Vec3d vec3d = this.entity.func_174824_e(1.0f);
        Vec3d vec3d1 = this.entity.func_70676_i(1.0f);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * distance, vec3d1.field_72448_b * distance, vec3d1.field_72449_c * distance);
        RayTraceResult result = ((Entity)this.entity).field_70170_p.func_147447_a(vec3d, vec3d2, stopOnLiquid, ignoreBlockWithoutBoundingBox, true);
        if (result == null) {
            return null;
        }
        return new RayTraceWrapper(NpcAPI.Instance().getIBlock(((Entity)this.entity).field_70170_p, result.func_178782_a()), result.field_178784_b.func_176745_a());
    }

    @Override
    public IEntity[] rayTraceEntities(double distance, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox) {
        Vec3d vec3d = this.entity.func_174824_e(1.0f);
        Vec3d vec3d1 = this.entity.func_70676_i(1.0f);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * distance, vec3d1.field_72448_b * distance, vec3d1.field_72449_c * distance);
        RayTraceResult result = ((Entity)this.entity).field_70170_p.func_147447_a(vec3d, vec3d2, stopOnLiquid, ignoreBlockWithoutBoundingBox, false);
        if (result != null) {
            vec3d2 = new Vec3d(result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c);
        }
        return this.findEntityOnPath(distance, vec3d, vec3d2);
    }

    private IEntity[] findEntityOnPath(double distance, Vec3d vec3d, Vec3d vec3d1) {
        List list = ((Entity)this.entity).field_70170_p.func_72839_b(this.entity, this.entity.func_174813_aQ().func_186662_g(distance));
        ArrayList<IEntity> result = new ArrayList<IEntity>();
        for (Entity entity1 : list) {
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult1;
            if (!entity1.func_70067_L() || entity1 == this.entity || (raytraceresult1 = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y())).func_72327_a(vec3d, vec3d1)) == null) continue;
            result.add(NpcAPI.Instance().getIEntity(entity1));
        }
        result.sort((o1, o2) -> {
            double d2;
            double d1 = this.entity.func_70032_d(o1.getMCEntity());
            if (d1 == (d2 = (double)this.entity.func_70032_d(o2.getMCEntity()))) {
                return 0;
            }
            return d1 > d2 ? 1 : -1;
        });
        return result.toArray(new IEntity[result.size()]);
    }

    @Override
    public IEntity[] getAllRiders() {
        ArrayList list = new ArrayList(this.entity.func_184182_bu());
        IEntity[] riders = new IEntity[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            riders[i] = NpcAPI.Instance().getIEntity((Entity)list.get(i));
        }
        return riders;
    }

    @Override
    public void addRider(IEntity entity) {
        if (entity != null) {
            entity.getMCEntity().func_184205_a(this.entity, true);
        }
    }

    @Override
    public void clearRiders() {
        this.entity.func_184226_ay();
    }

    @Override
    public IEntity getMount() {
        return NpcAPI.Instance().getIEntity(this.entity.func_184187_bx());
    }

    @Override
    public void setMount(IEntity entity) {
        if (entity == null) {
            this.entity.func_184210_p();
        } else {
            this.entity.func_184205_a(entity.getMCEntity(), true);
        }
    }

    @Override
    public void setRotation(float rotation) {
        ((Entity)this.entity).field_70177_z = rotation;
    }

    @Override
    public float getRotation() {
        return ((Entity)this.entity).field_70177_z;
    }

    @Override
    public void setPitch(float rotation) {
        ((Entity)this.entity).field_70125_A = rotation;
    }

    @Override
    public float getPitch() {
        return ((Entity)this.entity).field_70125_A;
    }

    @Override
    public void knockback(int power, float direction) {
        float v = direction * (float)Math.PI / 180.0f;
        this.entity.func_70024_g((double)(-MathHelper.func_76126_a((float)v) * (float)power), 0.1 + (double)((float)power * 0.04f), (double)(MathHelper.func_76134_b((float)v) * (float)power));
        ((Entity)this.entity).field_70159_w *= 0.6;
        ((Entity)this.entity).field_70179_y *= 0.6;
        ((Entity)this.entity).field_70133_I = true;
    }

    @Override
    public boolean isSneaking() {
        return this.entity.func_70093_af();
    }

    @Override
    public boolean isSprinting() {
        return this.entity.func_70051_ag();
    }

    @Override
    public T getMCEntity() {
        return this.entity;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public boolean typeOf(int type) {
        return type == this.getType();
    }

    @Override
    public String getUUID() {
        return this.entity.func_110124_au().toString();
    }

    @Override
    public String generateNewUUID() {
        UUID id = UUID.randomUUID();
        this.entity.func_184221_a(id);
        return id.toString();
    }

    @Override
    public INbt getNbt() {
        return NpcAPI.Instance().getINbt(this.entity.getEntityData());
    }

    @Override
    public void storeAsClone(int tab, String name) {
        NBTTagCompound compound = new NBTTagCompound();
        if (!this.entity.func_184198_c(compound)) {
            throw new CustomNPCsException("Cannot store dead entities", new Object[0]);
        }
        ServerCloneController.Instance.addClone(compound, name, tab);
    }

    @Override
    public INbt getEntityNbt() {
        NBTTagCompound compound = new NBTTagCompound();
        this.entity.func_189511_e(compound);
        ResourceLocation resourcelocation = EntityList.func_191301_a(this.entity);
        if (this.getType() == 1) {
            resourcelocation = new ResourceLocation("player");
        }
        if (resourcelocation != null) {
            compound.func_74778_a("id", resourcelocation.toString());
        }
        return NpcAPI.Instance().getINbt(compound);
    }

    @Override
    public void setEntityNbt(INbt nbt) {
        this.entity.func_70020_e(nbt.getMCNBT());
    }

    @Override
    public void playAnimation(int type) {
        this.worldWrapper.getMCWorld().func_73039_n().func_151248_b(this.entity, (Packet)new SPacketAnimation(this.entity, type));
    }

    @Override
    public float getHeight() {
        return ((Entity)this.entity).field_70131_O;
    }

    @Override
    public float getEyeHeight() {
        return this.entity.func_70047_e();
    }

    @Override
    public float getWidth() {
        return ((Entity)this.entity).field_70130_N;
    }

    @Override
    public IPos getPos() {
        return new BlockPosWrapper(this.entity.func_180425_c());
    }

    @Override
    public void setPos(IPos pos) {
        this.entity.func_70107_b((double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f));
    }

    @Override
    public String[] getTags() {
        return this.entity.func_184216_O().toArray(new String[this.entity.func_184216_O().size()]);
    }

    @Override
    public void addTag(String tag) {
        this.entity.func_184211_a(tag);
    }

    @Override
    public boolean hasTag(String tag) {
        return this.entity.func_184216_O().contains(tag);
    }

    @Override
    public void removeTag(String tag) {
        this.entity.func_184197_b(tag);
    }

    @Override
    public double getMotionX() {
        return ((Entity)this.entity).field_70159_w;
    }

    @Override
    public double getMotionY() {
        return ((Entity)this.entity).field_70181_x;
    }

    @Override
    public double getMotionZ() {
        return ((Entity)this.entity).field_70179_y;
    }

    @Override
    public void setMotionX(double motion) {
        if (((Entity)this.entity).field_70159_w == motion) {
            return;
        }
        ((Entity)this.entity).field_70159_w = motion;
        ((Entity)this.entity).field_70133_I = true;
    }

    @Override
    public void setMotionY(double motion) {
        if (((Entity)this.entity).field_70181_x == motion) {
            return;
        }
        ((Entity)this.entity).field_70181_x = motion;
        ((Entity)this.entity).field_70133_I = true;
    }

    @Override
    public void setMotionZ(double motion) {
        if (((Entity)this.entity).field_70179_y == motion) {
            return;
        }
        ((Entity)this.entity).field_70179_y = motion;
        ((Entity)this.entity).field_70133_I = true;
    }
}

