/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.animation.types;

import maninthehouse.epicfight.animation.Animator;
import maninthehouse.epicfight.animation.JointTransform;
import maninthehouse.epicfight.animation.Pose;
import maninthehouse.epicfight.animation.TransformSheet;
import maninthehouse.epicfight.animation.types.ImmovableAnimation;
import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.capabilities.entity.player.PlayerData;
import maninthehouse.epicfight.entity.event.EntityEventListener;
import maninthehouse.epicfight.model.Armature;
import maninthehouse.epicfight.utils.math.Vec3f;
import maninthehouse.epicfight.utils.math.Vec4f;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayerMP;

public class ActionAnimation
extends ImmovableAnimation {
    protected final boolean breakMovement;
    protected final boolean affectYCoord;
    protected float delayTime;

    public ActionAnimation(int id, float convertTime, boolean breakMove, boolean affectY, String path) {
        this(id, convertTime, -1.0f, breakMove, affectY, path);
    }

    public ActionAnimation(int id, float convertTime, float postDelay, boolean breakMove, boolean affectY, String path) {
        super(id, convertTime, path);
        this.breakMovement = breakMove;
        this.affectYCoord = affectY;
        this.delayTime = postDelay;
    }

    @Override
    public void onActivate(LivingData<?> entity) {
        super.onActivate(entity);
        Object orgEntity = entity.getOriginalEntity();
        float yaw = ((Entity)orgEntity).field_70177_z;
        orgEntity.func_70034_d(yaw);
        orgEntity.func_181013_g(yaw);
        if (this.breakMovement) {
            ((EntityLivingBase)entity.getOriginalEntity()).field_70159_w = 0.0;
            ((EntityLivingBase)entity.getOriginalEntity()).field_70181_x = 0.0;
            ((EntityLivingBase)entity.getOriginalEntity()).field_70179_y = 0.0;
        }
        if (entity instanceof PlayerData) {
            ((PlayerData)entity).getEventListener().activateEvents(EntityEventListener.Event.ON_ACTION_SERVER_EVENT);
        }
    }

    @Override
    public void onUpdate(LivingData<?> entity) {
        super.onUpdate(entity);
        Object livingentity = entity.getOriginalEntity();
        if (entity.isRemote() ? !(livingentity instanceof EntityPlayerSP) : livingentity instanceof EntityPlayerMP) {
            return;
        }
        if (entity.isInaction()) {
            Vec3f vec3 = this.getCoordVector(entity);
            IAttributeInstance attribute = livingentity.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
            double moveMultiplier = attribute.func_111126_e() / attribute.func_111125_b();
            livingentity.func_70091_d(MoverType.SELF, (double)vec3.x * moveMultiplier, (double)vec3.y, (double)vec3.z * moveMultiplier);
        }
    }

    @Override
    public LivingData.EntityState getState(float time) {
        if (time < this.delayTime) {
            return LivingData.EntityState.PRE_DELAY;
        }
        return LivingData.EntityState.FREE;
    }

    @Override
    public Pose getPoseByTime(LivingData<?> entity, float time) {
        Pose pose = new Pose();
        for (String jointName : this.jointTransforms.keySet()) {
            JointTransform jt = ((TransformSheet)this.jointTransforms.get(jointName)).getInterpolatedTransform(time);
            if (jointName.equals("Root")) {
                Vec3f vec = jt.getPosition();
                vec.x = 0.0f;
                vec.y = this.affectYCoord && vec.y > 0.0f ? 0.0f : vec.y;
                vec.z = 0.0f;
            }
            pose.putJointData(jointName, jt);
        }
        return pose;
    }

    @Override
    public StaticAnimation bindFull(Armature armature) {
        super.bindFull(armature);
        if (this.delayTime < 0.0f) {
            this.delayTime = this.totalTime;
        }
        return this;
    }

    protected Vec3f getCoordVector(LivingData<?> entitydata) {
        Object elb = entitydata.getOriginalEntity();
        JointTransform jt = ((TransformSheet)this.jointTransforms.get("Root")).getInterpolatedTransform(((Animator)entitydata.getAnimator()).getPlayer().getElapsedTime());
        JointTransform prevJt = ((TransformSheet)this.jointTransforms.get("Root")).getInterpolatedTransform(((Animator)entitydata.getAnimator()).getPlayer().getPrevElapsedTime());
        Vec4f currentPos = new Vec4f(jt.getPosition().x, jt.getPosition().y, jt.getPosition().z, 1.0f);
        Vec4f prevPos = new Vec4f(prevJt.getPosition().x, prevJt.getPosition().y, prevJt.getPosition().z, 1.0f);
        VisibleMatrix4f mat = entitydata.getModelMatrix(1.0f);
        mat.m30 = 0.0f;
        mat.m31 = 0.0f;
        mat.m32 = 0.0f;
        VisibleMatrix4f.transform(mat, currentPos, currentPos);
        VisibleMatrix4f.transform(mat, prevPos, prevPos);
        boolean hasNoGravity = entitydata.getOriginalEntity().func_189652_ae();
        float dx = prevPos.x - currentPos.x;
        float dy = this.affectYCoord && currentPos.y > 0.0f || hasNoGravity ? currentPos.y - prevPos.y : 0.0f;
        float dz = prevPos.z - currentPos.z;
        if (this.affectYCoord && currentPos.y > 0.0f && !hasNoGravity) {
            ((EntityLivingBase)elb).field_70181_x += 0.08;
        }
        return new Vec3f(dx, dy, dz);
    }
}

