/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.animation.types;

import maninthehouse.epicfight.animation.AnimationPlayer;
import maninthehouse.epicfight.animation.JointTransform;
import maninthehouse.epicfight.animation.Pose;
import maninthehouse.epicfight.animation.Quaternion;
import maninthehouse.epicfight.animation.TransformSheet;
import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.client.animation.AnimatorClient;
import maninthehouse.epicfight.collada.AnimationDataExtractor;
import maninthehouse.epicfight.model.Armature;
import maninthehouse.epicfight.utils.math.Vec3f;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;

public class AimingAnimation
extends StaticAnimation {
    public StaticAnimation lookUp;
    public StaticAnimation lookDown;

    public AimingAnimation(int id, float convertTime, boolean repeatPlay, String path1, String path2, String path3) {
        super(id, convertTime, repeatPlay, path1);
        this.lookUp = new StaticAnimation(path2);
        this.lookDown = new StaticAnimation(path3);
    }

    @Override
    public void onUpdate(LivingData<?> entitydata) {
        AnimationPlayer player;
        super.onUpdate(entitydata);
        AnimatorClient animator = entitydata.getClientAnimator();
        if (animator.mixLayerActivated && (player = animator.getMixLayerPlayer()).getElapsedTime() >= this.totalTime - 0.06f) {
            animator.mixLayer.pause = true;
        }
    }

    @Override
    public Pose getPoseByTime(LivingData<?> entitydata, float time) {
        if (entitydata.isFirstPerson()) {
            return super.getPoseByTime(entitydata, time);
        }
        float pitch = entitydata.getPitch(Minecraft.func_71410_x().func_184121_ak());
        StaticAnimation interpolateAnimation = pitch > 0.0f ? this.lookDown : this.lookUp;
        Pose pose1 = this.getPoseByTime(time);
        Pose pose2 = interpolateAnimation.getPoseByTime(entitydata, time);
        Pose interpolatedPose = Pose.interpolatePose(pose1, pose2, Math.abs(pitch) / 90.0f);
        JointTransform chest = interpolatedPose.getTransformByName("Chest");
        JointTransform head = interpolatedPose.getTransformByName("Head");
        float f = 90.0f;
        float ratio = (f - Math.abs(((EntityLivingBase)entitydata.getOriginalEntity()).field_70125_A)) / f;
        float yawOffset = entitydata.getOriginalEntity().func_184187_bx() != null ? ((EntityLivingBase)entitydata.getOriginalEntity()).field_70177_z : ((EntityLivingBase)entitydata.getOriginalEntity()).field_70761_aq;
        chest.setRotation(Quaternion.rotate((float)(-Math.toRadians((((EntityLivingBase)entitydata.getOriginalEntity()).field_70177_z - yawOffset) * ratio)), new Vec3f(0.0f, 1.0f, 0.0f), chest.getRotation()));
        head.setRotation(Quaternion.rotate((float)(-Math.toRadians((yawOffset - ((EntityLivingBase)entitydata.getOriginalEntity()).field_70177_z) * ratio)), new Vec3f(0.0f, 1.0f, 0.0f), head.getRotation()));
        return interpolatedPose;
    }

    private Pose getPoseByTime(float time) {
        Pose pose = new Pose();
        for (String jointName : this.jointTransforms.keySet()) {
            pose.putJointData(jointName, ((TransformSheet)this.jointTransforms.get(jointName)).getInterpolatedTransform(time));
        }
        return pose;
    }

    @Override
    public StaticAnimation bindFull(Armature armature) {
        if (this.animationDataPath != null) {
            AnimationDataExtractor.extractAnimation(new ResourceLocation("epicfight", this.animationDataPath), this, armature);
            this.animationDataPath = null;
            AnimationDataExtractor.extractAnimation(new ResourceLocation("epicfight", this.lookUp.animationDataPath), this.lookUp, armature);
            this.lookUp.animationDataPath = null;
            AnimationDataExtractor.extractAnimation(new ResourceLocation("epicfight", this.lookDown.animationDataPath), this.lookDown, armature);
            this.lookDown.animationDataPath = null;
        }
        return this;
    }
}

