/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities.entity;

import java.util.ArrayList;
import java.util.List;
import maninthehouse.epicfight.animation.Animator;
import maninthehouse.epicfight.animation.AnimatorServer;
import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.capabilities.ModCapabilities;
import maninthehouse.epicfight.capabilities.entity.CapabilityEntity;
import maninthehouse.epicfight.capabilities.entity.DataKeys;
import maninthehouse.epicfight.capabilities.item.CapabilityItem;
import maninthehouse.epicfight.client.animation.AnimatorClient;
import maninthehouse.epicfight.entity.ai.attribute.ModAttributes;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.gamedata.Colliders;
import maninthehouse.epicfight.gamedata.Models;
import maninthehouse.epicfight.gamedata.Sounds;
import maninthehouse.epicfight.main.EpicFightMod;
import maninthehouse.epicfight.model.Model;
import maninthehouse.epicfight.network.ModNetworkManager;
import maninthehouse.epicfight.network.server.STCPlayAnimation;
import maninthehouse.epicfight.physics.Collider;
import maninthehouse.epicfight.utils.game.IExtendedDamageSource;
import maninthehouse.epicfight.utils.math.MathUtils;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class LivingData<T extends EntityLivingBase>
extends CapabilityEntity<T> {
    private float stunTimeReduction;
    protected boolean inaction = false;
    public LivingMotion currentMotion = LivingMotion.IDLE;
    public LivingMotion currentMixMotion = LivingMotion.NONE;
    protected Animator animator;
    public List<Entity> currentlyAttackedEntity;
    private float widthResetSize;
    private float heightResetSize;
    private boolean shouldReset;

    @Override
    public void onEntityConstructed(T entityIn) {
        super.onEntityConstructed(entityIn);
        if (((EntityLivingBase)this.orgEntity).field_70170_p.field_72995_K) {
            this.animator = new AnimatorClient(this);
            this.initAnimator(this.getClientAnimator());
        } else {
            this.animator = new AnimatorServer(this);
        }
        this.registerAttributes();
        this.inaction = false;
        this.currentlyAttackedEntity = new ArrayList<Entity>();
    }

    @Override
    public void onEntityJoinWorld(T entityIn) {
        this.initAttributes();
    }

    protected abstract void initAnimator(AnimatorClient var1);

    public abstract void updateMotion();

    public abstract <M extends Model> M getEntityModel(Models<M> var1);

    protected void registerAttributes() {
        this.registerIfAbsent(ModAttributes.WEIGHT);
        this.registerIfAbsent(ModAttributes.MAX_STRIKES);
        this.registerIfAbsent(ModAttributes.ARMOR_NEGATION);
        this.registerIfAbsent(ModAttributes.IMPACT);
    }

    protected void registerIfAbsent(IAttribute attribute) {
        AbstractAttributeMap attributeMap = ((EntityLivingBase)this.orgEntity).func_110140_aT();
        if (attributeMap.func_111151_a(attribute) == null) {
            attributeMap.func_111150_b(attribute);
        }
    }

    protected void initAttributes() {
        ((EntityLivingBase)this.orgEntity).func_110148_a(ModAttributes.WEIGHT).func_111128_a(this.getAttribute(SharedMonsterAttributes.field_111267_a).func_111125_b() * 2.0);
        ((EntityLivingBase)this.orgEntity).func_110148_a(ModAttributes.MAX_STRIKES).func_111128_a(1.0);
        ((EntityLivingBase)this.orgEntity).func_110148_a(ModAttributes.ARMOR_NEGATION).func_111128_a(0.0);
        ((EntityLivingBase)this.orgEntity).func_110148_a(ModAttributes.IMPACT).func_111128_a(0.5);
    }

    @Override
    protected void updateOnClient() {
        AnimatorClient animator = this.getClientAnimator();
        if (this.inaction) {
            this.currentMotion = LivingMotion.IDLE;
        } else {
            this.updateMotion();
            if (!animator.compareMotion(this.currentMotion)) {
                animator.playLoopMotion();
            }
            if (!animator.compareMixMotion(this.currentMixMotion)) {
                animator.playMixLoopMotion();
            }
        }
    }

    @Override
    protected void updateOnServer() {
        if (this.stunTimeReduction > 0.0f) {
            this.stunTimeReduction = Math.max(0.0f, this.stunTimeReduction - 0.05f);
        }
    }

    @Override
    public void update() {
        this.updateInactionState();
        if (this.isRemote()) {
            this.updateOnClient();
        } else {
            this.updateOnServer();
        }
        this.animator.update();
        if (((EntityLivingBase)this.orgEntity).field_70725_aQ == 19) {
            this.aboutToDeath();
        }
    }

    public void updateInactionState() {
        EntityState state = this.getEntityState();
        this.inaction = state.isCameraRotationLocked() || state.isMovementLocked();
    }

    protected final void commonBipedCreatureAnimatorInit(AnimatorClient animatorClient) {
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.BIPED_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.BIPED_WALK);
        animatorClient.addLivingAnimation(LivingMotion.FALL, Animations.BIPED_FALL);
        animatorClient.addLivingAnimation(LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.BIPED_DEATH);
    }

    protected final void commonCreatureUpdateMotion() {
        this.currentMotion = ((EntityLivingBase)this.orgEntity).func_110143_aJ() <= 0.0f ? LivingMotion.DEATH : (((EntityLivingBase)this.orgEntity).func_184187_bx() != null ? LivingMotion.MOUNT : (((EntityLivingBase)this.orgEntity).field_70181_x < (double)-0.55f ? LivingMotion.FALL : (((EntityLivingBase)this.orgEntity).field_70721_aZ > 0.01f ? LivingMotion.WALKING : LivingMotion.IDLE)));
    }

    public void cancelUsingItem() {
        ((EntityLivingBase)this.orgEntity).func_184602_cy();
        ForgeEventFactory.onUseItemStop((EntityLivingBase)((EntityLivingBase)this.orgEntity), (ItemStack)((EntityLivingBase)this.orgEntity).func_184607_cu(), (int)((EntityLivingBase)this.orgEntity).func_184605_cv());
    }

    public CapabilityItem getHeldItemCapability(EnumHand hand) {
        return ModCapabilities.stackCapabilityGetter(((EntityLivingBase)this.orgEntity).func_184586_b(hand));
    }

    public boolean isInaction() {
        return this.inaction;
    }

    public boolean attackEntityFrom(DamageSource damageSource, float amount) {
        return !this.getEntityState().isInvincible() || !(damageSource instanceof EntityDamageSource) || damageSource.func_94541_c() || damageSource.func_82725_o();
    }

    public IExtendedDamageSource getDamageSource(IExtendedDamageSource.StunType stunType, IExtendedDamageSource.DamageType damageType, int animationId) {
        return IExtendedDamageSource.causeMobDamage((EntityLivingBase)this.orgEntity, stunType, damageType, animationId);
    }

    public float getDamageToEntity(Entity targetEntity, EnumHand hand) {
        float damage = 0.0f;
        damage = hand == EnumHand.MAIN_HAND ? (float)this.getAttributeValue(SharedMonsterAttributes.field_111264_e) : (float)this.getAttributeValue(ModAttributes.OFFHAND_ATTACK_DAMAGE);
        float bonus = targetEntity instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a((ItemStack)((EntityLivingBase)this.orgEntity).func_184586_b(hand), (EnumCreatureAttribute)((EntityLivingBase)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)((EntityLivingBase)this.orgEntity).func_184586_b(hand), (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
        return damage + bonus;
    }

    public boolean hurtEntity(Entity hitTarget, EnumHand handIn, IExtendedDamageSource source, float amount) {
        boolean succed = hitTarget.func_70097_a((DamageSource)source, amount);
        if (succed) {
            int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)((EntityLivingBase)this.orgEntity).func_184586_b(handIn));
            if (hitTarget instanceof EntityLivingBase && j > 0 && !hitTarget.func_70027_ad()) {
                hitTarget.func_70015_d(j * 4);
            }
        }
        return succed;
    }

    public void lookAttacker(Entity attacker) {
        Vec3d vector3d = ((EntityLivingBase)this.orgEntity).func_174791_d();
        Vec3d target = attacker.func_174791_d();
        double d0 = target.field_72450_a - vector3d.field_72450_a;
        double d1 = target.field_72448_b - vector3d.field_72448_b;
        double d2 = target.field_72449_c - vector3d.field_72449_c;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        ((EntityLivingBase)this.orgEntity).field_70125_A = MathHelper.func_76142_g((float)((float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875))));
        ((EntityLivingBase)this.orgEntity).field_70177_z = MathHelper.func_76142_g((float)((float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
        ((EntityLivingBase)this.orgEntity).func_70034_d(((EntityLivingBase)this.orgEntity).field_70177_z);
        ((EntityLivingBase)this.orgEntity).field_70127_C = ((EntityLivingBase)this.orgEntity).field_70125_A;
        ((EntityLivingBase)this.orgEntity).field_70126_B = ((EntityLivingBase)this.orgEntity).field_70177_z;
        ((EntityLivingBase)this.orgEntity).field_70758_at = ((EntityLivingBase)this.orgEntity).field_70759_as;
        ((EntityLivingBase)this.orgEntity).field_70760_ar = ((EntityLivingBase)this.orgEntity).field_70761_aq = ((EntityLivingBase)this.orgEntity).field_70759_as;
    }

    public void gatherDamageDealt(IExtendedDamageSource source, float amount) {
    }

    public void setStunTimeReduction() {
        this.stunTimeReduction += (1.0f - this.stunTimeReduction) * 0.8f;
    }

    public float getStunTimeTimeReduction() {
        return this.stunTimeReduction;
    }

    public void knockBackEntity(Entity entityIn, float power) {
        double d1 = entityIn.field_70165_t - ((EntityLivingBase)this.orgEntity).field_70165_t;
        double d0 = entityIn.field_70161_v - ((EntityLivingBase)this.orgEntity).field_70161_v;
        while (d1 * d1 + d0 * d0 < 1.0E-4) {
            d1 = (Math.random() - Math.random()) * 0.01;
            d0 = (Math.random() - Math.random()) * 0.01;
        }
        if (((EntityLivingBase)this.orgEntity).func_70681_au().nextDouble() >= this.getAttributeValue(SharedMonsterAttributes.field_111266_c)) {
            ((EntityLivingBase)this.orgEntity).field_70160_al = true;
            float f = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0));
            double x = ((EntityLivingBase)this.orgEntity).field_70159_w;
            double y = ((EntityLivingBase)this.orgEntity).field_70181_x;
            double z = ((EntityLivingBase)this.orgEntity).field_70179_y;
            x /= 2.0;
            z /= 2.0;
            x -= d1 / (double)f * (double)power;
            z -= d0 / (double)f * (double)power;
            if (!((EntityLivingBase)this.orgEntity).field_70122_E) {
                y /= 2.0;
                if ((y += (double)power) > (double)0.4f) {
                    y = 0.4f;
                }
            }
            ((EntityLivingBase)this.orgEntity).field_70159_w = x;
            ((EntityLivingBase)this.orgEntity).field_70181_x = y;
            ((EntityLivingBase)this.orgEntity).field_70179_y = z;
        }
    }

    public float getMaxStunArmor() {
        IAttributeInstance stun_resistance = ((EntityLivingBase)this.orgEntity).func_110148_a(ModAttributes.MAX_STUN_ARMOR);
        return (float)(stun_resistance == null ? 0.0 : stun_resistance.func_111126_e());
    }

    public float getStunArmor() {
        return this.getMaxStunArmor() == 0.0f ? 0.0f : ((Float)((EntityLivingBase)this.orgEntity).func_184212_Q().func_187225_a(DataKeys.STUN_ARMOR)).floatValue();
    }

    public void setStunArmor(float value) {
        float f1 = Math.max(Math.min(value, this.getMaxStunArmor()), 0.0f);
        ((EntityLivingBase)this.orgEntity).func_184212_Q().func_187227_b(DataKeys.STUN_ARMOR, (Object)Float.valueOf(f1));
    }

    public double getWeight() {
        return this.getAttributeValue(ModAttributes.WEIGHT);
    }

    public IAttributeInstance getAttribute(IAttribute attribute) {
        return ((EntityLivingBase)this.orgEntity).func_110140_aT().func_111151_a(attribute);
    }

    public double getAttributeValue(IAttribute attribute) {
        return ((EntityLivingBase)this.orgEntity).func_110140_aT().func_111151_a(attribute).func_111126_e();
    }

    public float getAttackDirectionPitch() {
        float partialTicks = EpicFightMod.isPhysicalClient() ? Minecraft.func_71410_x().func_184121_ak() : 1.0f;
        float pitch = -MathUtils.interpolateRotation(((EntityLivingBase)this.orgEntity).field_70127_C, ((EntityLivingBase)this.orgEntity).field_70125_A, partialTicks);
        float correct = pitch > 0.0f ? 0.03333f * (float)Math.pow(pitch, 2.0) : -0.03333f * (float)Math.pow(pitch, 2.0);
        return MathHelper.func_76131_a((float)correct, (float)-30.0f, (float)30.0f);
    }

    public void rotateTo(float degree, float limit, boolean partialSync) {
        float amount;
        T entity = this.getOriginalEntity();
        for (amount = MathHelper.func_76142_g((float)(degree - ((EntityLivingBase)entity).field_70177_z)); amount < -180.0f; amount += 360.0f) {
        }
        while (amount > 180.0f) {
            amount -= 360.0f;
        }
        if (amount > limit) {
            amount = limit;
        }
        if (amount < -limit) {
            amount = -limit;
        }
        float f1 = ((EntityLivingBase)entity).field_70177_z + amount;
        if (partialSync) {
            ((EntityLivingBase)entity).field_70126_B = f1;
            ((EntityLivingBase)entity).field_70758_at = f1;
            ((EntityLivingBase)entity).field_70760_ar = f1;
        }
        ((EntityLivingBase)entity).field_70177_z = f1;
        ((EntityLivingBase)entity).field_70759_as = f1;
        ((EntityLivingBase)entity).field_70761_aq = f1;
    }

    public void rotateTo(Entity target, float limit, boolean partialSync) {
        double d0 = target.field_70165_t - ((EntityLivingBase)this.orgEntity).field_70165_t;
        double d1 = target.field_70161_v - ((EntityLivingBase)this.orgEntity).field_70161_v;
        float degree = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.29577951308232) - 90.0f;
        this.rotateTo(degree, limit, partialSync);
    }

    public void playSound(SoundEvent sound, float minPitch, float maxPitch) {
        float randPitch = ((EntityLivingBase)this.orgEntity).func_70681_au().nextFloat() * 2.0f - 1.0f;
        randPitch = Math.min(Math.max(randPitch, minPitch), maxPitch);
        if (!this.isRemote()) {
            ((EntityLivingBase)this.orgEntity).field_70170_p.func_184148_a(null, ((EntityLivingBase)this.orgEntity).field_70165_t, ((EntityLivingBase)this.orgEntity).field_70163_u, ((EntityLivingBase)this.orgEntity).field_70161_v, sound, ((EntityLivingBase)this.orgEntity).func_184176_by(), 1.0f, 1.0f + randPitch);
        } else {
            ((EntityLivingBase)this.orgEntity).field_70170_p.func_184134_a(((EntityLivingBase)this.orgEntity).field_70165_t, ((EntityLivingBase)this.orgEntity).field_70163_u, ((EntityLivingBase)this.orgEntity).field_70161_v, sound, ((EntityLivingBase)this.orgEntity).func_184176_by(), 1.0f, 1.0f + randPitch, false);
        }
    }

    public EntityLivingBase getAttackTarget() {
        return ((EntityLivingBase)this.orgEntity).func_110144_aD();
    }

    public float getPitch(float partialTicks) {
        return (float)MathUtils.lerp(partialTicks, ((EntityLivingBase)this.orgEntity).field_70127_C, ((EntityLivingBase)this.orgEntity).field_70125_A);
    }

    public VisibleMatrix4f getHeadMatrix(float partialTicks) {
        float f2;
        if (this.inaction) {
            f2 = 0.0f;
        } else {
            float f = MathUtils.interpolateRotation(((EntityLivingBase)this.orgEntity).field_70760_ar, ((EntityLivingBase)this.orgEntity).field_70761_aq, partialTicks);
            float f1 = MathUtils.interpolateRotation(((EntityLivingBase)this.orgEntity).field_70758_at, ((EntityLivingBase)this.orgEntity).field_70759_as, partialTicks);
            f2 = f1 - f;
            if (((EntityLivingBase)this.orgEntity).func_184187_bx() != null) {
                if (f2 > 45.0f) {
                    f2 = 45.0f;
                } else if (f2 < -45.0f) {
                    f2 = -45.0f;
                }
            }
        }
        return MathUtils.getModelMatrixIntegrated(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, ((EntityLivingBase)this.orgEntity).field_70127_C, ((EntityLivingBase)this.orgEntity).field_70125_A, f2, f2, partialTicks, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public VisibleMatrix4f getModelMatrix(float partialTicks) {
        float rotyaw;
        float prevRotYaw;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        float scaleZ = 1.0f;
        if (((EntityLivingBase)this.orgEntity).func_184187_bx() instanceof EntityLivingBase) {
            EntityLivingBase ridingEntity = (EntityLivingBase)((EntityLivingBase)this.orgEntity).func_184187_bx();
            prevRotYaw = ridingEntity.field_70760_ar;
            rotyaw = ridingEntity.field_70761_aq;
        } else {
            prevRotYaw = this.inaction ? ((EntityLivingBase)this.orgEntity).field_70177_z : ((EntityLivingBase)this.orgEntity).field_70760_ar;
            float f = rotyaw = this.inaction ? ((EntityLivingBase)this.orgEntity).field_70177_z : ((EntityLivingBase)this.orgEntity).field_70761_aq;
        }
        if (((EntityLivingBase)this.orgEntity).func_70631_g_()) {
            scaleX *= 0.5f;
            scaleY *= 0.5f;
            scaleZ *= 0.5f;
        }
        return MathUtils.getModelMatrixIntegrated((float)((EntityLivingBase)this.orgEntity).field_70142_S, (float)((EntityLivingBase)this.orgEntity).field_70165_t, (float)((EntityLivingBase)this.orgEntity).field_70137_T, (float)((EntityLivingBase)this.orgEntity).field_70163_u, (float)((EntityLivingBase)this.orgEntity).field_70136_U, (float)((EntityLivingBase)this.orgEntity).field_70161_v, 0.0f, 0.0f, prevRotYaw, rotyaw, partialTicks, scaleX, scaleY, scaleZ);
    }

    public void resetLivingMixLoop() {
        this.currentMixMotion = LivingMotion.NONE;
        this.getClientAnimator().resetMixMotion();
    }

    public void playAnimationSynchronize(int id, float modifyTime) {
        this.animator.playAnimation(id, modifyTime);
        ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimation(id, ((EntityLivingBase)this.orgEntity).func_145782_y(), modifyTime), this.orgEntity);
    }

    public void playAnimationSynchronize(StaticAnimation animation, float modifyTime) {
        this.playAnimationSynchronize(animation.getId(), modifyTime);
    }

    public void notifyToReset(float width, float height) {
        this.widthResetSize = width;
        this.heightResetSize = height;
        this.shouldReset = true;
    }

    public void resetSize() {
        if (this.shouldReset) {
            float f = ((EntityLivingBase)this.orgEntity).field_70130_N;
            ((EntityLivingBase)this.orgEntity).field_70130_N = this.widthResetSize;
            ((EntityLivingBase)this.orgEntity).field_70131_O = this.heightResetSize;
            if (((EntityLivingBase)this.orgEntity).field_70130_N < f) {
                double d0 = (double)this.widthResetSize * 0.5;
                ((EntityLivingBase)this.orgEntity).func_174826_a(new AxisAlignedBB(((EntityLivingBase)this.orgEntity).field_70165_t - d0, ((EntityLivingBase)this.orgEntity).field_70163_u, ((EntityLivingBase)this.orgEntity).field_70161_v - d0, ((EntityLivingBase)this.orgEntity).field_70165_t + d0, ((EntityLivingBase)this.orgEntity).field_70163_u + (double)((EntityLivingBase)this.orgEntity).field_70131_O, ((EntityLivingBase)this.orgEntity).field_70161_v + d0));
                return;
            }
            AxisAlignedBB axisalignedbb = ((EntityLivingBase)this.orgEntity).func_174813_aQ();
            ((EntityLivingBase)this.orgEntity).func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)((EntityLivingBase)this.orgEntity).field_70130_N, axisalignedbb.field_72338_b + (double)((EntityLivingBase)this.orgEntity).field_70131_O, axisalignedbb.field_72339_c + (double)((EntityLivingBase)this.orgEntity).field_70130_N));
            if (((EntityLivingBase)this.orgEntity).field_70130_N > f && !((EntityLivingBase)this.orgEntity).field_70170_p.field_72995_K) {
                ((EntityLivingBase)this.orgEntity).func_70091_d(MoverType.SELF, (double)(f - ((EntityLivingBase)this.orgEntity).field_70130_N), 0.0, (double)(f - ((EntityLivingBase)this.orgEntity).field_70130_N));
            }
            this.shouldReset = false;
        }
    }

    public void onArmorSlotChanged(CapabilityItem fromCap, CapabilityItem toCap, EntityEquipmentSlot slotType) {
    }

    public <A extends Animator> A getAnimator() {
        return (A)this.animator;
    }

    public AnimatorClient getClientAnimator() {
        return (AnimatorClient)this.getAnimator();
    }

    public AnimatorServer getServerAnimator() {
        return (AnimatorServer)this.getAnimator();
    }

    public abstract StaticAnimation getHitAnimation(IExtendedDamageSource.StunType var1);

    @Override
    public void aboutToDeath() {
        this.animator.onEntityDeath();
    }

    @Override
    public T getOriginalEntity() {
        return (T)((EntityLivingBase)this.orgEntity);
    }

    public SoundEvent getWeaponHitSound(EnumHand hand) {
        CapabilityItem cap = this.getHeldItemCapability(hand);
        if (cap != null) {
            return cap.getHitSound();
        }
        return Sounds.BLUNT_HIT;
    }

    public SoundEvent getSwingSound(EnumHand hand) {
        CapabilityItem cap = this.getHeldItemCapability(hand);
        if (cap != null) {
            return cap.getSmashingSound();
        }
        return Sounds.WHOOSH;
    }

    public Collider getColliderMatching(EnumHand hand) {
        CapabilityItem itemCap = this.getHeldItemCapability(hand);
        return itemCap != null ? itemCap.getWeaponCollider() : Colliders.fist;
    }

    public int getHitEnemies() {
        return (int)this.getAttributeValue(ModAttributes.MAX_STRIKES);
    }

    public float getDefenceIgnore() {
        return (float)this.getAttributeValue(ModAttributes.ARMOR_NEGATION);
    }

    public float getImpact() {
        return (float)this.getAttributeValue(ModAttributes.IMPACT);
    }

    public boolean isTeam(Entity entityIn) {
        if (((EntityLivingBase)this.orgEntity).func_184187_bx() != null && ((EntityLivingBase)this.orgEntity).func_184187_bx().equals((Object)entityIn)) {
            return true;
        }
        if (this.isMountedTeam(entityIn)) {
            return true;
        }
        return ((EntityLivingBase)this.orgEntity).func_184191_r(entityIn);
    }

    private boolean isMountedTeam(Entity entityIn) {
        T orgEntity = this.getOriginalEntity();
        for (Entity passanger : orgEntity.func_184188_bt()) {
            if (!passanger.equals((Object)entityIn)) continue;
            return true;
        }
        for (Entity passanger : entityIn.func_184188_bt()) {
            if (!passanger.equals(orgEntity)) continue;
            return true;
        }
        return false;
    }

    public boolean isFirstPerson() {
        return false;
    }

    public EntityState getEntityState() {
        return this.animator.getPlayer().getPlay().getState(this.animator.getPlayer().getElapsedTime());
    }

    public static enum EntityState {
        FREE(false, false, false, false, true, 0),
        FREE_CAMERA(false, true, false, false, false, 1),
        FREE_INPUT(false, false, false, false, true, 3),
        PRE_DELAY(true, true, false, false, false, 1),
        CONTACT(true, true, true, false, false, 2),
        ROTATABLE_CONTACT(false, true, true, false, false, 2),
        POST_DELAY(true, true, false, false, true, 3),
        ROTATABLE_POST_DELAY(false, true, false, false, true, 3),
        HIT(true, true, false, false, false, 3),
        DODGE(true, true, false, true, false, 3);

        boolean cameraLock;
        boolean movementLock;
        boolean collideDetection;
        boolean invincible;
        boolean canAct;
        int level;

        private EntityState(boolean cameraLock, boolean movementLock, boolean collideDetection, boolean invincible, boolean canAct, int level) {
            this.cameraLock = cameraLock;
            this.movementLock = movementLock;
            this.collideDetection = collideDetection;
            this.invincible = invincible;
            this.canAct = canAct;
            this.level = level;
        }

        public boolean isCameraRotationLocked() {
            return this.cameraLock;
        }

        public boolean isMovementLocked() {
            return this.movementLock;
        }

        public boolean shouldDetectCollision() {
            return this.collideDetection;
        }

        public boolean isInvincible() {
            return this.invincible;
        }

        public boolean canAct() {
            return this.canAct;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

