/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities.entity;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import maninthehouse.epicfight.capabilities.ModCapabilities;
import maninthehouse.epicfight.capabilities.entity.CapabilityEntity;
import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.capabilities.entity.mob.Faction;
import maninthehouse.epicfight.entity.ai.EntityAIArcher;
import maninthehouse.epicfight.entity.ai.EntityAIAttackPattern;
import maninthehouse.epicfight.entity.ai.EntityAIChase;
import maninthehouse.epicfight.main.EpicFightMod;
import maninthehouse.epicfight.network.server.STCMobInitialSetting;
import maninthehouse.epicfight.utils.math.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public abstract class MobData<T extends EntityCreature>
extends LivingData<T> {
    protected final Faction mobFaction;

    public MobData() {
        this(Faction.NATURAL);
    }

    public MobData(Faction faction) {
        this.mobFaction = faction;
    }

    @Override
    public void onEntityJoinWorld(T entityIn) {
        super.onEntityJoinWorld(entityIn);
        this.initAI();
    }

    protected void initAI() {
        this.resetCombatAI();
    }

    protected void resetCombatAI() {
        Iterator iterator = ((EntityCreature)this.orgEntity).field_70714_bg.field_75782_a.iterator();
        ArrayList<EntityAIBase> removeTasks = new ArrayList<EntityAIBase>();
        while (iterator.hasNext()) {
            EntityAITasks.EntityAITaskEntry entityaitasks$entityaitaskentry = (EntityAITasks.EntityAITaskEntry)iterator.next();
            EntityAIBase entityAI = entityaitasks$entityaitaskentry.field_75733_a;
            if (!(entityAI instanceof EntityAIAttackMelee) && !(entityAI instanceof EntityAIAttackMelee) && !(entityAI instanceof EntityAIAttackRangedBow) && !(entityAI instanceof EntityAIAttackPattern) && !(entityAI instanceof EntityAIArcher) && !(entityAI instanceof EntityAIChase) && !(entityAI instanceof EntityAIAttackRanged)) continue;
            removeTasks.add(entityAI);
        }
        for (EntityAIBase AI : removeTasks) {
            ((EntityCreature)this.orgEntity).field_70714_bg.func_85156_a(AI);
        }
    }

    public STCMobInitialSetting sendInitialInformationToClient() {
        return null;
    }

    public void clientInitialSettings(ByteBuf buf) {
    }

    @Override
    public boolean isTeam(Entity entityIn) {
        CapabilityEntity cap = (CapabilityEntity)entityIn.getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
        if (cap != null && cap instanceof MobData && ((MobData)cap).mobFaction.equals((Object)this.mobFaction)) {
            Optional<EntityLivingBase> opt = Optional.ofNullable(this.getAttackTarget());
            return opt.map(attackTarget -> !attackTarget.func_70028_i(entityIn)).orElse(true);
        }
        return super.isTeam(entityIn);
    }

    @Override
    public EntityLivingBase getAttackTarget() {
        return ((EntityCreature)this.orgEntity).func_70638_az();
    }

    @Override
    public float getAttackDirectionPitch() {
        EntityLivingBase attackTarget = this.getAttackTarget();
        if (attackTarget != null) {
            float partialTicks = EpicFightMod.isPhysicalClient() ? Minecraft.func_71410_x().func_184121_ak() : 1.0f;
            Vec3d target = new Vec3d(MathUtils.lerp(partialTicks, attackTarget.field_70169_q, attackTarget.field_70165_t), MathUtils.lerp(partialTicks, attackTarget.field_70167_r, attackTarget.field_70163_u) + (double)attackTarget.func_70047_e(), MathUtils.lerp(partialTicks, attackTarget.field_70166_s, attackTarget.field_70161_v));
            Vec3d vector3d = new Vec3d(MathUtils.lerp(partialTicks, ((EntityCreature)this.orgEntity).field_70169_q, ((EntityCreature)this.orgEntity).field_70165_t), MathUtils.lerp(partialTicks, ((EntityCreature)this.orgEntity).field_70167_r, ((EntityCreature)this.orgEntity).field_70163_u) + (double)((EntityCreature)this.orgEntity).func_70047_e(), MathUtils.lerp(partialTicks, ((EntityCreature)this.orgEntity).field_70166_s, ((EntityCreature)this.orgEntity).field_70161_v));
            double d0 = target.field_72450_a - vector3d.field_72450_a;
            double d1 = target.field_72448_b - vector3d.field_72448_b;
            double d2 = target.field_72449_c - vector3d.field_72449_c;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            return MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)((float)(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875))), (float)-30.0f, (float)30.0f);
        }
        return super.getAttackDirectionPitch();
    }
}

