/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities.entity.mob;

import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninthehouse.epicfight.capabilities.entity.mob.Faction;
import maninthehouse.epicfight.client.animation.AnimatorClient;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.gamedata.Models;
import maninthehouse.epicfight.model.Model;
import maninthehouse.epicfight.utils.game.IExtendedDamageSource;
import net.minecraft.entity.monster.AbstractIllager;

public abstract class AbstractIllagerData<T extends AbstractIllager>
extends BipedMobData<T> {
    public AbstractIllagerData(Faction faction) {
        super(faction);
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        super.initAnimator(animatorClient);
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.ILLAGER_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.ILLAGER_WALK);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.BIPED_DEATH);
    }

    @Override
    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        if (stunType == IExtendedDamageSource.StunType.LONG) {
            return Animations.BIPED_HIT_LONG;
        }
        return Animations.BIPED_HIT_SHORT;
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_ILLAGER;
    }
}

