/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities.entity.mob;

import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.animation.types.attack.AttackAnimation;
import maninthehouse.epicfight.capabilities.entity.DataKeys;
import maninthehouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninthehouse.epicfight.capabilities.entity.mob.Faction;
import maninthehouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninthehouse.epicfight.client.animation.AnimatorClient;
import maninthehouse.epicfight.effects.ModEffects;
import maninthehouse.epicfight.entity.ai.EntityAIAttackPattern;
import maninthehouse.epicfight.entity.ai.EntityAIChase;
import maninthehouse.epicfight.entity.ai.EntityAIPatternWithChance;
import maninthehouse.epicfight.entity.ai.attribute.ModAttributes;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.gamedata.Models;
import maninthehouse.epicfight.model.Model;
import maninthehouse.epicfight.network.ModNetworkManager;
import maninthehouse.epicfight.network.server.STCPlayAnimationTP;
import maninthehouse.epicfight.network.server.STCPlayAnimationTarget;
import maninthehouse.epicfight.utils.game.IExtendedDamageSource;
import maninthehouse.epicfight.utils.math.Vec3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;

public class EndermanData
extends BipedMobData<EntityEnderman> {
    private int deathTimerExt = 0;
    private int teleportCooled = 0;
    private boolean onRage;
    private EntityAIBase normalAttack1;
    private EntityAIBase normalAttack2;
    private EntityAIBase normalAttack3;
    private EntityAIBase normalAttack4;
    private EntityAIBase normalAttack5;
    private EntityAIBase rageTarget;
    private EntityAIBase rageChase;

    public EndermanData() {
        super(Faction.ENDERLAND);
    }

    @Override
    public void onEntityJoinWorld(EntityEnderman entityIn) {
        super.onEntityJoinWorld(entityIn);
        ((EntityEnderman)this.orgEntity).func_184212_Q().func_187214_a(DataKeys.STUN_ARMOR, (Object)Float.valueOf(6.0f));
    }

    @Override
    protected void registerAttributes() {
        super.registerAttributes();
        this.registerIfAbsent(ModAttributes.MAX_STUN_ARMOR);
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((EntityEnderman)this.orgEntity).func_110148_a(ModAttributes.MAX_STUN_ARMOR).func_111128_a(6.0);
    }

    @Override
    public void postInit() {
        super.postInit();
        if (this.isRemote()) {
            if (this.isRaging()) {
                this.getClientAnimator().addLivingAnimation(LivingMotion.IDLE, Animations.ENDERMAN_RAGE_IDLE);
                this.getClientAnimator().addLivingAnimation(LivingMotion.WALKING, Animations.ENDERMAN_RAGE_WALK);
                this.onRage = true;
            } else {
                this.getClientAnimator().addLivingAnimation(LivingMotion.IDLE, Animations.ENDERMAN_IDLE);
                this.getClientAnimator().addLivingAnimation(LivingMotion.WALKING, Animations.ENDERMAN_WALK);
                this.onRage = false;
            }
        }
    }

    @Override
    protected void initAI() {
        super.initAI();
        this.normalAttack1 = new EntityAIPatternWithChance(this, (EntityCreature)this.orgEntity, 4.0, 4.5, 0.6f, true, MobAttackPatterns.ENDERMAN_PATTERN2);
        this.normalAttack2 = new EntityAIAttackPattern(this, (EntityCreature)this.orgEntity, 0.0, 3.5, true, MobAttackPatterns.ENDERMAN_PATTERN1);
        this.normalAttack3 = new AIEndermanTeleportKick(this, (EntityMob)this.orgEntity);
        this.normalAttack1 = new EntityAIPatternWithChance(this, (EntityCreature)this.orgEntity, 0.0, 1.23, 0.4f, true, MobAttackPatterns.ENDERMAN_PATTERN1);
        this.normalAttack2 = new EntityAIPatternWithChance(this, (EntityCreature)this.orgEntity, 0.0, 1.9, 0.4f, true, MobAttackPatterns.ENDERMAN_PATTERN2);
        this.normalAttack3 = new EntityAIPatternWithChance(this, (EntityCreature)this.orgEntity, 3.0, 4.0, 0.1f, true, MobAttackPatterns.ENDERMAN_PATTERN3);
        this.normalAttack4 = new EntityAIPatternWithChance(this, (EntityCreature)this.orgEntity, 0.0, 2.0, 0.2f, true, MobAttackPatterns.ENDERMAN_PATTERN4);
        this.normalAttack5 = new AIEndermanTeleportKick(this, (EntityMob)this.orgEntity);
        this.rageTarget = new EntityAINearestAttackableTarget((EntityCreature)this.orgEntity, EntityPlayer.class, true);
        this.rageChase = new AIEndermanRush(this, (EntityMob)this.orgEntity);
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        super.initAnimator(animatorClient);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.ENDERMAN_DEATH);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.ENDERMAN_WALK);
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.ENDERMAN_IDLE);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
    }

    @Override
    public void update() {
        if (((EntityEnderman)this.orgEntity).func_110143_aJ() <= 0.0f) {
            ((EntityEnderman)this.orgEntity).field_70125_A = 0.0f;
            if (((EntityEnderman)this.orgEntity).field_70725_aQ > 1 && this.deathTimerExt < 20) {
                ++this.deathTimerExt;
                --((EntityEnderman)this.orgEntity).field_70725_aQ;
            }
        }
        if (this.isRaging() && !this.onRage && ((EntityEnderman)this.orgEntity).field_70173_aa > 5) {
            this.convertRage();
        } else if (this.onRage && !this.isRaging()) {
            this.convertNormal();
        }
        if (this.teleportCooled > 0) {
            --this.teleportCooled;
        }
        super.update();
    }

    @Override
    public boolean attackEntityFrom(DamageSource damageSource, float amount) {
        if (damageSource instanceof EntityDamageSource && !this.isRaging()) {
            IExtendedDamageSource extDamageSource = null;
            if (damageSource instanceof IExtendedDamageSource) {
                extDamageSource = (IExtendedDamageSource)damageSource;
            }
            if (extDamageSource == null || extDamageSource.getStunType() != IExtendedDamageSource.StunType.HOLD) {
                int percentage;
                int n = percentage = this.animator.getPlayer().getPlay() instanceof AttackAnimation ? 10 : 3;
                if (((EntityEnderman)this.orgEntity).func_70681_au().nextInt(percentage) == 0) {
                    for (int i = 0; i < 9; ++i) {
                        if (!this.teleportRandomly()) continue;
                        if (damageSource.func_76346_g() instanceof EntityLivingBase) {
                            ((EntityEnderman)this.orgEntity).func_70604_c((EntityLivingBase)damageSource.func_76346_g());
                        }
                        if (this.inaction) {
                            this.playAnimationSynchronize(Animations.ENDERMAN_TP_EMERGENCE, 0.0f);
                        }
                        return false;
                    }
                }
            }
        }
        return super.attackEntityFrom(damageSource, amount);
    }

    protected boolean teleportRandomly() {
        if (!this.isRemote() && ((EntityEnderman)this.orgEntity).func_70089_S()) {
            double d0 = ((EntityEnderman)this.orgEntity).field_70165_t + (((EntityEnderman)this.orgEntity).func_70681_au().nextDouble() - 0.5) * 64.0;
            double d1 = ((EntityEnderman)this.orgEntity).field_70163_u + (double)(((EntityEnderman)this.orgEntity).func_70681_au().nextInt(64) - 32);
            double d2 = ((EntityEnderman)this.orgEntity).field_70161_v + (((EntityEnderman)this.orgEntity).func_70681_au().nextDouble() - 0.5) * 64.0;
            return this.teleportTo(d0, d1, d2);
        }
        return false;
    }

    private boolean teleportTo(double x, double y, double z) {
        boolean flag = ((EntityEnderman)this.orgEntity).func_184595_k(x, y, z);
        if (flag) {
            ((EntityEnderman)this.orgEntity).field_70170_p.func_184148_a((EntityPlayer)null, ((EntityEnderman)this.orgEntity).field_70169_q, ((EntityEnderman)this.orgEntity).field_70167_r, ((EntityEnderman)this.orgEntity).field_70166_s, SoundEvents.field_187534_aX, ((EntityEnderman)this.orgEntity).func_184176_by(), 1.0f, 1.0f);
            ((EntityEnderman)this.orgEntity).func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    public boolean isRaging() {
        return ((EntityEnderman)this.orgEntity).func_110143_aJ() / ((EntityEnderman)this.orgEntity).func_110138_aP() < 0.33f;
    }

    protected void convertRage() {
        this.onRage = true;
        this.animator.playAnimation(Animations.ENDERMAN_HIT_RAGE, 0.0f);
        if (this.isRemote()) {
            this.getClientAnimator().addLivingAnimation(LivingMotion.IDLE, Animations.ENDERMAN_RAGE_IDLE);
            this.getClientAnimator().addLivingAnimation(LivingMotion.WALKING, Animations.ENDERMAN_RAGE_WALK);
        } else if (!((EntityEnderman)this.orgEntity).func_175446_cd()) {
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_85156_a(this.normalAttack1);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_85156_a(this.normalAttack2);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_85156_a(this.normalAttack3);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_85156_a(this.normalAttack4);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_85156_a(this.normalAttack5);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(1, this.rageChase);
            ((EntityEnderman)this.orgEntity).field_70715_bh.func_75776_a(3, this.rageTarget);
            ((EntityEnderman)this.orgEntity).func_184212_Q().func_187227_b(EntityEnderman.field_184719_bw, (Object)true);
            ((EntityEnderman)this.orgEntity).func_70690_d(new PotionEffect(ModEffects.STUN_IMMUNITY, 120000));
        }
    }

    protected void convertNormal() {
        this.onRage = false;
        if (this.isRemote()) {
            this.getClientAnimator().addLivingAnimation(LivingMotion.IDLE, Animations.ENDERMAN_IDLE);
            this.getClientAnimator().addLivingAnimation(LivingMotion.WALKING, Animations.ENDERMAN_WALK);
        } else if (!((EntityEnderman)this.orgEntity).func_175446_cd()) {
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(1, this.normalAttack1);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(1, this.normalAttack2);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(1, this.normalAttack3);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(1, this.normalAttack4);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(0, this.normalAttack5);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_85156_a(this.rageChase);
            ((EntityEnderman)this.orgEntity).field_70715_bh.func_85156_a(this.rageTarget);
            if (((EntityEnderman)this.orgEntity).func_70638_az() == null) {
                ((EntityEnderman)this.orgEntity).func_184212_Q().func_187227_b(EntityEnderman.field_184719_bw, (Object)false);
            }
            ((EntityEnderman)this.orgEntity).func_184589_d(ModEffects.STUN_IMMUNITY);
        }
    }

    @Override
    public void setAIAsUnarmed() {
        if (this.isRaging()) {
            ((EntityEnderman)this.orgEntity).field_70715_bh.func_75776_a(3, this.rageTarget);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(1, this.rageChase);
        } else {
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(1, this.normalAttack1);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(1, this.normalAttack2);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(1, this.normalAttack3);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(1, this.normalAttack4);
            ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(0, this.normalAttack5);
        }
        ((EntityEnderman)this.orgEntity).field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIChase(this, (EntityCreature)this.orgEntity, 0.75, false));
    }

    @Override
    public void setAIAsArmed() {
        this.setAIAsUnarmed();
    }

    @Override
    public void setAIAsMounted(Entity ridingEntity) {
    }

    @Override
    public void aboutToDeath() {
        ((EntityEnderman)this.orgEntity).func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        super.aboutToDeath();
    }

    @Override
    public StaticAnimation getHitAnimation(IExtendedDamageSource.StunType stunType) {
        if (stunType == IExtendedDamageSource.StunType.LONG) {
            return Animations.ENDERMAN_HIT_LONG;
        }
        return Animations.ENDERMAN_HIT_SHORT;
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_ENDERMAN;
    }

    static class AIEndermanRush
    extends EntityAIAttackPattern {
        private float accelator;

        public AIEndermanRush(BipedMobData<?> mobdata, EntityMob attacker) {
            super(mobdata, (EntityCreature)attacker, 0.0, 1.8f, false, null);
        }

        @Override
        public boolean func_75250_a() {
            return this.isValidTarget(this.attacker.func_70638_az()) && !this.mobdata.isInaction();
        }

        @Override
        public boolean func_75253_b() {
            return this.isValidTarget(this.attacker.func_70638_az()) && !this.mobdata.isInaction();
        }

        @Override
        public void func_75249_e() {
            ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimationTarget(403, this.attacker.func_145782_y(), -1.0f, true, this.attacker.func_70638_az().func_145782_y()), (Entity)this.attacker);
            this.accelator = 0.0f;
        }

        @Override
        public void func_75251_c() {
        }

        @Override
        public void func_75246_d() {
            if (this.isTargetInRange(this.attacker.func_70638_az()) && this.canExecuteAttack()) {
                this.mobdata.getServerAnimator().playAnimation(Animations.ENDERMAN_GRASP, 0.0f);
                ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimationTarget(Animations.ENDERMAN_GRASP.getId(), this.attacker.func_145782_y(), 0.0f, this.attacker.func_70638_az().func_145782_y()), (Entity)this.attacker);
            }
            this.attacker.func_70661_as().func_75489_a((double)(0.025f * this.accelator * this.accelator + 1.0f));
            this.accelator = this.accelator > 2.0f ? this.accelator : this.accelator + 0.05f;
        }
    }

    static class AIEndermanTeleportKick
    extends EntityAIPatternWithChance {
        private int delayCounter;
        private int cooldownTime;

        public AIEndermanTeleportKick(BipedMobData<?> mobdata, EntityMob attacker) {
            super(mobdata, (EntityCreature)attacker, 8.0, 100.0, 0.1f, false, null);
            super.func_75248_a(11);
        }

        @Override
        public boolean func_75250_a() {
            boolean b;
            boolean bl = b = this.cooldownTime <= 0;
            if (!b) {
                --this.cooldownTime;
            }
            return super.func_75250_a() && b;
        }

        @Override
        public boolean func_75253_b() {
            boolean b;
            EntityLivingBase EntityLivingBase2 = this.attacker.func_70638_az();
            boolean bl = b = this.cooldownTime <= 100;
            if (!b) {
                this.cooldownTime = 500;
            }
            return this.isValidTarget(EntityLivingBase2) && this.isTargetInRange(EntityLivingBase2) && b;
        }

        @Override
        public void func_75249_e() {
            this.delayCounter = 35 + this.attacker.func_70681_au().nextInt(10);
            this.cooldownTime = 0;
        }

        @Override
        public void func_75251_c() {
        }

        @Override
        public void func_75246_d() {
            EntityLivingBase target = this.attacker.func_70638_az();
            this.attacker.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            if (this.delayCounter-- < 0 && !this.mobdata.isInaction()) {
                Vec3f vec = new Vec3f((float)(this.attacker.field_70165_t - target.field_70165_t), 0.0f, (float)(this.attacker.field_70161_v - target.field_70161_v));
                vec.normalise();
                vec.scale(1.414f);
                boolean flag = this.attacker.func_184595_k(target.field_70165_t + (double)vec.x, target.field_70163_u, target.field_70161_v + (double)vec.z);
                if (flag) {
                    this.mobdata.rotateTo((Entity)target, 360.0f, true);
                    AttackAnimation kickAnimation = this.attacker.func_70681_au().nextBoolean() ? (AttackAnimation)Animations.ENDERMAN_TP_KICK1 : (AttackAnimation)Animations.ENDERMAN_TP_KICK2;
                    this.mobdata.getServerAnimator().playAnimation(kickAnimation, 0.0f);
                    ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimationTP(kickAnimation.getId(), this.attacker.func_145782_y(), 0.0f, this.attacker.func_70638_az().func_145782_y(), this.attacker.field_70165_t, this.attacker.field_70163_u, this.attacker.field_70161_v, this.attacker.field_70177_z), (Entity)this.attacker);
                    this.attacker.field_70170_p.func_184148_a((EntityPlayer)null, this.attacker.field_70169_q, this.attacker.field_70167_r, this.attacker.field_70166_s, SoundEvents.field_187534_aX, this.attacker.func_184176_by(), 1.0f, 1.0f);
                    this.attacker.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                    this.cooldownTime = 0;
                } else {
                    ++this.cooldownTime;
                }
            }
        }
    }
}

