/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities.entity.mob;

import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.capabilities.entity.DataKeys;
import maninthehouse.epicfight.capabilities.entity.mob.Faction;
import maninthehouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninthehouse.epicfight.capabilities.entity.mob.SkeletonData;
import maninthehouse.epicfight.client.animation.AnimatorClient;
import maninthehouse.epicfight.entity.ai.EntityAIAttackPattern;
import maninthehouse.epicfight.entity.ai.EntityAIChase;
import maninthehouse.epicfight.entity.ai.attribute.ModAttributes;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.gamedata.Models;
import maninthehouse.epicfight.model.Model;
import maninthehouse.epicfight.utils.game.IExtendedDamageSource;
import maninthehouse.epicfight.utils.math.Vec3f;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;

public class WitherSkeletonData
extends SkeletonData<EntityWitherSkeleton> {
    public WitherSkeletonData() {
        super(Faction.WITHER_ARMY);
    }

    @Override
    public void onEntityJoinWorld(EntityWitherSkeleton entityIn) {
        super.onEntityJoinWorld(entityIn);
        ((EntityWitherSkeleton)this.orgEntity).func_184212_Q().func_187227_b(DataKeys.STUN_ARMOR, (Object)Float.valueOf(4.0f));
    }

    @Override
    public void postInit() {
        super.resetCombatAI();
        super.postInit();
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((EntityWitherSkeleton)this.orgEntity).func_110140_aT().func_111151_a(ModAttributes.MAX_STUN_ARMOR).func_111128_a(4.0);
    }

    @Override
    protected void initAnimator(AnimatorClient animator) {
        animator.addLivingAnimation(LivingMotion.FALL, Animations.BIPED_FALL);
        animator.addLivingAnimation(LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        animator.addLivingAnimation(LivingMotion.DEATH, Animations.BIPED_DEATH);
        animator.addLivingAnimation(LivingMotion.IDLE, Animations.WITHER_SKELETON_IDLE);
        animator.addLivingAnimation(LivingMotion.WALKING, Animations.WITHER_SKELETON_WALK);
        animator.setCurrentLivingMotionsToDefault();
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
    }

    @Override
    public boolean hurtEntity(Entity hitTarget, EnumHand handIn, IExtendedDamageSource source, float amount) {
        boolean succed = super.hurtEntity(hitTarget, handIn, source, amount);
        if (succed && hitTarget instanceof EntityLivingBase && ((EntityWitherSkeleton)this.orgEntity).func_70681_au().nextInt(10) == 0) {
            ((EntityLivingBase)hitTarget).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 200));
        }
        return succed;
    }

    @Override
    public void setAIAsArmed() {
        ((EntityWitherSkeleton)this.orgEntity).field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackPattern(this, (EntityCreature)this.orgEntity, 0.0, 2.5, true, MobAttackPatterns.WITHER_SKELETON_PATTERN));
        ((EntityWitherSkeleton)this.orgEntity).field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIChase(this, (EntityCreature)this.orgEntity, 1.2, true, Animations.WITHER_SKELETON_CHASE, Animations.WITHER_SKELETON_WALK));
    }

    @Override
    public VisibleMatrix4f getModelMatrix(float partialTicks) {
        VisibleMatrix4f mat = super.getModelMatrix(partialTicks);
        return VisibleMatrix4f.scale(new Vec3f(1.2f, 1.2f, 1.2f), mat, mat);
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_SKELETON;
    }
}

