/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities.entity.mob;

import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.capabilities.entity.DataKeys;
import maninthehouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninthehouse.epicfight.capabilities.entity.mob.Faction;
import maninthehouse.epicfight.capabilities.entity.mob.MobAttackPatterns;
import maninthehouse.epicfight.client.animation.AnimatorClient;
import maninthehouse.epicfight.entity.ai.EntityAIAttackPattern;
import maninthehouse.epicfight.entity.ai.EntityAIChase;
import maninthehouse.epicfight.entity.ai.attribute.ModAttributes;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.gamedata.Models;
import maninthehouse.epicfight.model.Model;
import maninthehouse.epicfight.network.ModNetworkManager;
import maninthehouse.epicfight.network.server.STCLivingMotionChange;
import maninthehouse.epicfight.network.server.STCMobInitialSetting;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;

public class ZombifiedPiglinData
extends BipedMobData<EntityPigZombie> {
    public ZombifiedPiglinData() {
        super(Faction.NATURAL);
    }

    @Override
    public void onEntityJoinWorld(EntityPigZombie entityIn) {
        super.onEntityJoinWorld(entityIn);
        ((EntityPigZombie)this.orgEntity).func_184212_Q().func_187214_a(DataKeys.STUN_ARMOR, (Object)Float.valueOf(0.0f));
    }

    @Override
    protected void initAnimator(AnimatorClient animatorClient) {
        super.initAnimator(animatorClient);
        animatorClient.addLivingAnimation(LivingMotion.IDLE, Animations.ZOMBIE_IDLE);
        animatorClient.addLivingAnimation(LivingMotion.WALKING, Animations.ZOMBIE_WALK);
        animatorClient.addLivingAnimation(LivingMotion.FALL, Animations.BIPED_FALL);
        animatorClient.addLivingAnimation(LivingMotion.MOUNT, Animations.BIPED_MOUNT);
        animatorClient.addLivingAnimation(LivingMotion.DEATH, Animations.BIPED_DEATH);
        animatorClient.setCurrentLivingMotionsToDefault();
    }

    @Override
    public STCMobInitialSetting sendInitialInformationToClient() {
        STCMobInitialSetting packet = new STCMobInitialSetting(((EntityPigZombie)this.orgEntity).func_145782_y());
        PacketBuffer buf = packet.getBuffer();
        buf.writeBoolean(((EntityPigZombie)this.orgEntity).func_98052_bS());
        return packet;
    }

    @Override
    protected void registerAttributes() {
        super.registerAttributes();
        this.registerIfAbsent(ModAttributes.MAX_STUN_ARMOR);
    }

    @Override
    public void updateMotion() {
        super.commonCreatureUpdateMotion();
    }

    @Override
    public void setAIAsArmed() {
        ((EntityPigZombie)this.orgEntity).field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPigmanChase(this, (EntityCreature)this.orgEntity));
        ((EntityPigZombie)this.orgEntity).field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackPattern(this, (EntityCreature)this.orgEntity, 0.0, 1.5, true, MobAttackPatterns.BIPED_ARMED_ONEHAND));
    }

    @Override
    public boolean attackEntityFrom(DamageSource damageSource, float amount) {
        return !(damageSource.func_76346_g() instanceof EntityPigZombie);
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)modelDB.ENTITY_BIPED;
    }

    static class EntityAIPigmanChase
    extends EntityAIChase {
        boolean angry;

        public EntityAIPigmanChase(BipedMobData<?> entitydata, EntityCreature creature) {
            super(entitydata, creature, 1.35, false, Animations.BIPED_RUN, Animations.BIPED_WALK);
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            if (!((EntityPigZombie)this.attacker).func_175457_ck()) {
                if (this.angry) {
                    STCLivingMotionChange msg = new STCLivingMotionChange(this.attacker.func_145782_y(), 1);
                    msg.setMotions(LivingMotion.WALKING);
                    msg.setAnimations(this.walkingAnimation);
                    ModNetworkManager.sendToAllPlayerTrackingThisEntity(msg, (Entity)this.attacker);
                    this.angry = false;
                }
            } else if (!this.angry) {
                STCLivingMotionChange msg = new STCLivingMotionChange(this.attacker.func_145782_y(), 1);
                msg.setMotions(LivingMotion.WALKING);
                msg.setAnimations(this.chasingAnimation);
                ModNetworkManager.sendToAllPlayerTrackingThisEntity(msg, (Entity)this.attacker);
                this.angry = true;
            }
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.angry = true;
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            this.angry = false;
        }
    }
}

