/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.capabilities.entity.player.PlayerData;
import maninthehouse.epicfight.entity.ai.attribute.ModAttributes;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.gamedata.Colliders;
import maninthehouse.epicfight.gamedata.Sounds;
import maninthehouse.epicfight.main.EpicFightMod;
import maninthehouse.epicfight.physics.Collider;
import maninthehouse.epicfight.skill.Skill;
import maninthehouse.epicfight.skill.SkillContainer;
import maninthehouse.epicfight.skill.SkillSlot;
import maninthehouse.epicfight.utils.game.Pair;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class CapabilityItem {
    protected static List<StaticAnimation> commonAutoAttackMotion = new ArrayList<StaticAnimation>();
    protected final WeaponCategory weaponCategory;
    protected Map<WieldStyle, Map<IAttribute, AttributeModifier>> attributeMap;

    public static List<StaticAnimation> getBasicAutoAttackMotion() {
        return commonAutoAttackMotion;
    }

    protected void loadClientThings() {
    }

    public CapabilityItem(WeaponCategory category) {
        if (EpicFightMod.isPhysicalClient()) {
            this.loadClientThings();
        }
        this.attributeMap = Maps.newHashMap();
        this.weaponCategory = category;
        this.registerAttribute();
    }

    public CapabilityItem(Item material, WeaponCategory category) {
        this.attributeMap = Maps.newHashMap();
        this.weaponCategory = category;
    }

    protected void registerAttribute() {
    }

    public void modifyItemTooltip(List<String> itemTooltip, LivingData<?> entitydata) {
        if (this.isTwoHanded()) {
            itemTooltip.add(1, TextFormatting.DARK_GRAY + new TextComponentTranslation("attribute.name.epicfight.twohanded", new Object[0]).func_150254_d());
        } else if (!this.canUsedInOffhand()) {
            itemTooltip.add(1, TextFormatting.DARK_GRAY + new TextComponentTranslation("attribute.name.epicfight.mainhand_only", new Object[0]).func_150254_d());
        }
        Map<IAttribute, AttributeModifier> attribute = this.getDamageAttributesInCondition(this.getStyle(entitydata));
        if (attribute != null) {
            boolean flag = false;
            for (Map.Entry<IAttribute, AttributeModifier> attr : attribute.entrySet()) {
                itemTooltip.add(new TextComponentTranslation("attribute.name.epicfight." + attr.getKey().func_111108_a(), new Object[]{ItemStack.field_111284_a.format(attr.getValue().func_111164_d() + attr.getKey().func_111110_b())}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)).func_150254_d());
                if (!attr.getKey().equals(ModAttributes.MAX_STRIKES)) continue;
                flag = true;
            }
            if (!flag) {
                itemTooltip.add(TextFormatting.DARK_GRAY + new TextComponentTranslation(ModAttributes.MAX_STRIKES.func_111108_a(), new Object[]{ItemStack.field_111284_a.format(ModAttributes.MAX_STRIKES.func_111110_b())}).func_150254_d());
            }
        }
    }

    public List<StaticAnimation> getAutoAttckMotion(PlayerData<?> playerdata) {
        return CapabilityItem.getBasicAutoAttackMotion();
    }

    public List<StaticAnimation> getMountAttackMotion() {
        return null;
    }

    public Skill getSpecialAttack(PlayerData<?> playerdata) {
        return null;
    }

    public Skill getPassiveSkill() {
        return null;
    }

    public void onHeld(PlayerData<?> playerdata) {
        SkillContainer skillContainer;
        Skill specialSkill = this.getSpecialAttack(playerdata);
        if (specialSkill != null && (skillContainer = playerdata.getSkill(SkillSlot.WEAPON_SPECIAL_ATTACK)).getContaining() != specialSkill) {
            skillContainer.setSkill(specialSkill);
        }
        Skill skill = this.getPassiveSkill();
        SkillContainer skillContainer2 = playerdata.getSkill(SkillSlot.WEAPON_GIMMICK);
        if (skill == null) {
            skillContainer2.setSkill(null);
        } else if (skillContainer2.getContaining() != skill) {
            skillContainer2.setSkill(skill);
        }
    }

    public SoundEvent getSmashingSound() {
        return Sounds.WHOOSH;
    }

    public SoundEvent getHitSound() {
        return Sounds.BLUNT_HIT;
    }

    public Collider getWeaponCollider() {
        return Colliders.fist;
    }

    public WeaponCategory getWeaponCategory() {
        return this.weaponCategory;
    }

    public void addStyleAttibute(WieldStyle style, Pair<IAttribute, AttributeModifier> attributePair) {
        this.attributeMap.computeIfAbsent(style, key -> Maps.newHashMap());
        this.attributeMap.get((Object)style).put(attributePair.first(), attributePair.second());
    }

    public void addStyleAttributeSimple(WieldStyle style, double armorNegation, double impact, int hitAtOnce) {
        this.addStyleAttibute(style, Pair.of(ModAttributes.ARMOR_NEGATION, ModAttributes.getArmorNegationModifier(armorNegation)));
        this.addStyleAttibute(style, Pair.of(ModAttributes.IMPACT, ModAttributes.getImpactModifier(impact)));
        this.addStyleAttibute(style, Pair.of(ModAttributes.MAX_STRIKES, ModAttributes.getMaxStrikesModifier(hitAtOnce)));
    }

    public final Map<IAttribute, AttributeModifier> getDamageAttributesInCondition(WieldStyle style) {
        return this.attributeMap.get((Object)style);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, LivingData<?> entitydata) {
        Map<IAttribute, AttributeModifier> modifierMap;
        HashMultimap map = HashMultimap.create();
        if (entitydata != null && (modifierMap = this.getDamageAttributesInCondition(this.getStyle(entitydata))) != null) {
            for (Map.Entry<IAttribute, AttributeModifier> entry : modifierMap.entrySet()) {
                map.put((Object)entry.getKey().func_111108_a(), (Object)entry.getValue());
            }
        }
        return map;
    }

    public Map<LivingMotion, StaticAnimation> getLivingMotionChanges(PlayerData<?> player) {
        return null;
    }

    public WieldStyle getStyle(LivingData<?> entitydata) {
        if (this.isTwoHanded()) {
            return WieldStyle.TWO_HAND;
        }
        if (this.isMainhandOnly()) {
            return entitydata.getOriginalEntity().func_184592_cb().func_190926_b() ? WieldStyle.TWO_HAND : WieldStyle.ONE_HAND;
        }
        return WieldStyle.ONE_HAND;
    }

    public final boolean canUsedInOffhand() {
        return this.getHandProperty() == HandProperty.GENERAL;
    }

    public final boolean isTwoHanded() {
        return this.getHandProperty() == HandProperty.TWO_HANDED;
    }

    public final boolean isMainhandOnly() {
        return this.getHandProperty() == HandProperty.MAINHAND_ONLY;
    }

    public boolean canUseOnMount() {
        return !this.isTwoHanded();
    }

    public HandProperty getHandProperty() {
        return HandProperty.GENERAL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canBeRenderedBoth(ItemStack item) {
        return !this.isTwoHanded() && !item.func_190926_b();
    }

    static {
        commonAutoAttackMotion.add(Animations.FIST_AUTO_1);
        commonAutoAttackMotion.add(Animations.FIST_AUTO_2);
        commonAutoAttackMotion.add(Animations.FIST_AUTO_3);
        commonAutoAttackMotion.add(Animations.FIST_DASH);
    }

    public static enum WieldStyle {
        ONE_HAND,
        TWO_HAND,
        SHEATH,
        MOUNT;

    }

    public static enum HandProperty {
        TWO_HANDED,
        MAINHAND_ONLY,
        GENERAL;

    }

    public static enum WeaponCategory {
        NONE_WEAON,
        AXE,
        FIST,
        GREATSWORD,
        HOE,
        PICKAXE,
        SHOVEL,
        SWORD,
        KATANA,
        SPEAR,
        BOW,
        CROSSBOW;

    }
}

