/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.capabilities.item;

import java.util.HashMap;
import java.util.Map;
import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.capabilities.entity.player.PlayerData;
import maninthehouse.epicfight.capabilities.item.CapabilityItem;
import maninthehouse.epicfight.capabilities.item.ModWeaponCapability;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.gamedata.Colliders;
import maninthehouse.epicfight.gamedata.Skills;
import maninthehouse.epicfight.gamedata.Sounds;
import maninthehouse.epicfight.skill.SkillSlot;

public class KatanaCapability
extends ModWeaponCapability {
    private Map<LivingMotion, StaticAnimation> sheathedMotions;

    public KatanaCapability() {
        super(CapabilityItem.WeaponCategory.KATANA, playerdata -> CapabilityItem.WieldStyle.TWO_HAND, Skills.KATANA_GIMMICK, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.katana, CapabilityItem.HandProperty.TWO_HANDED);
        this.addStyleAttributeSimple(CapabilityItem.WieldStyle.TWO_HAND, 0.0, 0.6, 1);
        this.addStyleCombo(CapabilityItem.WieldStyle.SHEATH, Animations.KATANA_SHEATHING_AUTO, Animations.KATANA_SHEATHING_DASH);
        this.addStyleCombo(CapabilityItem.WieldStyle.TWO_HAND, Animations.KATANA_AUTO_1, Animations.KATANA_AUTO_2, Animations.KATANA_AUTO_3, Animations.SWORD_DASH);
        this.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SWORD_MOUNT_ATTACK);
        this.addStyleSpecialAttack(CapabilityItem.WieldStyle.SHEATH, Skills.FATAL_DRAW);
        this.addStyleSpecialAttack(CapabilityItem.WieldStyle.TWO_HAND, Skills.FATAL_DRAW);
        this.addLivingMotionChanger(LivingMotion.IDLE, Animations.BIPED_IDLE_UNSHEATHING);
        this.addLivingMotionChanger(LivingMotion.WALKING, Animations.BIPED_WALK_UNSHEATHING);
        this.addLivingMotionChanger(LivingMotion.RUNNING, Animations.BIPED_RUN_UNSHEATHING);
        this.sheathedMotions = new HashMap<LivingMotion, StaticAnimation>();
        this.sheathedMotions.put(LivingMotion.IDLE, Animations.BIPED_IDLE_SHEATHING);
        this.sheathedMotions.put(LivingMotion.WALKING, Animations.BIPED_WALK_SHEATHING);
        this.sheathedMotions.put(LivingMotion.RUNNING, Animations.BIPED_RUN_SHEATHING);
        this.sheathedMotions.put(LivingMotion.JUMPING, Animations.BIPED_JUMP_SHEATHING);
        this.sheathedMotions.put(LivingMotion.KNEELING, Animations.BIPED_KNEEL_SHEATHING);
        this.sheathedMotions.put(LivingMotion.SNEAKING, Animations.BIPED_SNEAK_SHEATHING);
    }

    @Override
    public CapabilityItem.WieldStyle getStyle(LivingData<?> entitydata) {
        if (entitydata instanceof PlayerData) {
            PlayerData playerdata = (PlayerData)entitydata;
            if (playerdata.getSkill(SkillSlot.WEAPON_GIMMICK).getVariableNBT().func_74767_n("sheath")) {
                return CapabilityItem.WieldStyle.SHEATH;
            }
            return CapabilityItem.WieldStyle.TWO_HAND;
        }
        return CapabilityItem.WieldStyle.TWO_HAND;
    }

    @Override
    public Map<LivingMotion, StaticAnimation> getLivingMotionChanges(PlayerData<?> player) {
        if (player.getSkill(SkillSlot.WEAPON_GIMMICK).getVariableNBT().func_74767_n("sheath")) {
            return this.sheathedMotions;
        }
        return super.getLivingMotionChanges(player);
    }

    @Override
    public boolean canUseOnMount() {
        return true;
    }
}

