/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.client.capabilites.entity;

import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.capabilities.item.CapabilityItem;
import maninthehouse.epicfight.client.ClientEngine;
import maninthehouse.epicfight.client.capabilites.entity.RemoteClientPlayerData;
import maninthehouse.epicfight.network.ModNetworkManager;
import maninthehouse.epicfight.network.client.CTSPlayAnimation;
import maninthehouse.epicfight.skill.SkillContainer;
import maninthehouse.epicfight.skill.SkillSlot;
import maninthehouse.epicfight.utils.math.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientPlayerData
extends RemoteClientPlayerData<EntityPlayerSP> {
    private EntityLivingBase rayTarget;

    @Override
    public void onEntityConstructed(EntityPlayerSP entity) {
        super.onEntityConstructed(entity);
        ClientEngine.INSTANCE.setPlayerData(this);
        ClientEngine.INSTANCE.inputController.setGamePlayer(this);
    }

    @Override
    public void updateMotion() {
        super.updateMotion();
        if (!this.getClientAnimator().prevAiming() && this.currentMixMotion == LivingMotion.AIMING) {
            ((EntityPlayerSP)this.orgEntity).func_184605_cv();
            ClientEngine.INSTANCE.renderEngine.zoomIn();
        }
    }

    @Override
    public void updateOnClient() {
        Entity hit;
        super.updateOnClient();
        RayTraceResult rayResult = Minecraft.func_71410_x().field_71476_x;
        if (rayResult != null && rayResult.field_72308_g != null && (hit = rayResult.field_72308_g) instanceof EntityLivingBase) {
            this.rayTarget = (EntityLivingBase)hit;
        }
        if (this.rayTarget != null) {
            if (!this.rayTarget.func_70089_S()) {
                this.rayTarget = null;
            } else if (((EntityPlayerSP)this.getOriginalEntity()).func_70068_e((Entity)this.rayTarget) > 64.0) {
                this.rayTarget = null;
            } else if (MathUtils.getAngleBetween(this.getOriginalEntity(), (Entity)this.rayTarget) > 1.5707963267948966) {
                this.rayTarget = null;
            }
        }
    }

    @Override
    protected void playReboundAnimation() {
        this.getClientAnimator().playReboundAnimation();
        ClientEngine.INSTANCE.renderEngine.zoomOut(40);
    }

    @Override
    public void playAnimationSynchronize(int id, float modifyTime) {
        ModNetworkManager.sendToServer(new CTSPlayAnimation(id, modifyTime, false, true));
    }

    @Override
    public void onHeldItemChange(CapabilityItem mainHandCap, CapabilityItem offHandCap) {
        super.onHeldItemChange(mainHandCap, offHandCap);
        if (mainHandCap != null) {
            mainHandCap.onHeld(this);
        } else {
            this.getSkill(SkillSlot.WEAPON_GIMMICK).setSkill(null);
        }
    }

    @Override
    public void aboutToDeath() {
    }

    public void initFromOldOne(ClientPlayerData old) {
        for (SkillContainer skill : this.skills = old.skills) {
            skill.setExecuter(this);
        }
        this.setStunArmor(old.getStunArmor());
    }

    @Override
    public EntityLivingBase getAttackTarget() {
        return this.rayTarget;
    }

    @Override
    public boolean isFirstPerson() {
        return Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
    }
}

