/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.client.capabilites.entity;

import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.capabilities.entity.player.PlayerData;
import maninthehouse.epicfight.capabilities.item.CapabilityItem;
import maninthehouse.epicfight.client.animation.AnimatorClient;
import maninthehouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.gamedata.Models;
import maninthehouse.epicfight.model.Model;
import maninthehouse.epicfight.network.ModNetworkManager;
import maninthehouse.epicfight.network.client.CTSReqPlayerInfo;
import maninthehouse.epicfight.utils.math.MathUtils;
import maninthehouse.epicfight.utils.math.Vec3f;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RemoteClientPlayerData<T extends AbstractClientPlayer>
extends PlayerData<T> {
    protected float prevYaw;
    protected float bodyYaw;
    protected float prevBodyYaw;
    private ItemStack prevHeldItem;
    private ItemStack prevHeldItemOffHand;
    private boolean swingArm;

    @Override
    public void onEntityJoinWorld(T entityIn) {
        super.onEntityJoinWorld(entityIn);
        this.prevHeldItem = ItemStack.field_190927_a;
        this.prevHeldItemOffHand = ItemStack.field_190927_a;
        if (!(this instanceof ClientPlayerData)) {
            ModNetworkManager.sendToServer(new CTSReqPlayerInfo(((AbstractClientPlayer)this.orgEntity).func_145782_y()));
        }
    }

    @Override
    public void updateMotion() {
        if (((AbstractClientPlayer)this.orgEntity).func_184613_cA()) {
            this.currentMotion = LivingMotion.FLYING;
        } else if (((AbstractClientPlayer)this.orgEntity).func_184187_bx() != null) {
            this.currentMotion = LivingMotion.MOUNT;
        } else {
            AnimatorClient animator = this.getClientAnimator();
            if (((AbstractClientPlayer)this.orgEntity).func_70090_H() && ((AbstractClientPlayer)this.orgEntity).field_70181_x < -0.005) {
                this.currentMotion = LivingMotion.FLOATING;
            } else if (((AbstractClientPlayer)this.orgEntity).field_70181_x < (double)-0.55f) {
                this.currentMotion = LivingMotion.FALL;
            } else if (((AbstractClientPlayer)this.orgEntity).field_70721_aZ > 0.01f) {
                this.currentMotion = ((AbstractClientPlayer)this.orgEntity).func_70093_af() ? LivingMotion.SNEAKING : (((AbstractClientPlayer)this.orgEntity).func_70051_ag() ? LivingMotion.RUNNING : LivingMotion.WALKING);
                if (((AbstractClientPlayer)this.orgEntity).field_191988_bg > 0.0f) {
                    animator.reversePlay = false;
                } else if (((AbstractClientPlayer)this.orgEntity).field_191988_bg < 0.0f) {
                    animator.reversePlay = true;
                }
            } else {
                animator.reversePlay = false;
                this.currentMotion = ((AbstractClientPlayer)this.orgEntity).func_70093_af() ? LivingMotion.KNEELING : LivingMotion.IDLE;
            }
        }
        if (((AbstractClientPlayer)this.orgEntity).func_184587_cr() && ((AbstractClientPlayer)this.orgEntity).func_184605_cv() > 0) {
            EnumAction useAction = ((AbstractClientPlayer)this.orgEntity).func_184586_b(((AbstractClientPlayer)this.orgEntity).func_184600_cs()).func_77975_n();
            this.currentMixMotion = useAction == EnumAction.BLOCK ? LivingMotion.BLOCKING : (useAction == EnumAction.BOW ? LivingMotion.AIMING : LivingMotion.NONE);
        } else if (this.getClientAnimator().prevAiming()) {
            this.playReboundAnimation();
        } else {
            this.currentMixMotion = LivingMotion.NONE;
        }
    }

    @Override
    protected void updateOnClient() {
        boolean isOffHandChanged;
        this.prevYaw = this.yaw;
        this.prevBodyYaw = this.bodyYaw;
        this.bodyYaw = this.inaction ? ((AbstractClientPlayer)this.orgEntity).field_70177_z : ((AbstractClientPlayer)this.orgEntity).field_70760_ar;
        boolean isMainHandChanged = this.prevHeldItem.func_77973_b() != ((AbstractClientPlayer)this.orgEntity).field_71071_by.func_70448_g().func_77973_b();
        boolean bl = isOffHandChanged = this.prevHeldItemOffHand.func_77973_b() != ((ItemStack)((AbstractClientPlayer)this.orgEntity).field_71071_by.field_184439_c.get(0)).func_77973_b();
        if (isMainHandChanged || isOffHandChanged) {
            this.onHeldItemChange(this.getHeldItemCapability(EnumHand.MAIN_HAND), this.getHeldItemCapability(EnumHand.OFF_HAND));
            if (isMainHandChanged) {
                this.prevHeldItem = ((AbstractClientPlayer)this.orgEntity).field_71071_by.func_70448_g();
            }
            if (isOffHandChanged) {
                this.prevHeldItemOffHand = (ItemStack)((AbstractClientPlayer)this.orgEntity).field_71071_by.field_184439_c.get(0);
            }
        }
        super.updateOnClient();
        if (((AbstractClientPlayer)this.orgEntity).field_70725_aQ == 1) {
            this.getClientAnimator().playDeathAnimation();
        }
        if (this.swingArm != ((AbstractClientPlayer)this.orgEntity).field_82175_bq) {
            if (!this.swingArm) {
                this.getClientAnimator().playMixLayerAnimation(Animations.BIPED_DIG);
            } else {
                this.getClientAnimator().offMixLayer(false);
            }
            this.swingArm = ((AbstractClientPlayer)this.orgEntity).field_82175_bq;
        }
    }

    public void onHeldItemChange(CapabilityItem mainHandCap, CapabilityItem offHandCap) {
        this.getClientAnimator().resetMixMotion();
        this.getClientAnimator().offMixLayer(false);
        this.cancelUsingItem();
    }

    protected void playReboundAnimation() {
        this.getClientAnimator().playReboundAnimation();
    }

    @Override
    public void playAnimationSynchronize(int id, float modifyTime) {
    }

    @Override
    public <M extends Model> M getEntityModel(Models<M> modelDB) {
        return (M)(((AbstractClientPlayer)this.orgEntity).func_175154_l().equals("slim") ? modelDB.ENTITY_BIPED_SLIM_ARM : modelDB.ENTITY_BIPED);
    }

    @Override
    public VisibleMatrix4f getHeadMatrix(float partialTick) {
        float yaw;
        AbstractClientPlayer entity = (AbstractClientPlayer)this.getOriginalEntity();
        float pitch = 0.0f;
        float prvePitch = 0.0f;
        if (this.inaction || entity.func_184187_bx() != null) {
            yaw = 0.0f;
        } else {
            float f = MathUtils.interpolateRotation(this.prevBodyYaw, this.bodyYaw, partialTick);
            float f1 = MathUtils.interpolateRotation(entity.field_70758_at, entity.field_70759_as, partialTick);
            yaw = f1 - f;
        }
        if (!((AbstractClientPlayer)this.orgEntity).func_184613_cA()) {
            prvePitch = entity.field_70127_C;
            pitch = entity.field_70125_A;
        }
        return MathUtils.getModelMatrixIntegrated(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, prvePitch, pitch, yaw, yaw, partialTick, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public VisibleMatrix4f getModelMatrix(float partialTick) {
        float rotyaw;
        float prevRotYaw;
        if (((AbstractClientPlayer)this.orgEntity).func_184613_cA()) {
            VisibleMatrix4f mat = MathUtils.getModelMatrixIntegrated((float)((AbstractClientPlayer)this.orgEntity).field_70142_S, (float)((AbstractClientPlayer)this.orgEntity).field_70165_t, (float)((AbstractClientPlayer)this.orgEntity).field_70137_T, (float)((AbstractClientPlayer)this.orgEntity).field_70163_u, (float)((AbstractClientPlayer)this.orgEntity).field_70136_U, (float)((AbstractClientPlayer)this.orgEntity).field_70161_v, 0.0f, 0.0f, 0.0f, 0.0f, partialTick, 1.0f, 1.0f, 1.0f);
            VisibleMatrix4f.rotate((float)(-Math.toRadians(((AbstractClientPlayer)this.orgEntity).field_70761_aq)), new Vec3f(0.0f, 1.0f, 0.0f), mat, mat);
            float f = (float)((AbstractClientPlayer)this.orgEntity).func_184599_cB() + Minecraft.func_71410_x().func_184121_ak();
            float f1 = MathHelper.func_76131_a((float)(f * f / 100.0f), (float)0.0f, (float)1.0f);
            VisibleMatrix4f.rotate((float)Math.toRadians(f1 * (-90.0f - ((AbstractClientPlayer)this.orgEntity).field_70125_A)), new Vec3f(1.0f, 0.0f, 0.0f), mat, mat);
            Vec3d vec3d = ((AbstractClientPlayer)this.orgEntity).func_70676_i(Minecraft.func_71410_x().func_184121_ak());
            Vec3d vec3d1 = new Vec3d(((AbstractClientPlayer)this.orgEntity).field_70159_w, ((AbstractClientPlayer)this.orgEntity).field_70181_x, ((AbstractClientPlayer)this.orgEntity).field_70179_y);
            double d0 = vec3d1.field_72450_a * vec3d1.field_72450_a + vec3d1.field_72449_c * vec3d1.field_72449_c;
            double d1 = vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c;
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec3d1.field_72450_a * vec3d.field_72450_a + vec3d1.field_72449_c * vec3d.field_72449_c) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = vec3d1.field_72450_a * vec3d.field_72449_c - vec3d1.field_72449_c * vec3d.field_72450_a;
                VisibleMatrix4f.rotate((float)Math.toRadians((float)(Math.signum(d3) * Math.acos(d2)) * 180.0f / (float)Math.PI), new Vec3f(0.0f, 1.0f, 0.0f), mat, mat);
            }
            return mat;
        }
        float prevPitch = 0.0f;
        float pitch = 0.0f;
        if (((AbstractClientPlayer)this.orgEntity).func_184187_bx() instanceof EntityLivingBase) {
            EntityLivingBase ridingEntity = (EntityLivingBase)((AbstractClientPlayer)this.orgEntity).func_184187_bx();
            prevRotYaw = ridingEntity.field_70760_ar;
            rotyaw = ridingEntity.field_70761_aq;
        } else {
            float yaw = this.inaction ? MathUtils.interpolateRotation(this.prevYaw, this.yaw, partialTick) : 0.0f;
            prevRotYaw = this.prevBodyYaw + yaw;
            rotyaw = this.bodyYaw + yaw;
        }
        return MathUtils.getModelMatrixIntegrated((float)((AbstractClientPlayer)this.orgEntity).field_70142_S, (float)((AbstractClientPlayer)this.orgEntity).field_70165_t, (float)((AbstractClientPlayer)this.orgEntity).field_70137_T, (float)((AbstractClientPlayer)this.orgEntity).field_70163_u, (float)((AbstractClientPlayer)this.orgEntity).field_70136_U, (float)((AbstractClientPlayer)this.orgEntity).field_70161_v, prevPitch, pitch, prevRotYaw, rotyaw, partialTick, 1.0f, 1.0f, 1.0f);
    }
}

