/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.client.events.engine;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import maninthehouse.epicfight.animation.Animator;
import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.capabilities.ModCapabilities;
import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.capabilities.item.CapabilityItem;
import maninthehouse.epicfight.client.ClientEngine;
import maninthehouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninthehouse.epicfight.client.input.ModKeys;
import maninthehouse.epicfight.config.ConfigurationIngame;
import maninthehouse.epicfight.network.ModNetworkManager;
import maninthehouse.epicfight.network.client.CTSPlayAnimation;
import maninthehouse.epicfight.skill.SkillContainer;
import maninthehouse.epicfight.skill.SkillSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class ControllEngine {
    private Map<KeyBinding, Consumer<KeyBinding>> keyFunctionMap;
    private EntityPlayerSP player;
    private ClientPlayerData playerdata;
    private int comboHoldCounter;
    private int comboCounter;
    private int mouseLeftPressCounter = 0;
    private int sneakPressCounter = 0;
    private int reservedSkill;
    private int skillReserveCounter;
    private boolean sneakPressToggle = false;
    private boolean mouseLeftPressToggle = false;
    private boolean lightPress;
    public GameSettings gameSettings;

    public ControllEngine() {
        Events.controllEngine = this;
        this.gameSettings = Minecraft.func_71410_x().field_71474_y;
        this.keyFunctionMap = new HashMap<KeyBinding, Consumer<KeyBinding>>();
        this.keyFunctionMap.put(this.gameSettings.field_74312_F, this::attackKeyPressed);
        this.keyFunctionMap.put(this.gameSettings.field_186718_X, this::swapHandKeyPressed);
        this.keyFunctionMap.put(this.gameSettings.field_74311_E, this::sneakKeyPressed);
        this.keyFunctionMap.put(ModKeys.SWITCH_MODE, this::switchModeKeyPressed);
        this.keyFunctionMap.put(ModKeys.DODGE, this::dodgeKeyPressed);
    }

    public void setGamePlayer(ClientPlayerData playerdata) {
        this.comboCounter = 0;
        this.mouseLeftPressCounter = 0;
        this.mouseLeftPressToggle = false;
        this.sneakPressCounter = 0;
        this.sneakPressToggle = false;
        this.lightPress = false;
        this.player = (EntityPlayerSP)playerdata.getOriginalEntity();
        this.playerdata = playerdata;
    }

    public boolean playerCanMove(LivingData.EntityState playerState) {
        return !playerState.isMovementLocked() || this.player.func_110317_t();
    }

    public boolean playerCanRotate(LivingData.EntityState playerState) {
        return !playerState.isCameraRotationLocked() || this.player.func_110317_t();
    }

    public boolean playerCanAct(LivingData.EntityState playerState) {
        return !this.player.func_175149_v() && !this.player.func_184613_cA() && this.playerdata.currentMotion != LivingMotion.FALL && !playerState.isMovementLocked();
    }

    public boolean playerCanDodging(LivingData.EntityState playerState) {
        return !this.player.func_175149_v() && !this.player.func_184613_cA() && this.playerdata.currentMotion != LivingMotion.FALL && playerState.canAct();
    }

    public boolean playerCanExecuteSkill(LivingData.EntityState playerState) {
        return !this.player.func_175149_v() && !this.player.func_184613_cA() && this.playerdata.currentMotion != LivingMotion.FALL && playerState.canAct();
    }

    private void attackKeyPressed(KeyBinding key) {
        if (ClientEngine.INSTANCE.isBattleMode()) {
            this.setKeyBind(this.gameSettings.field_74312_F, false);
            this.gameSettings.field_74312_F.func_151468_f();
            if (this.player.func_184605_cv() == 0 && !this.mouseLeftPressToggle) {
                this.mouseLeftPressToggle = true;
            }
        } else {
            ++this.gameSettings.field_74312_F.field_151474_i;
        }
        if (this.player.func_184825_o(0.0f) < 0.9f) {
            this.gameSettings.field_74312_F.field_151474_i = 0;
        }
    }

    private void dodgeKeyPressed(KeyBinding key) {
        if (!Keyboard.isRepeatEvent()) {
            if (key.func_151463_i() == this.gameSettings.field_74311_E.func_151463_i()) {
                if (this.player.func_184187_bx() == null && ClientEngine.INSTANCE.isBattleMode() && !this.sneakPressToggle) {
                    this.sneakPressToggle = true;
                }
            } else {
                SkillContainer skill = this.playerdata.getSkill(SkillSlot.DODGE);
                if (skill.canExecute(this.playerdata) && skill.getContaining().isExecutableState(this.playerdata)) {
                    skill.execute(this.playerdata);
                }
            }
        }
    }

    private void sneakKeyPressed(KeyBinding key) {
        if (ModKeys.DODGE.func_151463_i() == this.gameSettings.field_74311_E.func_151463_i() && !this.sneakPressToggle) {
            this.dodgeKeyPressed(ModKeys.DODGE);
        }
    }

    private void swapHandKeyPressed(KeyBinding key) {
        CapabilityItem cap = this.playerdata.getHeldItemCapability(EnumHand.MAIN_HAND);
        if (this.playerdata.isInaction() || cap != null && !cap.canUsedInOffhand()) {
            key.field_151474_i = 0;
            this.setKeyBind(key, false);
        } else {
            ++key.field_151474_i;
        }
    }

    private void switchModeKeyPressed(KeyBinding key) {
        if (!Keyboard.isRepeatEvent()) {
            ClientEngine.INSTANCE.toggleActingMode();
        }
    }

    public void tick() {
        SkillContainer skill;
        if (this.playerdata == null) {
            return;
        }
        LivingData.EntityState playerState = this.playerdata.getEntityState();
        if (this.mouseLeftPressToggle) {
            if (!this.isKeyDown(this.gameSettings.field_74312_F)) {
                this.lightPress = true;
                this.mouseLeftPressToggle = false;
                this.mouseLeftPressCounter = 0;
            } else if (this.mouseLeftPressCounter > ConfigurationIngame.longPressCount) {
                if (this.playerCanExecuteSkill(playerState)) {
                    CapabilityItem itemCap = this.playerdata.getHeldItemCapability(EnumHand.MAIN_HAND);
                    if (itemCap != null) {
                        this.playerdata.getSkill(SkillSlot.WEAPON_SPECIAL_ATTACK).execute(this.playerdata);
                    }
                } else if (!this.player.func_175149_v()) {
                    this.reserveSkill(SkillSlot.WEAPON_SPECIAL_ATTACK);
                }
                this.mouseLeftPressToggle = false;
                this.mouseLeftPressCounter = 0;
                this.resetAttackCounter();
            } else {
                this.setKeyBind(this.gameSettings.field_74312_F, false);
                ++this.mouseLeftPressCounter;
            }
        }
        if (this.lightPress) {
            if (this.playerCanAct(playerState)) {
                this.playAttackMotion(this.player.func_184614_ca(), this.player.func_70051_ag());
                this.player.func_184821_cY();
                this.lightPress = false;
            } else if (this.player.func_175149_v() || playerState.getLevel() < 2) {
                this.lightPress = false;
            }
            this.lightPress = false;
            this.mouseLeftPressToggle = false;
            this.mouseLeftPressCounter = 0;
        }
        if (this.sneakPressToggle) {
            if (!this.isKeyDown(this.gameSettings.field_74311_E)) {
                skill = this.playerdata.getSkill(SkillSlot.DODGE);
                if (skill.canExecute(this.playerdata) && skill.getContaining().isExecutableState(this.playerdata)) {
                    skill.execute(this.playerdata);
                } else {
                    this.reserveSkill(SkillSlot.DODGE);
                }
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else if (this.sneakPressCounter > ConfigurationIngame.longPressCount) {
                this.sneakPressToggle = false;
                this.sneakPressCounter = 0;
            } else {
                ++this.sneakPressCounter;
            }
        }
        if (this.reservedSkill >= 0) {
            if (this.skillReserveCounter > 0) {
                skill = this.playerdata.getSkill(this.reservedSkill);
                --this.skillReserveCounter;
                if (skill.getContaining() != null && skill.canExecute(this.playerdata) && skill.getContaining().isExecutableState(this.playerdata)) {
                    skill.execute(this.playerdata);
                    this.reservedSkill = -1;
                    this.skillReserveCounter = -1;
                }
            } else {
                this.reservedSkill = -1;
                this.skillReserveCounter = -1;
            }
        }
        if (this.comboHoldCounter > 0) {
            float f = this.player.func_184825_o(0.0f);
            if (!playerState.isMovementLocked() && !playerState.isCameraRotationLocked() && f >= 1.0f) {
                --this.comboHoldCounter;
                if (this.comboHoldCounter == 0) {
                    this.resetAttackCounter();
                }
            }
        }
        for (int i = 0; i < 9; ++i) {
            if (!this.isKeyDown(this.gameSettings.field_151456_ac[i]) || !this.playerdata.isInaction()) continue;
            this.gameSettings.field_151456_ac[i].func_151468_f();
        }
    }

    private void playAttackMotion(ItemStack holdItem, boolean dashAttack) {
        CapabilityItem cap = (CapabilityItem)holdItem.getCapability(ModCapabilities.CAPABILITY_ITEM, null);
        StaticAnimation attackMotion = null;
        if (this.player.func_184187_bx() != null) {
            if (this.player.func_110317_t() && cap != null && cap.canUseOnMount()) {
                attackMotion = cap.getMountAttackMotion().get(this.comboCounter);
                ++this.comboCounter;
                this.comboCounter %= cap.getMountAttackMotion().size();
            }
        } else {
            List<StaticAnimation> combo = null;
            if (combo == null) {
                combo = cap != null ? (combo = cap.getAutoAttckMotion(this.playerdata)) : CapabilityItem.getBasicAutoAttackMotion();
            }
            int comboSize = combo.size();
            this.comboCounter = dashAttack ? comboSize - 1 : (this.comboCounter %= comboSize - 1);
            attackMotion = combo.get(this.comboCounter);
            this.comboCounter = dashAttack ? 0 : this.comboCounter + 1;
        }
        this.comboHoldCounter = 10;
        if (attackMotion != null) {
            ((Animator)this.playerdata.getAnimator()).playAnimation(attackMotion, 0.0f);
            ModNetworkManager.sendToServer(new CTSPlayAnimation(attackMotion, 0.0f, false, false));
        }
    }

    private void reserveSkill(SkillSlot slot) {
        this.reservedSkill = slot.getIndex();
        this.skillReserveCounter = 8;
    }

    public boolean isKeyDown(KeyBinding key) {
        int keyCode = key.func_151463_i();
        if (keyCode > 0) {
            return Keyboard.isKeyDown((int)key.func_151463_i());
        }
        return Mouse.isButtonDown((int)(key.func_151463_i() + 100));
    }

    public void setKeyBind(KeyBinding key, boolean setter) {
        KeyBinding.func_74510_a((int)key.func_151463_i(), (boolean)setter);
    }

    public void resetAttackCounter() {
        this.comboCounter = 0;
    }

    @SideOnly(value=Side.CLIENT)
    @Mod.EventBusSubscriber(modid="epicfight", value={Side.CLIENT})
    public static class Events {
        static ControllEngine controllEngine;

        @SubscribeEvent
        public static void mouseEvent(InputEvent.MouseInputEvent event) {
            if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71462_r == null) {
                for (Map.Entry entry : controllEngine.keyFunctionMap.entrySet()) {
                    if (((KeyBinding)entry.getKey()).field_151474_i <= 0) continue;
                    --((KeyBinding)entry.getKey()).field_151474_i;
                    ((Consumer)controllEngine.keyFunctionMap.get(entry.getKey())).accept(entry.getKey());
                }
            }
        }

        @SubscribeEvent
        public static void keyboardEvent(InputEvent.KeyInputEvent event) {
            if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71462_r == null) {
                for (Map.Entry entry : controllEngine.keyFunctionMap.entrySet()) {
                    if (((KeyBinding)entry.getKey()).field_151474_i <= 0) continue;
                    --((KeyBinding)entry.getKey()).field_151474_i;
                    ((Consumer)controllEngine.keyFunctionMap.get(entry.getKey())).accept(entry.getKey());
                }
            }
        }

        @SubscribeEvent
        public static void mouseEvent(MouseEvent event) {
            int dwheel = event.getDwheel();
            if (dwheel != 0 && controllEngine.playerdata != null) {
                if (controllEngine.playerdata.isInaction()) {
                    event.setCanceled(true);
                } else {
                    controllEngine.playerdata.cancelUsingItem();
                    controllEngine.resetAttackCounter();
                }
            }
        }

        @SubscribeEvent
        public static void cancelPlayerRotationWhenInaction(TickEvent.RenderTickEvent event) {
            LivingData.EntityState playerState;
            if (controllEngine.playerdata != null && !controllEngine.playerCanRotate(playerState = controllEngine.playerdata.getEntityState()) && controllEngine.player.func_70089_S()) {
                Mouse.getDX();
                Mouse.getDY();
            }
        }

        @SubscribeEvent
        public static void moveInputEvent(InputUpdateEvent event) {
            if (controllEngine.playerdata == null) {
                return;
            }
            LivingData.EntityState playerState = controllEngine.playerdata.getEntityState();
            if (!controllEngine.playerCanMove(playerState)) {
                event.getMovementInput().field_192832_b = 0.0f;
                event.getMovementInput().field_78902_a = 0.0f;
                event.getMovementInput().field_187255_c = false;
                event.getMovementInput().field_187256_d = false;
                event.getMovementInput().field_187257_e = false;
                event.getMovementInput().field_187258_f = false;
                event.getMovementInput().field_78901_c = false;
                event.getMovementInput().field_78899_d = false;
                ((EntityPlayerSP)event.getEntityPlayer()).field_71156_d = -1;
            }
        }

        @SubscribeEvent
        public static void preProcessKeyBindings(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.START && Minecraft.func_71410_x().field_71439_g != null) {
                controllEngine.tick();
            }
        }
    }
}

