/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.client.events.engine;

import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import maninthehouse.epicfight.capabilities.ModCapabilities;
import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.capabilities.item.CapabilityItem;
import maninthehouse.epicfight.client.ClientEngine;
import maninthehouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninthehouse.epicfight.client.gui.BattleModeGui;
import maninthehouse.epicfight.client.gui.EntityIndicator;
import maninthehouse.epicfight.client.input.ModKeys;
import maninthehouse.epicfight.client.renderer.AimHelperRenderer;
import maninthehouse.epicfight.client.renderer.FirstPersonRenderer;
import maninthehouse.epicfight.client.renderer.entity.ArmatureRenderer;
import maninthehouse.epicfight.client.renderer.entity.CaveSpiderRenderer;
import maninthehouse.epicfight.client.renderer.entity.CreeperRenderer;
import maninthehouse.epicfight.client.renderer.entity.EndermanRenderer;
import maninthehouse.epicfight.client.renderer.entity.IronGolemRenderer;
import maninthehouse.epicfight.client.renderer.entity.PlayerRenderer;
import maninthehouse.epicfight.client.renderer.entity.SimpleTexturBipedRenderer;
import maninthehouse.epicfight.client.renderer.entity.SpiderRenderer;
import maninthehouse.epicfight.client.renderer.entity.VexRenderer;
import maninthehouse.epicfight.client.renderer.entity.ZombieVillagerRenderer;
import maninthehouse.epicfight.client.renderer.item.RenderBow;
import maninthehouse.epicfight.client.renderer.item.RenderElytra;
import maninthehouse.epicfight.client.renderer.item.RenderHat;
import maninthehouse.epicfight.client.renderer.item.RenderItemBase;
import maninthehouse.epicfight.client.renderer.item.RenderKatana;
import maninthehouse.epicfight.client.renderer.item.RenderShield;
import maninthehouse.epicfight.config.ConfigurationIngame;
import maninthehouse.epicfight.item.KatanaItem;
import maninthehouse.epicfight.item.ModItems;
import maninthehouse.epicfight.utils.game.Formulars;
import maninthehouse.epicfight.utils.math.MathUtils;
import maninthehouse.epicfight.utils.math.Vec3f;
import maninthehouse.epicfight.utils.math.Vec4f;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderEngine {
    private static final Vec3f AIMING_CORRECTION = new Vec3f(-1.5f, 0.0f, 1.25f);
    public static final ResourceLocation NULL_TEXTURE = new ResourceLocation("epicfight", "textures/gui/null.png");
    public AimHelperRenderer aimHelper;
    public BattleModeGui guiSkillBar = new BattleModeGui();
    private Minecraft minecraft;
    private VisibleMatrix4f projectionMatrix;
    private Map<Class<? extends Entity>, ArmatureRenderer> entityRendererMap;
    private Map<Item, RenderItemBase> itemRendererMapByInstance;
    private Map<Class<? extends Item>, RenderItemBase> itemRendererMapByClass;
    private FirstPersonRenderer firstPersonRenderer;
    private boolean aiming;
    private int zoomOutTimer = 0;
    private int zoomCount;
    private int zoomMaxCount = 20;

    public RenderEngine() {
        Events.renderEngine = this;
        RenderItemBase.renderEngine = this;
        EntityIndicator.init();
        this.minecraft = Minecraft.func_71410_x();
        this.entityRendererMap = new HashMap<Class<? extends Entity>, ArmatureRenderer>();
        this.itemRendererMapByInstance = new HashMap<Item, RenderItemBase>();
        this.itemRendererMapByClass = new HashMap<Class<? extends Item>, RenderItemBase>();
        this.projectionMatrix = new VisibleMatrix4f();
        this.firstPersonRenderer = new FirstPersonRenderer();
    }

    public void buildRenderer() {
        this.entityRendererMap.put(EntityCreeper.class, new CreeperRenderer());
        this.entityRendererMap.put(EntityEnderman.class, new EndermanRenderer());
        this.entityRendererMap.put(EntityZombie.class, new SimpleTexturBipedRenderer("textures/entity/zombie/zombie.png"));
        this.entityRendererMap.put(EntityZombieVillager.class, new ZombieVillagerRenderer());
        this.entityRendererMap.put(EntityPigZombie.class, new SimpleTexturBipedRenderer("epicfight:textures/entity/zombified_piglin.png"));
        this.entityRendererMap.put(EntityHusk.class, new SimpleTexturBipedRenderer("textures/entity/zombie/husk.png"));
        this.entityRendererMap.put(EntitySkeleton.class, new SimpleTexturBipedRenderer("textures/entity/skeleton/skeleton.png"));
        this.entityRendererMap.put(EntityWitherSkeleton.class, new SimpleTexturBipedRenderer("textures/entity/skeleton/wither_skeleton.png"));
        this.entityRendererMap.put(EntityStray.class, new SimpleTexturBipedRenderer("textures/entity/skeleton/stray.png"));
        this.entityRendererMap.put(EntityPlayerSP.class, new PlayerRenderer());
        this.entityRendererMap.put(EntityOtherPlayerMP.class, new PlayerRenderer());
        this.entityRendererMap.put(EntitySpider.class, new SpiderRenderer());
        this.entityRendererMap.put(EntityCaveSpider.class, new CaveSpiderRenderer());
        this.entityRendererMap.put(EntityIronGolem.class, new IronGolemRenderer());
        this.entityRendererMap.put(EntityVindicator.class, new SimpleTexturBipedRenderer("textures/entity/illager/vindicator.png"));
        this.entityRendererMap.put(EntityEvoker.class, new SimpleTexturBipedRenderer("textures/entity/illager/evoker.png"));
        this.entityRendererMap.put(EntityWitch.class, new SimpleTexturBipedRenderer("epicfight:textures/entity/witch.png"));
        this.entityRendererMap.put(EntityVex.class, new VexRenderer());
        RenderBow bowRenderer = new RenderBow();
        RenderElytra elytraRenderer = new RenderElytra();
        RenderHat hatRenderer = new RenderHat();
        RenderKatana katanaRenderer = new RenderKatana();
        RenderShield shieldRenderer = new RenderShield();
        this.itemRendererMapByInstance.put(Items.field_190931_a, new RenderItemBase());
        this.itemRendererMapByInstance.put((Item)Items.field_151031_f, bowRenderer);
        this.itemRendererMapByInstance.put(Items.field_185159_cQ, shieldRenderer);
        this.itemRendererMapByInstance.put(Items.field_185160_cR, elytraRenderer);
        this.itemRendererMapByInstance.put(ModItems.KATANA, katanaRenderer);
        this.itemRendererMapByClass.put(ItemBlock.class, hatRenderer);
        this.itemRendererMapByClass.put(ItemBow.class, bowRenderer);
        this.itemRendererMapByClass.put(ItemElytra.class, elytraRenderer);
        this.itemRendererMapByClass.put(ItemShield.class, shieldRenderer);
        this.itemRendererMapByClass.put(KatanaItem.class, katanaRenderer);
        this.aimHelper = new AimHelperRenderer();
    }

    public RenderItemBase getItemRenderer(Item item) {
        RenderItemBase renderItem = this.itemRendererMapByInstance.get(item);
        if (renderItem == null) {
            renderItem = this.findMatchingRendererByClass(item.getClass());
            if (renderItem == null) {
                renderItem = this.itemRendererMapByInstance.get(Items.field_190931_a);
            }
            this.itemRendererMapByInstance.put(item, renderItem);
        }
        return renderItem;
    }

    private RenderItemBase findMatchingRendererByClass(Class<?> clazz) {
        RenderItemBase renderer = null;
        while (clazz != null && renderer == null) {
            renderer = this.itemRendererMapByClass.getOrDefault(clazz, null);
            clazz = clazz.getSuperclass();
        }
        return renderer;
    }

    public void renderEntityArmatureModel(EntityLivingBase livingEntity, LivingData<?> entitydata, RenderLivingBase<?> renderer, double x, double y, double z, float partialTicks) {
        this.entityRendererMap.get(livingEntity.getClass()).render(livingEntity, entitydata, renderer, x, y, z, partialTicks);
    }

    public boolean isEntityContained(Entity entity) {
        return this.entityRendererMap.containsKey(entity.getClass());
    }

    public void zoomIn() {
        this.aiming = true;
        this.zoomCount = this.zoomCount == 0 ? 1 : this.zoomCount;
        this.zoomOutTimer = 0;
    }

    public void zoomOut(int timer) {
        this.aiming = false;
        this.zoomOutTimer = timer;
    }

    private void updateCameraInfo(int pov, double partialTicks) {
        double d3;
        if (pov != 1) {
            return;
        }
        FloatBuffer fb1 = GLAllocation.func_74529_h((int)16);
        GlStateManager.func_179111_a((int)2982, (FloatBuffer)fb1);
        Entity entity = this.minecraft.func_175606_aa();
        double posX = MathUtils.lerp(partialTicks, entity.field_70142_S, entity.field_70165_t);
        double posY = MathUtils.lerp(partialTicks, entity.field_70137_T, entity.field_70163_u) + (double)entity.func_70047_e();
        double posZ = MathUtils.lerp(partialTicks, entity.field_70136_U, entity.field_70161_v);
        float intpol = pov == 1 ? (float)this.zoomCount / (float)this.zoomMaxCount : 0.0f;
        Vec3f interpolatedCorrection = new Vec3f(RenderEngine.AIMING_CORRECTION.x * intpol, RenderEngine.AIMING_CORRECTION.y * intpol, RenderEngine.AIMING_CORRECTION.z * intpol);
        VisibleMatrix4f rotationMatrix = ClientEngine.INSTANCE.getPlayerData().getMatrix((float)partialTicks);
        Vec4f rotateVec = VisibleMatrix4f.transform(rotationMatrix, new Vec4f(interpolatedCorrection.x, interpolatedCorrection.y, interpolatedCorrection.z - 4.0f, 1.0f), null);
        double smallest = d3 = Math.sqrt(rotateVec.x * rotateVec.x + rotateVec.y * rotateVec.y + rotateVec.z * rotateVec.z);
        double d00 = posX + (double)rotateVec.x;
        double d11 = posY - (double)rotateVec.y;
        double d22 = posZ + (double)rotateVec.z;
        for (int i = 0; i < 8; ++i) {
            double d7;
            RayTraceResult raytraceresult;
            float f = (i & 1) * 2 - 1;
            float f1 = (i >> 1 & 1) * 2 - 1;
            float f2 = (i >> 2 & 1) * 2 - 1;
            if ((raytraceresult = this.minecraft.field_71441_e.func_147447_a(new Vec3d(posX + (double)(f *= 0.1f), posY + (double)(f1 *= 0.1f), posZ + (double)(f2 *= 0.1f)), new Vec3d(d00 + (double)f + (double)f2, d11 + (double)f1, d22 + (double)f2), false, true, false)) == null || !((d7 = raytraceresult.field_72307_f.func_72438_d(new Vec3d(posX, posY, posZ))) < smallest)) continue;
            smallest = d7;
        }
        float dist = d3 == 0.0 ? 0.0f : (float)(smallest / d3);
        GlStateManager.func_179109_b((float)(interpolatedCorrection.x * dist), (float)(-interpolatedCorrection.y * dist), (float)(interpolatedCorrection.z * dist));
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-fb1.get(14)));
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)((float)(-smallest)));
        FloatBuffer fb2 = GLAllocation.func_74529_h((int)16);
        GL11.glGetFloat((int)2983, (FloatBuffer)fb2);
        this.projectionMatrix.load(fb2.asReadOnlyBuffer());
    }

    public VisibleMatrix4f getCurrentProjectionMatrix() {
        return this.projectionMatrix;
    }

    @Mod.EventBusSubscriber(modid="epicfight", value={Side.CLIENT})
    public static class Events {
        static RenderEngine renderEngine;

        @SubscribeEvent
        public static void renderLivingEvent(RenderLivingEvent.Pre<? extends EntityLivingBase> event) {
            EntityLivingBase livingentity = event.getEntity();
            if (renderEngine.isEntityContained((Entity)livingentity)) {
                LivingData entitydata;
                if (livingentity instanceof EntityPlayerSP) {
                    if (event.getPartialRenderTick() == 1.0f) {
                        return;
                    }
                    if (!ClientEngine.INSTANCE.isBattleMode() && ConfigurationIngame.filterAnimation) {
                        return;
                    }
                }
                if ((entitydata = (LivingData)livingentity.getCapability(ModCapabilities.CAPABILITY_ENTITY, null)) != null) {
                    event.setCanceled(true);
                    renderEngine.renderEntityArmatureModel(livingentity, entitydata, event.getRenderer(), event.getX(), event.getY(), event.getZ(), event.getPartialRenderTick());
                }
            }
            if (!Minecraft.func_71410_x().field_71474_y.field_74319_N) {
                for (EntityIndicator entityIndicator : EntityIndicator.ENTITY_INDICATOR_RENDERERS) {
                    if (!entityIndicator.shouldDraw(event.getEntity())) continue;
                    entityIndicator.drawIndicator(event.getEntity(), event.getX(), event.getY(), event.getZ(), event.getPartialRenderTick());
                }
            }
        }

        @SubscribeEvent
        public static void itemTooltip(ItemTooltipEvent event) {
            CapabilityItem cap;
            if (event.getEntityPlayer() != null && (cap = ModCapabilities.stackCapabilityGetter(event.getItemStack())) != null && ClientEngine.INSTANCE.getPlayerData() != null) {
                if (ClientEngine.INSTANCE.inputController.isKeyDown(ModKeys.SPECIAL_ATTACK_TOOLTIP)) {
                    if (cap.getSpecialAttack(ClientEngine.INSTANCE.getPlayerData()) != null) {
                        event.getToolTip().clear();
                        for (ITextComponent s : cap.getSpecialAttack(ClientEngine.INSTANCE.getPlayerData()).getTooltip()) {
                            event.getToolTip().add(s.func_150254_d());
                        }
                    }
                } else {
                    List tooltip = event.getToolTip();
                    ClientPlayerData entityCap = (ClientPlayerData)event.getEntityPlayer().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
                    cap.modifyItemTooltip(event.getToolTip(), entityCap);
                    double weaponSpeed = entityCap.getAttribute(SharedMonsterAttributes.field_188790_f).func_111125_b();
                    for (AttributeModifier modifier : event.getItemStack().func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)SharedMonsterAttributes.field_188790_f.func_111108_a())) {
                        weaponSpeed += modifier.func_111164_d();
                    }
                    double attackSpeedPanelty = Formulars.getAttackSpeedPenalty(entityCap.getWeight(), weaponSpeed, entityCap);
                    tooltip.add(new TextComponentTranslation("item.tooltip.weight_penalty", new Object[]{ItemStack.field_111284_a.format(attackSpeedPanelty)}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)).func_150254_d());
                }
            }
        }

        @SubscribeEvent
        public static void cameraSetupEvent(EntityViewRenderEvent.CameraSetup event) {
            Events.renderEngine.updateCameraInfo(Minecraft.func_71410_x().field_71474_y.field_74320_O, event.getRenderPartialTicks());
            if (renderEngine.zoomCount > 0) {
                if (renderEngine.zoomOutTimer > 0) {
                    renderEngine.zoomOutTimer--;
                } else {
                    renderEngine.zoomCount = renderEngine.aiming ? renderEngine.zoomCount + 1 : renderEngine.zoomCount - 1;
                }
                renderEngine.zoomCount = Math.min(renderEngine.zoomMaxCount, renderEngine.zoomCount);
            }
        }

        @SubscribeEvent
        public static void fogEvent(EntityViewRenderEvent.RenderFogEvent event) {
        }

        @SubscribeEvent
        public static void renderGameOverlay(RenderGameOverlayEvent.Pre event) {
            ClientPlayerData playerdata;
            if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR && (playerdata = ClientEngine.INSTANCE.getPlayerData()) != null && Minecraft.func_71382_s()) {
                Events.renderEngine.guiSkillBar.renderGui(playerdata, event.getPartialTicks());
            }
        }

        @SubscribeEvent
        public static void renderHand(RenderSpecificHandEvent event) {
            if (ClientEngine.INSTANCE.isBattleMode()) {
                if (event.getHand() == EnumHand.MAIN_HAND) {
                    renderEngine.firstPersonRenderer.render(Minecraft.func_71410_x().field_71439_g, ClientEngine.INSTANCE.getPlayerData(), null, event.getPartialTicks());
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void renderWorldLast(RenderWorldLastEvent event) {
            if (renderEngine.zoomCount > 0 && ((RenderEngine)Events.renderEngine).minecraft.field_71474_y.field_74320_O == 1) {
                Events.renderEngine.aimHelper.doRender(event.getPartialTicks());
            }
        }
    }
}

