/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.client.gui;

import java.util.HashMap;
import java.util.Map;
import maninthehouse.epicfight.capabilities.item.CapabilityItem;
import maninthehouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninthehouse.epicfight.client.gui.EntityIndicator;
import maninthehouse.epicfight.client.gui.ModIngameGui;
import maninthehouse.epicfight.skill.Skill;
import maninthehouse.epicfight.skill.SkillContainer;
import maninthehouse.epicfight.skill.SkillSlot;
import maninthehouse.epicfight.utils.math.Vec2f;
import maninthehouse.epicfight.utils.math.Vec3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class BattleModeGui
extends ModIngameGui {
    private final Map<SkillSlot, Vec3f> screenPositionMap = new HashMap<SkillSlot, Vec3f>();
    private int guiSlider = 29;
    private boolean guiSliderToggle = false;
    protected FontRenderer font;
    private static final Vec2f[] vectorz = new Vec2f[]{new Vec2f(0.5f, 0.5f), new Vec2f(0.5f, 0.0f), new Vec2f(0.0f, 0.0f), new Vec2f(0.0f, 1.0f), new Vec2f(1.0f, 1.0f), new Vec2f(1.0f, 0.0f)};

    public BattleModeGui() {
        this.screenPositionMap.put(SkillSlot.DODGE, new Vec3f(74.0f, 36.0f, 0.078f));
        this.screenPositionMap.put(SkillSlot.WEAPON_SPECIAL_ATTACK, new Vec3f(42.0f, 48.0f, 0.117f));
        this.font = Minecraft.func_71410_x().field_71466_p;
    }

    public void renderGui(ClientPlayerData playerdata, float partialTicks) {
        if (((EntityPlayerSP)playerdata.getOriginalEntity()).func_184187_bx() != null) {
            return;
        }
        if (this.guiSlider > 28) {
            return;
        }
        if (this.guiSlider > 0) {
            this.guiSlider = this.guiSliderToggle ? (this.guiSlider -= 2) : (this.guiSlider += 2);
        }
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        int width = sr.func_78326_a();
        int height = sr.func_78328_b();
        boolean depthTestEnabled = GL11.glGetBoolean((int)2929);
        boolean alphaTestEnabled = GL11.glGetBoolean((int)3008);
        boolean blendEnabled = GL11.glGetBoolean((int)3042);
        if (!depthTestEnabled) {
            GlStateManager.func_179126_j();
        }
        if (!alphaTestEnabled) {
            GL11.glEnable((int)3008);
        }
        if (!blendEnabled) {
            GlStateManager.func_179147_l();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(EntityIndicator.BATTLE_ICON);
        float maxStunArmor = playerdata.getMaxStunArmor();
        float stunArmor = playerdata.getStunArmor();
        if (maxStunArmor > 0.0f && stunArmor < maxStunArmor) {
            float ratio = stunArmor / maxStunArmor;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)((float)this.guiSlider * 0.5f), (float)0.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)ratio, (float)0.25f, (float)1.0f);
            BattleModeGui.func_146110_a((int)((int)((float)(width - 120) * 2.0f)), (int)((int)((float)(height - 10) * 2.0f)), (float)2.0f, (float)38.0f, (int)237, (int)9, (float)255.0f, (float)255.0f);
            BattleModeGui.func_146110_a((int)((int)((float)(width - 120) * 2.0f)), (int)((int)((float)(height - 10) * 2.0f)), (float)2.0f, (float)47.0f, (int)((int)(237.0f * ratio)), (int)9, (float)255.0f, (float)255.0f);
            GlStateManager.func_179121_F();
        }
        for (int i = 0; i < SkillSlot.values().length; ++i) {
            SkillContainer container = playerdata.getSkill(i);
            if (container == null || container.isEmpty() || !this.screenPositionMap.containsKey((Object)container.getContaining().getSlot())) continue;
            SkillSlot slot = container.getContaining().getSlot();
            boolean creative = ((EntityPlayerSP)playerdata.getOriginalEntity()).func_184812_l_();
            float cooldownRatio = creative ? 1.0f : container.getCooldownRatio(partialTicks);
            float durationRatio = container.getDurationRatio(partialTicks);
            boolean isReady = container.getStack() > 0 || durationRatio > 0.0f || creative;
            boolean fullstack = container.getStack() >= container.getContaining().getMaxStack();
            int x = (int)this.screenPositionMap.get((Object)((Object)slot)).x;
            int y = (int)this.screenPositionMap.get((Object)((Object)slot)).y;
            float scale = this.screenPositionMap.get((Object)((Object)slot)).z;
            float multiplyScale = 1.0f / scale;
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)((float)this.guiSlider * multiplyScale), (float)0.0f);
            if (!isReady) {
                GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)0.8f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (slot != SkillSlot.WEAPON_SPECIAL_ATTACK) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getSkillTexture(container.getContaining()));
                this.drawTexturedModalRectFixCoord((float)(width - x) * multiplyScale, (float)(height - y) * multiplyScale, 0, 0, 255, 255);
                if (!fullstack && !creative) {
                    GlStateManager.func_179152_a((float)multiplyScale, (float)multiplyScale, (float)1.0f);
                    this.font.func_175063_a(String.valueOf((int)(1.0f + container.getCooldownSec() * Math.max(1.0f / container.getContaining().getRegenTimePerTick(playerdata), 1.0f))), (float)width - (float)x + 8.0f, (float)height - (float)y + 8.0f, 0xFFFFFF);
                    GL11.glEnable((int)3008);
                    GlStateManager.func_179147_l();
                }
            } else {
                int j;
                CapabilityItem item = playerdata.getHeldItemCapability(EnumHand.MAIN_HAND);
                boolean isCompatibleWeapon = item != null && item.getSpecialAttack(playerdata) == container.getContaining();
                int vertexNum = 0;
                float iconSize = 32.0f;
                float iconSizeDiv = iconSize * 0.5f;
                float top = y;
                float bottom = (float)y - iconSize;
                float left = x;
                float right = (float)x - iconSize;
                float middle = (float)x - iconSizeDiv;
                float lastVertexX = 0.0f;
                float lastVertexY = 0.0f;
                float lastTexX = 0.0f;
                float lastTexY = 0.0f;
                if (cooldownRatio < 0.125f) {
                    vertexNum = 6;
                    lastTexX = cooldownRatio / 0.25f;
                    lastTexY = 0.0f;
                    lastVertexX = middle - iconSize * lastTexX;
                    lastVertexY = top;
                    lastTexX += 0.5f;
                } else if (cooldownRatio < 0.375f) {
                    vertexNum = 5;
                    lastTexX = 1.0f;
                    lastTexY = (cooldownRatio - 0.125f) / 0.25f;
                    lastVertexX = right;
                    lastVertexY = top - iconSize * lastTexY;
                } else if (cooldownRatio < 0.625f) {
                    vertexNum = 4;
                    lastTexX = (cooldownRatio - 0.375f) / 0.25f;
                    lastTexY = 1.0f;
                    lastVertexX = right + iconSize * lastTexX;
                    lastVertexY = bottom;
                    lastTexX = 1.0f - lastTexX;
                } else if (cooldownRatio < 0.875f) {
                    vertexNum = 3;
                    lastTexX = 0.0f;
                    lastTexY = (cooldownRatio - 0.625f) / 0.25f;
                    lastVertexX = left;
                    lastVertexY = bottom + iconSize * lastTexY;
                    lastTexY = 1.0f - lastTexY;
                } else {
                    vertexNum = 2;
                    lastTexX = (cooldownRatio - 0.875f) / 0.25f;
                    lastTexY = 0.0f;
                    lastVertexX = left - iconSize * lastTexX;
                    lastVertexY = top;
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getSkillTexture(container.getContaining()));
                if (isCompatibleWeapon) {
                    GlStateManager.func_179131_c((float)0.0f, (float)0.5f, (float)0.5f, (float)0.6f);
                } else {
                    GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)0.6f);
                }
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(9, DefaultVertexFormats.field_181707_g);
                for (j = 0; j < vertexNum; ++j) {
                    bufferbuilder.func_181662_b((double)(((float)width - (left - iconSize * BattleModeGui.vectorz[j].x)) * multiplyScale), (double)(((float)height - (top - iconSize * BattleModeGui.vectorz[j].y)) * multiplyScale), 0.0).func_187315_a((double)BattleModeGui.vectorz[j].x, (double)BattleModeGui.vectorz[j].y).func_181675_d();
                }
                bufferbuilder.func_181662_b((double)(((float)width - lastVertexX) * multiplyScale), (double)(((float)height - lastVertexY) * multiplyScale), 0.0).func_187315_a((double)lastTexX, (double)lastTexY).func_181675_d();
                tessellator.func_78381_a();
                if (isCompatibleWeapon) {
                    GlStateManager.func_179131_c((float)0.2f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                GlStateManager.func_179129_p();
                bufferbuilder.func_181668_a(9, DefaultVertexFormats.field_181707_g);
                for (j = 0; j < 2; ++j) {
                    bufferbuilder.func_181662_b((double)(((float)width - (left - iconSize * BattleModeGui.vectorz[j].x)) * multiplyScale), (double)(((float)height - (top - iconSize * BattleModeGui.vectorz[j].y)) * multiplyScale), 0.0).func_187315_a((double)BattleModeGui.vectorz[j].x, (double)BattleModeGui.vectorz[j].y).func_181675_d();
                }
                for (j = vectorz.length - 1; j >= vertexNum; --j) {
                    bufferbuilder.func_181662_b((double)(((float)width - (left - iconSize * BattleModeGui.vectorz[j].x)) * multiplyScale), (double)(((float)height - (top - iconSize * BattleModeGui.vectorz[j].y)) * multiplyScale), 0.0).func_187315_a((double)BattleModeGui.vectorz[j].x, (double)BattleModeGui.vectorz[j].y).func_181675_d();
                }
                bufferbuilder.func_181662_b((double)(((float)width - lastVertexX) * multiplyScale), (double)(((float)height - lastVertexY) * multiplyScale), 0.0).func_187315_a((double)lastTexX, (double)lastTexY).func_181675_d();
                tessellator.func_78381_a();
                if (!isReady) {
                    GlStateManager.func_179152_a((float)multiplyScale, (float)multiplyScale, (float)1.0f);
                    String s = String.valueOf((int)(cooldownRatio * 100.0f));
                    int stringWidth = (this.font.func_78256_a(s) - 6) / 3;
                    this.font.func_175063_a(s, (float)width - (float)x + 13.0f - (float)stringWidth, (float)height - (float)y + 13.0f, 0xFFFFFF);
                    GL11.glEnable((int)3008);
                    GlStateManager.func_179147_l();
                }
            }
            GlStateManager.func_179121_F();
        }
        if (!depthTestEnabled) {
            GlStateManager.func_179097_i();
        }
        if (!alphaTestEnabled) {
            GL11.glDisable((int)3008);
        }
        if (!blendEnabled) {
            GlStateManager.func_179084_k();
        }
    }

    private ResourceLocation getSkillTexture(Skill skill) {
        ResourceLocation name = skill.getRegistryName();
        return new ResourceLocation(name.func_110624_b(), "textures/gui/skills/" + name.func_110623_a() + ".png");
    }

    public void slideUp() {
        this.guiSlider = 28;
        this.guiSliderToggle = true;
    }

    public void slideDown() {
        this.guiSlider = 1;
        this.guiSliderToggle = false;
    }
}

