/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.client.model.custom;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import maninthehouse.epicfight.client.model.ClientModel;
import maninthehouse.epicfight.client.model.Mesh;
import maninthehouse.epicfight.collada.VertexData;
import maninthehouse.epicfight.utils.math.Vec2f;
import maninthehouse.epicfight.utils.math.Vec3f;
import maninthehouse.epicfight.utils.math.Vec4f;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

@SideOnly(value=Side.CLIENT)
public class CustomModelBakery {
    static int indexCount = 0;
    static final ModelPart HEAD = new SimplePart(9);
    static final ModelPart LEFT_FEET = new SimplePart(5);
    static final ModelPart RIGHT_FEET = new SimplePart(2);
    static final ModelPart LEFT_ARM = new Limb(16, 17, 19, 19.0f, false);
    static final ModelPart RIGHT_ARM = new Limb(11, 12, 14, 19.0f, false);
    static final ModelPart LEFT_LEG = new Limb(4, 5, 6, 6.0f, true);
    static final ModelPart RIGHT_LEG = new Limb(1, 2, 3, 6.0f, true);
    static final ModelPart CHEST = new Chest();

    public static ClientModel bakeBipedCustomArmorModel(ModelBiped model, ItemArmor armorItem) {
        EntityEquipmentSlot equipmentSlot = armorItem.func_185083_B_();
        ArrayList allBoxes = Lists.newArrayList();
        model.field_78116_c.func_78793_a(0.0f, 0.0f, 0.0f);
        CustomModelBakery.resetRotation(model.field_78116_c);
        model.field_178720_f.func_78793_a(0.0f, 0.0f, 0.0f);
        CustomModelBakery.resetRotation(model.field_178720_f);
        model.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
        CustomModelBakery.resetRotation(model.field_78115_e);
        model.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
        CustomModelBakery.resetRotation(model.field_178723_h);
        model.field_178724_i.field_78809_i = true;
        model.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
        CustomModelBakery.resetRotation(model.field_178724_i);
        model.field_178721_j.func_78793_a(-1.9f, 12.0f, 0.0f);
        CustomModelBakery.resetRotation(model.field_178721_j);
        model.field_178722_k.field_78809_i = true;
        model.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
        CustomModelBakery.resetRotation(model.field_178722_k);
        switch (equipmentSlot) {
            case HEAD: {
                allBoxes.add(new ModelPartBind(HEAD, model.field_78116_c));
                allBoxes.add(new ModelPartBind(HEAD, model.field_178720_f));
                break;
            }
            case CHEST: {
                allBoxes.add(new ModelPartBind(CHEST, model.field_78115_e));
                allBoxes.add(new ModelPartBind(RIGHT_ARM, model.field_178723_h));
                allBoxes.add(new ModelPartBind(LEFT_ARM, model.field_178724_i));
                break;
            }
            case LEGS: {
                allBoxes.add(new ModelPartBind(CHEST, model.field_78115_e));
                allBoxes.add(new ModelPartBind(LEFT_LEG, model.field_178722_k));
                allBoxes.add(new ModelPartBind(RIGHT_LEG, model.field_178721_j));
                break;
            }
            case FEET: {
                allBoxes.add(new ModelPartBind(LEFT_LEG, model.field_178722_k));
                allBoxes.add(new ModelPartBind(RIGHT_LEG, model.field_178721_j));
                break;
            }
            default: {
                return null;
            }
        }
        ClientModel customModel = new ClientModel(CustomModelBakery.bakeMeshFromCubes(allBoxes));
        return customModel;
    }

    private static Mesh bakeMeshFromCubes(List<ModelPartBind> cubes) {
        ArrayList vertices = Lists.newArrayList();
        ArrayList indices = Lists.newArrayList();
        VisibleMatrix4f matrix4f = new VisibleMatrix4f();
        indexCount = 0;
        matrix4f.rotateDegree(180.0f, new Vec3f(0.0f, 1.0f, 0.0f));
        matrix4f.rotateDegree(180.0f, new Vec3f(1.0f, 0.0f, 0.0f));
        matrix4f.translate(0.0f, -24.0f, 0.0f);
        for (ModelPartBind modelPart : cubes) {
            CustomModelBakery.bake(matrix4f, modelPart.partedBaker, modelPart.modelRenderer, vertices, indices);
        }
        return VertexData.loadVertexInformation(vertices, ArrayUtils.toPrimitive((Integer[])indices.toArray(new Integer[0])), true);
    }

    private static void bake(VisibleMatrix4f matrix, ModelPart part, ModelRenderer renderer, List<VertexData> vertices, List<Integer> indices) {
        VisibleMatrix4f internalMatrix = new VisibleMatrix4f(matrix);
        internalMatrix.translate(renderer.field_78800_c, renderer.field_78797_d, renderer.field_78798_e);
        if (renderer.field_78808_h != 0.0f) {
            internalMatrix.rotateDegree(renderer.field_78808_h, new Vec3f(0.0f, 0.0f, 1.0f));
        }
        if (renderer.field_78796_g != 0.0f) {
            internalMatrix.rotateDegree(renderer.field_78796_g, new Vec3f(0.0f, 1.0f, 0.0f));
        }
        if (renderer.field_78795_f != 0.0f) {
            internalMatrix.rotateDegree(renderer.field_78795_f, new Vec3f(1.0f, 0.0f, 0.0f));
        }
        for (ModelBox cube : renderer.field_78804_l) {
            part.bakeCube(internalMatrix, cube, vertices, indices);
        }
        if (renderer.field_78805_m != null) {
            for (ModelRenderer childRenderer : renderer.field_78805_m) {
                CustomModelBakery.bake(internalMatrix, part, childRenderer, vertices, indices);
            }
        }
    }

    static void resetRotation(ModelRenderer modelRenderer) {
        modelRenderer.field_78795_f = 0.0f;
        modelRenderer.field_78796_g = 0.0f;
        modelRenderer.field_78808_h = 0.0f;
    }

    static EnumFacing getDirectionFromVector(Vec3i directionVec) {
        for (EnumFacing direction : EnumFacing.values()) {
            Vec3i direcVec = new Vec3i(Float.compare(directionVec.func_177958_n(), -0.0f) == 0 ? 0.0 : (double)directionVec.func_177958_n(), (double)directionVec.func_177956_o(), (double)directionVec.func_177952_p());
            if (!direcVec.equals((Object)direction.func_176730_m())) continue;
            return direction;
        }
        return null;
    }

    static PositionTextureVertex getTranslatedVertex(PositionTextureVertex original, VisibleMatrix4f matrix) {
        Vec4f translatedPosition = new Vec4f(original.field_78243_a);
        VisibleMatrix4f.transform(matrix, translatedPosition, translatedPosition);
        return new PositionTextureVertex(translatedPosition.x, translatedPosition.y, translatedPosition.z, original.field_78241_b, original.field_78242_c);
    }

    static Vec3f getNormalFrom(TexturedQuad quad, VisibleMatrix4f matrix) {
        Vec3d vec3d = quad.field_78239_a[1].field_78243_a.func_72444_a(quad.field_78239_a[0].field_78243_a);
        Vec3d vec3d1 = quad.field_78239_a[1].field_78243_a.func_72444_a(quad.field_78239_a[2].field_78243_a);
        Vec3d vec3d2 = vec3d1.func_72431_c(vec3d).func_72432_b();
        Vec4f norm = new Vec4f(vec3d2);
        VisibleMatrix4f.transform(matrix, norm, norm);
        return new Vec3f(norm.x, norm.y, norm.z);
    }

    @SideOnly(value=Side.CLIENT)
    static class TexturedJointQuad {
        public final PositionTextureJointVertex[] animatedVertexPositions;
        public final Vec3f normal;

        public TexturedJointQuad(PositionTextureJointVertex[] positionsIn, Vec3f normal) {
            this.animatedVertexPositions = positionsIn;
            this.normal = normal;
        }

        public TexturedJointQuad(PositionTextureJointVertex[] positionsIn, float cor, Vec3f normal) {
            this.animatedVertexPositions = positionsIn;
            positionsIn[0] = new PositionTextureJointVertex(positionsIn[0].func_78240_a(positionsIn[0].field_78241_b, positionsIn[0].field_78242_c + cor), positionsIn[0].jointId, positionsIn[0].weight);
            positionsIn[1] = new PositionTextureJointVertex(positionsIn[1].func_78240_a(positionsIn[1].field_78241_b, positionsIn[1].field_78242_c + cor), positionsIn[1].jointId, positionsIn[1].weight);
            positionsIn[2] = new PositionTextureJointVertex(positionsIn[2].func_78240_a(positionsIn[2].field_78241_b, positionsIn[2].field_78242_c - cor), positionsIn[2].jointId, positionsIn[2].weight);
            positionsIn[3] = new PositionTextureJointVertex(positionsIn[3].func_78240_a(positionsIn[3].field_78241_b, positionsIn[3].field_78242_c - cor), positionsIn[3].jointId, positionsIn[3].weight);
            this.normal = normal;
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class PositionTextureJointVertex
    extends PositionTextureVertex {
        final Vec3i jointId;
        final Vec3f weight;

        public PositionTextureJointVertex(PositionTextureVertex posTexVertx, int jointId) {
            this(posTexVertx, jointId, 0, 0, 1.0f, 0.0f, 0.0f);
        }

        public PositionTextureJointVertex(PositionTextureVertex posTexVertx, int jointId1, int jointId2, int jointId3, float weight1, float weight2, float weight3) {
            this(posTexVertx, new Vec3i(jointId1, jointId2, jointId3), new Vec3f(weight1, weight2, weight3));
        }

        public PositionTextureJointVertex(PositionTextureVertex posTexVertx, Vec3i ids, Vec3f weights) {
            super(posTexVertx.field_78243_a, posTexVertx.field_78241_b, posTexVertx.field_78242_c);
            this.jointId = ids;
            this.weight = weights;
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class Limb
    extends ModelPart {
        final int upperJointId;
        final int lowerJointId;
        final int middleJointId;
        final float cutY;
        final boolean frontOrBack;

        public Limb(int upperJointId, int lowerJointId, int middleJointId, float cutY, boolean frontOrBack) {
            this.upperJointId = upperJointId;
            this.lowerJointId = lowerJointId;
            this.middleJointId = middleJointId;
            this.cutY = cutY;
            this.frontOrBack = frontOrBack;
        }

        @Override
        public void bakeCube(VisibleMatrix4f matrixStack, ModelBox cube, List<VertexData> vertices, List<Integer> indices) {
            ArrayList quads = Lists.newArrayList();
            for (TexturedQuad quad : cube.field_78254_i) {
                PositionTextureVertex pos0 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[0], matrixStack);
                PositionTextureVertex pos1 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[1], matrixStack);
                PositionTextureVertex pos2 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[2], matrixStack);
                PositionTextureVertex pos3 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[3], matrixStack);
                Vec3f normal = CustomModelBakery.getNormalFrom(quad, matrixStack);
                if (pos1.field_78243_a.field_72448_b > (double)this.cutY != pos2.field_78243_a.field_72448_b > (double)this.cutY) {
                    boolean isFront;
                    boolean hasSameZ;
                    int lowerId;
                    int upperId;
                    float distance = (float)(pos2.field_78243_a.field_72448_b - pos1.field_78243_a.field_72448_b);
                    float textureV = pos1.field_78242_c + (pos2.field_78242_c - pos1.field_78242_c) * ((float)((double)this.cutY - pos1.field_78243_a.field_72448_b) / distance);
                    PositionTextureVertex pos4 = new PositionTextureVertex((float)pos0.field_78243_a.field_72450_a, this.cutY, (float)pos0.field_78243_a.field_72449_c, pos0.field_78241_b, textureV);
                    PositionTextureVertex pos5 = new PositionTextureVertex((float)pos1.field_78243_a.field_72450_a, this.cutY, (float)pos1.field_78243_a.field_72449_c, pos1.field_78241_b, textureV);
                    if (distance > 0.0f) {
                        upperId = this.lowerJointId;
                        lowerId = this.upperJointId;
                    } else {
                        upperId = this.upperJointId;
                        lowerId = this.lowerJointId;
                    }
                    quads.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos0, upperId), new PositionTextureJointVertex(pos1, upperId), new PositionTextureJointVertex(pos5, upperId), new PositionTextureJointVertex(pos4, upperId)}, normal));
                    quads.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos4, lowerId), new PositionTextureJointVertex(pos5, lowerId), new PositionTextureJointVertex(pos2, lowerId), new PositionTextureJointVertex(pos3, lowerId)}, normal));
                    boolean bl = hasSameZ = pos4.field_78243_a.field_72449_c < 0.0 == pos5.field_78243_a.field_72449_c < 0.0;
                    boolean bl2 = hasSameZ && pos4.field_78243_a.field_72449_c < 0.0 == this.frontOrBack ? true : (isFront = false);
                    if (isFront) {
                        quads.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos4, this.middleJointId), new PositionTextureJointVertex(pos5, this.middleJointId), new PositionTextureJointVertex(pos5, this.upperJointId), new PositionTextureJointVertex(pos4, this.upperJointId)}, 0.001f, normal));
                        quads.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos4, this.lowerJointId), new PositionTextureJointVertex(pos5, this.lowerJointId), new PositionTextureJointVertex(pos5, this.middleJointId), new PositionTextureJointVertex(pos4, this.middleJointId)}, 0.001f, normal));
                        continue;
                    }
                    if (hasSameZ) continue;
                    boolean startFront = pos4.field_78243_a.field_72449_c > 0.0;
                    int firstJoint = this.lowerJointId;
                    int secondJoint = this.lowerJointId;
                    int thirdJoint = startFront ? this.upperJointId : this.middleJointId;
                    int fourthJoint = startFront ? this.middleJointId : this.upperJointId;
                    int fifthJoint = this.upperJointId;
                    int sixthJoint = this.upperJointId;
                    quads.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos4, firstJoint), new PositionTextureJointVertex(pos5, secondJoint), new PositionTextureJointVertex(pos5, thirdJoint), new PositionTextureJointVertex(pos4, fourthJoint)}, 0.001f, normal));
                    quads.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos4, fourthJoint), new PositionTextureJointVertex(pos5, thirdJoint), new PositionTextureJointVertex(pos5, fifthJoint), new PositionTextureJointVertex(pos4, sixthJoint)}, 0.001f, normal));
                    continue;
                }
                int jointId = pos0.field_78243_a.field_72448_b > (double)this.cutY ? this.upperJointId : this.lowerJointId;
                quads.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos0, jointId), new PositionTextureJointVertex(pos1, jointId), new PositionTextureJointVertex(pos2, jointId), new PositionTextureJointVertex(pos3, jointId)}, normal));
            }
            for (TexturedJointQuad quad : quads) {
                Vec3f norm = quad.normal;
                for (PositionTextureJointVertex vertex : quad.animatedVertexPositions) {
                    Vec4f pos = new Vec4f(vertex.field_78243_a);
                    vertices.add(new VertexData().setPosition(new Vec3f(pos.x, pos.y, pos.z).scale(0.0625f)).setNormal(new Vec3f(norm.x, norm.y, norm.z)).setTextureCoordinate(new Vec2f(vertex.field_78241_b, vertex.field_78242_c)).setEffectiveJointIDs(new Vec3f(vertex.jointId.func_177958_n(), 0.0f, 0.0f)).setEffectiveJointWeights(new Vec3f(1.0f, 0.0f, 0.0f)).setEffectiveJointNumber(1));
                }
                indices.add(indexCount);
                indices.add(indexCount + 1);
                indices.add(indexCount + 3);
                indices.add(indexCount + 3);
                indices.add(indexCount + 1);
                indices.add(indexCount + 2);
                indexCount += 4;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class Chest
    extends ModelPart {
        final float cutX = 0.0f;
        final WeightPair[] cutYList = new WeightPair[]{new WeightPair(13.6666f, 0.254f, 0.746f), new WeightPair(15.8333f, 0.254f, 0.746f), new WeightPair(18.0f, 0.5f, 0.5f), new WeightPair(20.1666f, 0.744f, 0.256f), new WeightPair(22.3333f, 0.77f, 0.23f)};

        Chest() {
        }

        @Override
        public void bakeCube(VisibleMatrix4f matrix, ModelBox cube, List<VertexData> vertices, List<Integer> indices) {
            ArrayList seperatedX = Lists.newArrayList();
            ArrayList seperatedXY = Lists.newArrayList();
            for (TexturedQuad quad : cube.field_78254_i) {
                PositionTextureVertex pos0 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[0], matrix);
                PositionTextureVertex pos1 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[1], matrix);
                PositionTextureVertex pos2 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[2], matrix);
                PositionTextureVertex pos3 = CustomModelBakery.getTranslatedVertex(quad.field_78239_a[3], matrix);
                Vec3f normal = CustomModelBakery.getNormalFrom(quad, matrix);
                WeightPair pos0Weight = this.getMatchingWeightPair(pos0.field_78243_a.field_72448_b);
                WeightPair pos1Weight = this.getMatchingWeightPair(pos1.field_78243_a.field_72448_b);
                WeightPair pos2Weight = this.getMatchingWeightPair(pos2.field_78243_a.field_72448_b);
                WeightPair pos3Weight = this.getMatchingWeightPair(pos3.field_78243_a.field_72448_b);
                double d = pos1.field_78243_a.field_72450_a;
                this.getClass();
                boolean bl = d > 0.0;
                double d2 = pos2.field_78243_a.field_72450_a;
                this.getClass();
                if (bl != d2 > 0.0) {
                    float distance = (float)(pos2.field_78243_a.field_72450_a - pos1.field_78243_a.field_72450_a);
                    double d3 = pos1.field_78241_b;
                    double d4 = pos2.field_78241_b - pos1.field_78241_b;
                    this.getClass();
                    float textureU = (float)(d3 + d4 * ((0.0 - pos1.field_78243_a.field_72450_a) / (double)distance));
                    PositionTextureVertex pos4 = new PositionTextureVertex((float)pos0.field_78243_a.field_72450_a, this.cutX, (float)pos0.field_78243_a.field_72449_c, textureU, pos0.field_78242_c);
                    PositionTextureVertex pos5 = new PositionTextureVertex((float)pos1.field_78243_a.field_72450_a, this.cutX, (float)pos1.field_78243_a.field_72449_c, textureU, pos1.field_78242_c);
                    seperatedX.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos0, 8, 7, 0, pos0Weight.weightLower, pos0Weight.weightUpper, 0.0f), new PositionTextureJointVertex(pos4, 8, 7, 0, pos0Weight.weightLower, pos0Weight.weightUpper, 0.0f), new PositionTextureJointVertex(pos5, 8, 7, 0, pos1Weight.weightLower, pos1Weight.weightUpper, 0.0f), new PositionTextureJointVertex(pos3, 8, 7, 0, pos3Weight.weightLower, pos3Weight.weightUpper, 0.0f)}, normal));
                    seperatedX.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos4, 8, 7, 0, pos0Weight.weightLower, pos0Weight.weightUpper, 0.0f), new PositionTextureJointVertex(pos1, 8, 7, 0, pos1Weight.weightLower, pos1Weight.weightUpper, 0.0f), new PositionTextureJointVertex(pos2, 8, 7, 0, pos2Weight.weightLower, pos2Weight.weightUpper, 0.0f), new PositionTextureJointVertex(pos5, 8, 7, 0, pos1Weight.weightLower, pos1Weight.weightUpper, 0.0f)}, normal));
                    continue;
                }
                seperatedX.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(pos0, 8, 7, 0, pos0Weight.weightLower, pos0Weight.weightUpper, 0.0f), new PositionTextureJointVertex(pos1, 8, 7, 0, pos1Weight.weightLower, pos1Weight.weightUpper, 0.0f), new PositionTextureJointVertex(pos2, 8, 7, 0, pos2Weight.weightLower, pos2Weight.weightUpper, 0.0f), new PositionTextureJointVertex(pos3, 8, 7, 0, pos3Weight.weightLower, pos3Weight.weightUpper, 0.0f)}, normal));
            }
            for (TexturedJointQuad quad : seperatedX) {
                boolean upsideDown = quad.animatedVertexPositions[1].field_78243_a.field_72448_b > quad.animatedVertexPositions[2].field_78243_a.field_72448_b;
                PositionTextureJointVertex pos0 = upsideDown ? quad.animatedVertexPositions[2] : quad.animatedVertexPositions[0];
                PositionTextureJointVertex pos1 = upsideDown ? quad.animatedVertexPositions[3] : quad.animatedVertexPositions[1];
                PositionTextureJointVertex pos2 = upsideDown ? quad.animatedVertexPositions[0] : quad.animatedVertexPositions[2];
                PositionTextureJointVertex pos3 = upsideDown ? quad.animatedVertexPositions[1] : quad.animatedVertexPositions[3];
                List<WeightPair> weightPairList = this.getMatchingWeightPairs(pos1.field_78243_a.field_72448_b, pos2.field_78243_a.field_72448_b);
                ArrayList addedVertexList = Lists.newArrayList();
                addedVertexList.add(pos0);
                addedVertexList.add(pos1);
                if (weightPairList.size() > 0) {
                    for (WeightPair weightPair : weightPairList) {
                        float distance = (float)(pos2.field_78243_a.field_72448_b - pos1.field_78243_a.field_72448_b);
                        float textureV = pos1.field_78242_c + (float)((double)(pos2.field_78242_c - pos1.field_78242_c) * (((double)weightPair.cutY - pos1.field_78243_a.field_72448_b) / (double)distance));
                        PositionTextureVertex pos4 = new PositionTextureVertex((float)pos0.field_78243_a.field_72450_a, weightPair.cutY, (float)pos0.field_78243_a.field_72449_c, pos0.field_78241_b, textureV);
                        PositionTextureVertex pos5 = new PositionTextureVertex((float)pos1.field_78243_a.field_72450_a, weightPair.cutY, (float)pos1.field_78243_a.field_72449_c, pos1.field_78241_b, textureV);
                        addedVertexList.add(new PositionTextureJointVertex(pos4, 8, 7, 0, weightPair.weightLower, weightPair.weightUpper, 0.0f));
                        addedVertexList.add(new PositionTextureJointVertex(pos5, 8, 7, 0, weightPair.weightLower, weightPair.weightUpper, 0.0f));
                    }
                }
                addedVertexList.add(pos3);
                addedVertexList.add(pos2);
                for (int i = 0; i < (addedVertexList.size() - 2) / 2; ++i) {
                    int start = i * 2;
                    PositionTextureJointVertex p0 = (PositionTextureJointVertex)((Object)addedVertexList.get(start));
                    PositionTextureJointVertex p1 = (PositionTextureJointVertex)((Object)addedVertexList.get(start + 1));
                    PositionTextureJointVertex p2 = (PositionTextureJointVertex)((Object)addedVertexList.get(start + 3));
                    PositionTextureJointVertex p3 = (PositionTextureJointVertex)((Object)addedVertexList.get(start + 2));
                    seperatedXY.add(new TexturedJointQuad(new PositionTextureJointVertex[]{new PositionTextureJointVertex(p0, 8, 7, 0, p0.weight.x, p0.weight.y, 0.0f), new PositionTextureJointVertex(p1, 8, 7, 0, p1.weight.x, p1.weight.y, 0.0f), new PositionTextureJointVertex(p2, 8, 7, 0, p2.weight.x, p2.weight.y, 0.0f), new PositionTextureJointVertex(p3, 8, 7, 0, p3.weight.x, p3.weight.y, 0.0f)}, quad.normal));
                }
            }
            for (TexturedJointQuad quad : seperatedXY) {
                Vec3f norm = quad.normal;
                for (PositionTextureJointVertex vertex : quad.animatedVertexPositions) {
                    int count;
                    Vec4f pos = new Vec4f(vertex.field_78243_a);
                    float weight1 = vertex.weight.x;
                    float weight2 = vertex.weight.y;
                    int joint1 = vertex.jointId.func_177958_n();
                    int joint2 = vertex.jointId.func_177956_o();
                    int n = count = weight1 > 0.0f && weight2 > 0.0f ? 2 : 1;
                    if (weight1 <= 0.0f) {
                        joint1 = joint2;
                        weight1 = weight2;
                    }
                    vertices.add(new VertexData().setPosition(new Vec3f(pos.x, pos.y, pos.z).scale(0.0625f)).setNormal(new Vec3f(norm.x, norm.y, norm.z)).setTextureCoordinate(new Vec2f(vertex.field_78241_b, vertex.field_78242_c)).setEffectiveJointIDs(new Vec3f(joint1, joint2, 0.0f)).setEffectiveJointWeights(new Vec3f(weight1, weight2, 0.0f)).setEffectiveJointNumber(count));
                }
                indices.add(indexCount);
                indices.add(indexCount + 1);
                indices.add(indexCount + 3);
                indices.add(indexCount + 3);
                indices.add(indexCount + 1);
                indices.add(indexCount + 2);
                indexCount += 4;
            }
        }

        WeightPair getMatchingWeightPair(double y) {
            if (y < (double)this.cutYList[0].cutY) {
                return new WeightPair((float)y, 0.0f, 1.0f);
            }
            int index = -1;
            for (int i = 0; i < this.cutYList.length; ++i) {
            }
            if (index > 0) {
                WeightPair pair = this.cutYList[index];
                return new WeightPair((float)y, pair.weightLower, pair.weightUpper);
            }
            return new WeightPair((float)y, 1.0f, 0.0f);
        }

        List<WeightPair> getMatchingWeightPairs(double minY, double maxY) {
            ArrayList cutYs = Lists.newArrayList();
            for (WeightPair pair : this.cutYList) {
                if (!((double)pair.cutY > minY) || !(maxY >= (double)pair.cutY)) continue;
                cutYs.add(pair);
            }
            return cutYs;
        }

        static class WeightPair {
            final float cutY;
            final float weightLower;
            final float weightUpper;

            public WeightPair(float cutY, float weightLower, float weightUpper) {
                this.cutY = cutY;
                this.weightLower = weightLower;
                this.weightUpper = weightUpper;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class SimplePart
    extends ModelPart {
        final int jointId;

        public SimplePart(int jointId) {
            this.jointId = jointId;
        }

        @Override
        public void bakeCube(VisibleMatrix4f matrix, ModelBox cube, List<VertexData> vertices, List<Integer> indices) {
            for (TexturedQuad quad : cube.field_78254_i) {
                Vec3d vec3d = quad.field_78239_a[1].field_78243_a.func_72444_a(quad.field_78239_a[0].field_78243_a);
                Vec3d vec3d1 = quad.field_78239_a[1].field_78243_a.func_72444_a(quad.field_78239_a[2].field_78243_a);
                Vec3d vec3d2 = vec3d1.func_72431_c(vec3d).func_72432_b();
                Vec4f norm = new Vec4f(vec3d2);
                VisibleMatrix4f.transform(matrix, norm, norm);
                for (PositionTextureVertex vertex : quad.field_78239_a) {
                    Vec4f pos = new Vec4f(vertex.field_78243_a);
                    VisibleMatrix4f.transform(matrix, pos, pos);
                    vertices.add(new VertexData().setPosition(new Vec3f(pos.x, pos.y, pos.z).scale(0.0625f)).setNormal(new Vec3f(norm.x, norm.y, norm.z)).setTextureCoordinate(new Vec2f(vertex.field_78241_b, vertex.field_78242_c)).setEffectiveJointIDs(new Vec3f(this.jointId, 0.0f, 0.0f)).setEffectiveJointWeights(new Vec3f(1.0f, 0.0f, 0.0f)).setEffectiveJointNumber(1));
                }
                indices.add(indexCount);
                indices.add(indexCount + 1);
                indices.add(indexCount + 3);
                indices.add(indexCount + 3);
                indices.add(indexCount + 1);
                indices.add(indexCount + 2);
                indexCount += 4;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static abstract class ModelPart {
        ModelPart() {
        }

        public abstract void bakeCube(VisibleMatrix4f var1, ModelBox var2, List<VertexData> var3, List<Integer> var4);
    }

    @SideOnly(value=Side.CLIENT)
    static class ModelPartBind {
        ModelRenderer modelRenderer;
        ModelPart partedBaker;

        public ModelPartBind(ModelPart partedBaker, ModelRenderer modelRenderer) {
            this.partedBaker = partedBaker;
            this.modelRenderer = modelRenderer;
        }
    }
}

