/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.client.renderer;

import maninthehouse.epicfight.animation.types.ActionAnimation;
import maninthehouse.epicfight.animation.types.AimingAnimation;
import maninthehouse.epicfight.animation.types.DynamicAnimation;
import maninthehouse.epicfight.client.capabilites.entity.ClientPlayerData;
import maninthehouse.epicfight.client.model.ClientModel;
import maninthehouse.epicfight.client.model.ClientModels;
import maninthehouse.epicfight.client.renderer.entity.ArmatureRenderer;
import maninthehouse.epicfight.client.renderer.layer.HeldItemLayer;
import maninthehouse.epicfight.client.renderer.layer.WearableItemLayer;
import maninthehouse.epicfight.model.Armature;
import maninthehouse.epicfight.utils.math.Vec4f;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FirstPersonRenderer
extends ArmatureRenderer<EntityPlayerSP, ClientPlayerData> {
    public FirstPersonRenderer() {
        this.layers.add(new HeldItemLayer());
        this.layers.add(new WearableItemLayer(EntityEquipmentSlot.CHEST));
        this.layers.add(new WearableItemLayer(EntityEquipmentSlot.LEGS));
        this.layers.add(new WearableItemLayer(EntityEquipmentSlot.FEET));
    }

    public void render(EntityPlayerSP entityIn, ClientPlayerData entitydata, RenderLivingBase<? extends Entity> renderer, float partialTicks) {
        double x = 0.0;
        double y = -entityIn.func_70047_e();
        double z = 0.0;
        ClientModel model = entitydata.getEntityModel(ClientModels.LOGICAL_CLIENT);
        Armature armature = model.getArmature();
        armature.initializeTransform();
        entitydata.getClientAnimator().setPoseToModel(partialTicks);
        VisibleMatrix4f[] poses = armature.getJointTransforms();
        GlStateManager.func_179094_E();
        Vec4f headPos = new Vec4f(0.0f, entityIn.func_70047_e(), 0.0f, 1.0f);
        VisibleMatrix4f.transform(poses[9], headPos, headPos);
        float pitch = entityIn.field_70125_A;
        DynamicAnimation base = entitydata.getClientAnimator().getPlayer().getPlay();
        DynamicAnimation mix = entitydata.getClientAnimator().mixLayer.animationPlayer.getPlay();
        boolean flag1 = base instanceof ActionAnimation;
        boolean flag2 = mix instanceof AimingAnimation;
        float zCoord = flag1 ? 0.0f : poses[0].m32;
        float posZ = Math.min(headPos.z - zCoord, 0.0f);
        if (headPos.z > poses[0].m32) {
            posZ += poses[0].m32 - headPos.z;
        }
        if (!flag2) {
            GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        float interpolation = pitch > 0.0f ? pitch / 90.0f : 0.0f;
        GlStateManager.func_179137_b((double)x, (double)(y - 0.1 - 0.2 * (flag2 ? 0.8 : (double)interpolation)), (double)(z + 0.1 + 0.7 * (flag2 ? 0.0 : (double)interpolation) - (double)posZ));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(((EntityPlayerSP)entitydata.getOriginalEntity()).func_110306_p());
        RenderHelper.func_74519_b();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
        int i = entityIn.func_70070_b();
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        ClientModels.LOGICAL_CLIENT.ENTITY_BIPED_FIRST_PERSON.draw(poses);
        if (!entityIn.func_175149_v()) {
            this.renderLayer(entitydata, entityIn, poses, partialTicks);
        }
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GlStateManager.func_179121_F();
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityPlayerSP entityIn) {
        return entityIn.func_110306_p();
    }
}

