/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.client.renderer.entity;

import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.client.renderer.entity.ArmatureRenderer;
import maninthehouse.epicfight.client.renderer.layer.HeldItemLayer;
import maninthehouse.epicfight.client.renderer.layer.WearableItemLayer;
import maninthehouse.epicfight.model.Armature;
import maninthehouse.epicfight.utils.math.Vec3f;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class BipedRenderer<E extends EntityLivingBase, T extends LivingData<E>>
extends ArmatureRenderer<E, T> {
    public BipedRenderer() {
        this.layers.add(new HeldItemLayer());
        this.layers.add(new WearableItemLayer(EntityEquipmentSlot.HEAD));
        this.layers.add(new WearableItemLayer(EntityEquipmentSlot.CHEST));
        this.layers.add(new WearableItemLayer(EntityEquipmentSlot.LEGS));
        this.layers.add(new WearableItemLayer(EntityEquipmentSlot.FEET));
    }

    @Override
    protected void applyRotations(Armature armature, E entityIn, T entitydata, double x, double y, double z, float partialTicks) {
        super.applyRotations(armature, entityIn, entitydata, x, y, z, partialTicks);
        if (entityIn.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.15f, (float)0.0f);
        }
        if (entityIn.func_70631_g_()) {
            this.transformJoint(9, armature, new VisibleMatrix4f().scale(new Vec3f(1.25f, 1.25f, 1.25f)));
        }
        this.transformJoint(9, armature, ((LivingData)entitydata).getHeadMatrix(partialTicks));
    }
}

