/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.client.renderer.item;

import java.nio.FloatBuffer;
import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.client.events.engine.RenderEngine;
import maninthehouse.epicfight.client.model.ClientModels;
import maninthehouse.epicfight.utils.math.Vec3f;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderItemBase {
    protected VisibleMatrix4f correctionMatrix = new VisibleMatrix4f();
    protected static final VisibleMatrix4f BACK_COORECTION = new VisibleMatrix4f();
    public static RenderEngine renderEngine;

    public RenderItemBase() {
        VisibleMatrix4f.rotate((float)Math.toRadians(-80.0), new Vec3f(1.0f, 0.0f, 0.0f), this.correctionMatrix, this.correctionMatrix);
        VisibleMatrix4f.translate(new Vec3f(0.0f, 0.1f, 0.0f), this.correctionMatrix, this.correctionMatrix);
    }

    public void renderItemInHand(ItemStack stack, LivingData<?> itemHolder, EnumHand hand) {
        VisibleMatrix4f modelMatrix = this.getCorrectionMatrix(stack, itemHolder, hand);
        String heldingHand = hand == EnumHand.MAIN_HAND ? "Tool_R" : "Tool_L";
        VisibleMatrix4f jointTransform = itemHolder.getEntityModel(ClientModels.LOGICAL_CLIENT).getArmature().findJointByName(heldingHand).getAnimatedTransform();
        VisibleMatrix4f.mul(jointTransform, modelMatrix, modelMatrix);
        GlStateManager.func_179110_a((FloatBuffer)modelMatrix.toFloatBuffer());
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
    }

    public void renderItemBack(ItemStack stack, LivingData<?> itemHolder) {
        VisibleMatrix4f modelMatrix = new VisibleMatrix4f(BACK_COORECTION);
        VisibleMatrix4f.mul(itemHolder.getEntityModel(ClientModels.LOGICAL_CLIENT).getArmature().findJointById(0).getAnimatedTransform(), modelMatrix, modelMatrix);
        GlStateManager.func_179110_a((FloatBuffer)modelMatrix.toFloatBuffer());
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
    }

    public void renderItemOnHead(ItemStack stack, LivingData<?> itemHolder, float partialTicks) {
        VisibleMatrix4f modelMatrix = new VisibleMatrix4f();
        VisibleMatrix4f.translate(new Vec3f(0.0f, 0.2f, 0.0f), modelMatrix, modelMatrix);
        VisibleMatrix4f.mul(itemHolder.getEntityModel(ClientModels.LOGICAL_CLIENT).getArmature().findJointById(9).getAnimatedTransform(), modelMatrix, modelMatrix);
        VisibleMatrix4f.scale(new Vec3f(0.6f, 0.6f, 0.6f), modelMatrix, modelMatrix);
        GlStateManager.func_179110_a((FloatBuffer)modelMatrix.toFloatBuffer());
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
    }

    public VisibleMatrix4f getCorrectionMatrix(ItemStack stack, LivingData<?> itemHolder, EnumHand hand) {
        return new VisibleMatrix4f(this.correctionMatrix);
    }

    static {
        VisibleMatrix4f.translate(new Vec3f(0.5f, 1.0f, 0.1f), BACK_COORECTION, BACK_COORECTION);
        VisibleMatrix4f.rotate((float)Math.toRadians(130.0), new Vec3f(0.0f, 0.0f, 1.0f), BACK_COORECTION, BACK_COORECTION);
        VisibleMatrix4f.rotate((float)Math.toRadians(100.0), new Vec3f(0.0f, 1.0f, 0.0f), BACK_COORECTION, BACK_COORECTION);
    }
}

