/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.collada;

import java.util.ArrayList;
import java.util.List;
import maninthehouse.epicfight.collada.VertexData;
import maninthehouse.epicfight.collada.xml.XmlNode;
import maninthehouse.epicfight.utils.math.Vec2f;
import maninthehouse.epicfight.utils.math.Vec3f;
import maninthehouse.epicfight.utils.math.Vec4f;
import maninthehouse.epicfight.utils.math.VisibleMatrix4f;
import org.apache.commons.lang3.ArrayUtils;

public class GeometryDataExtractor {
    private static final VisibleMatrix4f CORRECTION = new VisibleMatrix4f().rotate((float)Math.toRadians(-90.0), new Vec3f(1.0f, 0.0f, 0.0f));
    private XmlNode geometryNode;
    private List<Integer> indexList = new ArrayList<Integer>();

    public GeometryDataExtractor(XmlNode geometry) {
        this.geometryNode = geometry;
    }

    public List<VertexData> extractVertexNumber() {
        int vertexCount = Integer.parseInt(this.getVertexNumber(this.geometryNode));
        ArrayList<VertexData> vertices = new ArrayList<VertexData>();
        for (int i = 0; i < vertexCount; ++i) {
            vertices.add(new VertexData());
        }
        return vertices;
    }

    public void extractGeometryData(List<VertexData> vertices) {
        int i;
        String[] rawPositionData = this.getPositions(this.geometryNode);
        String[] rawNormalData = this.getNormals(this.geometryNode);
        String[] rawTextureCoordData = this.getTextureCoords(this.geometryNode);
        String[] polyList = this.getPolyList(this.geometryNode);
        for (i = 0; i < rawPositionData.length; i += 3) {
            Vec4f original = new Vec4f(Float.parseFloat(rawPositionData[i]), Float.parseFloat(rawPositionData[i + 1]), Float.parseFloat(rawPositionData[i + 2]), 1.0f);
            VisibleMatrix4f.transform(CORRECTION, original, original);
            Vec3f corrected = new Vec3f(original.x, original.y, original.z);
            vertices.get(i / 3).setPosition(corrected);
        }
        block6: for (i = 0; i < polyList.length; i += 3) {
            int positionIndex = Integer.parseInt(polyList[i]);
            int normalIndex = Integer.parseInt(polyList[i + 1]);
            int textureIndex = Integer.parseInt(polyList[i + 2]);
            float normX = Float.parseFloat(rawNormalData[normalIndex * 3]);
            float normY = Float.parseFloat(rawNormalData[normalIndex * 3 + 1]);
            float normZ = Float.parseFloat(rawNormalData[normalIndex * 3 + 2]);
            float coordX = Float.parseFloat(rawTextureCoordData[textureIndex * 2]);
            float coordY = Float.parseFloat(rawTextureCoordData[textureIndex * 2 + 1]);
            Vec2f textureCoord = new Vec2f(coordX, 1.0f - coordY);
            Vec4f normal = new Vec4f(normX, normY, normZ, 1.0f);
            VisibleMatrix4f.transform(CORRECTION, normal, normal);
            Vec3f normalCorrected = new Vec3f(normal.x, normal.y, normal.z);
            VertexData vertex = vertices.get(positionIndex);
            switch (vertex.compareTextureCoordinateAndNormal(normalCorrected, textureCoord)) {
                case EMPTY: {
                    vertex.setTextureCoordinate(textureCoord);
                    vertex.setNormal(normalCorrected);
                    this.indexList.add(positionIndex);
                    continue block6;
                }
                case EQUAL: {
                    this.indexList.add(positionIndex);
                    continue block6;
                }
                case DIFFERENT: {
                    VertexData newVertex = new VertexData(vertex);
                    newVertex.setNormal(normalCorrected);
                    newVertex.setTextureCoordinate(textureCoord);
                    this.indexList.add(vertices.size());
                    vertices.add(newVertex);
                }
            }
        }
    }

    public int[] getIndices() {
        return ArrayUtils.toPrimitive((Integer[])this.indexList.toArray(new Integer[0]));
    }

    private String getVertexNumber(XmlNode node) {
        String positionsId = node.getChild("vertices").getChild("input").getAttribute("source").substring(1);
        XmlNode vertexData = node.getChildWithAttribute("source", "id", positionsId).getChild("technique_common").getChild("accessor");
        return vertexData.getAttribute("count");
    }

    private String[] getPositions(XmlNode node) {
        String positionsId = node.getChild("vertices").getChild("input").getAttribute("source").substring(1);
        XmlNode positionsData = node.getChildWithAttribute("source", "id", positionsId).getChild("float_array");
        return positionsData.getData().split(" ");
    }

    private String[] getNormals(XmlNode node) {
        String noramlId = node.getChild("triangles").getChildWithAttribute("input", "semantic", "NORMAL").getAttribute("source").substring(1);
        XmlNode noramlData = node.getChildWithAttribute("source", "id", noramlId).getChild("float_array");
        return noramlData.getData().split(" ");
    }

    private String[] getTextureCoords(XmlNode node) {
        String textureCoordId = node.getChild("triangles").getChildWithAttribute("input", "semantic", "TEXCOORD").getAttribute("source").substring(1);
        XmlNode textureCoordData = node.getChildWithAttribute("source", "id", textureCoordId).getChild("float_array");
        return textureCoordData.getData().split(" ");
    }

    private String[] getPolyList(XmlNode node) {
        return node.getChild("triangles").getChild("p").getData().split(" ");
    }
}

