/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import maninthehouse.epicfight.animation.LivingMotion;
import maninthehouse.epicfight.capabilities.item.CapabilityItem;
import maninthehouse.epicfight.capabilities.item.ModWeaponCapability;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.gamedata.Colliders;
import maninthehouse.epicfight.gamedata.Skills;
import maninthehouse.epicfight.gamedata.Sounds;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.config.IConfigElement;

@Config(modid="epicfight", name="epicfight", category="custom")
public class ConfigurationCapability {
    @Config.Name(value="custom_weaponry")
    public static CustomWeaponConfig weaponConfig = new CustomWeaponConfig();
    @Config.Name(value="custom_armor")
    public static CustomArmorConfig armorConfig = new CustomArmorConfig();

    public static List<WeaponConfig> getWeaponConfigs() {
        ArrayList list = Lists.newArrayList();
        IConfigElement root = ConfigElement.from(ConfigurationCapability.class);
        IConfigElement weapons = ConfigurationCapability.getElementByName(root.getChildElements(), "custom_weaponry");
        for (IConfigElement configElement : weapons.getChildElements()) {
            List childElements = configElement.getChildElements();
            WeaponConfig config = new WeaponConfig();
            config.registryName = (String)ConfigurationCapability.getElementByName(childElements, "registry_name").get();
            config.weaponType = WeaponType.findByName((String)ConfigurationCapability.getElementByName(childElements, "weapon_type").get());
            IConfigElement onehandConfig = ConfigurationCapability.getElementByName(childElements, "onehand");
            IConfigElement twohandConfig = ConfigurationCapability.getElementByName(childElements, "twohand");
            if (onehandConfig != null || twohandConfig != null) {
                if (onehandConfig != null) {
                    List onehandAttributes = onehandConfig.getChildElements();
                    config.onehand.armorNegation = Double.parseDouble((String)ConfigurationCapability.getElementByName(onehandAttributes, "armor_negation").get());
                    config.onehand.maxStrikes = Integer.parseInt((String)ConfigurationCapability.getElementByName(onehandAttributes, "max_strikes").get());
                    config.onehand.impact = Double.parseDouble((String)ConfigurationCapability.getElementByName(onehandAttributes, "impact").get());
                }
                if (twohandConfig != null) {
                    List twohandAttributes = twohandConfig.getChildElements();
                    config.twohand.armorNegation = Double.parseDouble((String)ConfigurationCapability.getElementByName(twohandAttributes, "armor_negation").get());
                    config.twohand.maxStrikes = Integer.parseInt((String)ConfigurationCapability.getElementByName(twohandAttributes, "max_strikes").get());
                    config.twohand.impact = Double.parseDouble((String)ConfigurationCapability.getElementByName(twohandAttributes, "impact").get());
                }
            } else {
                config.onehand.armorNegation = Double.parseDouble((String)ConfigurationCapability.getElementByName(childElements, "armor_negation").get());
                config.onehand.maxStrikes = Integer.parseInt((String)ConfigurationCapability.getElementByName(childElements, "max_strikes").get());
                config.onehand.impact = Double.parseDouble((String)ConfigurationCapability.getElementByName(childElements, "impact").get());
                config.twohand.armorNegation = config.onehand.armorNegation;
                config.twohand.maxStrikes = config.onehand.maxStrikes;
                config.twohand.impact = config.onehand.impact;
            }
            list.add(config);
        }
        return list;
    }

    public static List<ArmorConfig> getArmorConfigs() {
        ArrayList list = Lists.newArrayList();
        IConfigElement root = ConfigElement.from(ConfigurationCapability.class);
        IConfigElement armors = ConfigurationCapability.getElementByName(root.getChildElements(), "custom_armor");
        for (IConfigElement configElement : armors.getChildElements()) {
            List childElements = configElement.getChildElements();
            ArmorConfig config = new ArmorConfig();
            config.registryName = (String)ConfigurationCapability.getElementByName(childElements, "registry_name").get();
            config.stunArmor = Double.parseDouble((String)ConfigurationCapability.getElementByName(childElements, "stun_armor").get());
            config.weight = Double.parseDouble((String)ConfigurationCapability.getElementByName(childElements, "weight").get());
            list.add(config);
        }
        return list;
    }

    public static IConfigElement getElementByName(List<IConfigElement> configElements, String name) {
        for (IConfigElement element : configElements) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public static enum WeaponType {
        AXE(() -> {
            ModWeaponCapability cap = new ModWeaponCapability(CapabilityItem.WeaponCategory.AXE, playerdata -> CapabilityItem.WieldStyle.ONE_HAND, null, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.tools, CapabilityItem.HandProperty.GENERAL);
            cap.addStyleCombo(CapabilityItem.WieldStyle.ONE_HAND, Animations.AXE_AUTO1, Animations.AXE_AUTO2, Animations.AXE_DASH);
            cap.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SWORD_MOUNT_ATTACK);
            cap.addStyleSpecialAttack(CapabilityItem.WieldStyle.ONE_HAND, Skills.GUILLOTINE_AXE);
            return cap;
        }),
        FIST(() -> {
            ModWeaponCapability cap = new ModWeaponCapability(CapabilityItem.WeaponCategory.FIST, playerdata -> CapabilityItem.WieldStyle.ONE_HAND, null, Sounds.WHOOSH, Sounds.BLUNT_HIT, Colliders.fist, CapabilityItem.HandProperty.GENERAL);
            cap.addStyleCombo(CapabilityItem.WieldStyle.ONE_HAND, Animations.FIST_AUTO_1, Animations.FIST_AUTO_2, Animations.FIST_AUTO_3, Animations.FIST_DASH);
            return cap;
        }),
        HOE(() -> {
            ModWeaponCapability cap = new ModWeaponCapability(CapabilityItem.WeaponCategory.HOE, playerdata -> CapabilityItem.WieldStyle.ONE_HAND, null, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.tools, CapabilityItem.HandProperty.GENERAL);
            cap.addStyleCombo(CapabilityItem.WieldStyle.ONE_HAND, Animations.TOOL_AUTO_1, Animations.TOOL_AUTO_2, Animations.TOOL_DASH);
            cap.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SWORD_MOUNT_ATTACK);
            return cap;
        }),
        PICKAXE(() -> {
            ModWeaponCapability cap = new ModWeaponCapability(CapabilityItem.WeaponCategory.PICKAXE, playerdata -> CapabilityItem.WieldStyle.ONE_HAND, null, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.tools, CapabilityItem.HandProperty.GENERAL);
            cap.addStyleCombo(CapabilityItem.WieldStyle.ONE_HAND, Animations.AXE_AUTO1, Animations.AXE_AUTO2, Animations.AXE_DASH);
            cap.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SWORD_MOUNT_ATTACK);
            return cap;
        }),
        SHOVEL(() -> {
            ModWeaponCapability cap = new ModWeaponCapability(CapabilityItem.WeaponCategory.SHOVEL, playerdata -> CapabilityItem.WieldStyle.ONE_HAND, null, Sounds.WHOOSH, Sounds.BLUNT_HIT, Colliders.tools, CapabilityItem.HandProperty.GENERAL);
            cap.addStyleCombo(CapabilityItem.WieldStyle.ONE_HAND, Animations.AXE_AUTO1, Animations.AXE_AUTO2, Animations.AXE_DASH);
            cap.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SWORD_MOUNT_ATTACK);
            return cap;
        }),
        SWORD(() -> {
            ModWeaponCapability cap = new ModWeaponCapability(CapabilityItem.WeaponCategory.SWORD, playerdata -> {
                CapabilityItem item = playerdata.getHeldItemCapability(EnumHand.OFF_HAND);
                if (item != null && item.getWeaponCategory() == CapabilityItem.WeaponCategory.SWORD) {
                    return CapabilityItem.WieldStyle.TWO_HAND;
                }
                return CapabilityItem.WieldStyle.ONE_HAND;
            }, null, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.sword, CapabilityItem.HandProperty.GENERAL);
            cap.addStyleCombo(CapabilityItem.WieldStyle.ONE_HAND, Animations.SWORD_AUTO_1, Animations.SWORD_AUTO_2, Animations.SWORD_AUTO_3, Animations.SWORD_DASH);
            cap.addStyleCombo(CapabilityItem.WieldStyle.TWO_HAND, Animations.SWORD_DUAL_AUTO_1, Animations.SWORD_DUAL_AUTO_2, Animations.SWORD_DUAL_AUTO_3, Animations.SWORD_DUAL_DASH);
            cap.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SWORD_MOUNT_ATTACK);
            cap.addStyleSpecialAttack(CapabilityItem.WieldStyle.ONE_HAND, Skills.SWEEPING_EDGE);
            cap.addStyleSpecialAttack(CapabilityItem.WieldStyle.TWO_HAND, Skills.DANCING_EDGE);
            return cap;
        }),
        SPEAR(() -> {
            ModWeaponCapability cap = new ModWeaponCapability(CapabilityItem.WeaponCategory.SPEAR, playerdata -> playerdata.getOriginalEntity().func_184592_cb().func_190926_b() ? CapabilityItem.WieldStyle.TWO_HAND : CapabilityItem.WieldStyle.ONE_HAND, null, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.spearNarrow, CapabilityItem.HandProperty.MAINHAND_ONLY);
            cap.addStyleCombo(CapabilityItem.WieldStyle.ONE_HAND, Animations.SPEAR_ONEHAND_AUTO, Animations.SPEAR_DASH);
            cap.addStyleCombo(CapabilityItem.WieldStyle.TWO_HAND, Animations.SPEAR_TWOHAND_AUTO_1, Animations.SPEAR_TWOHAND_AUTO_2, Animations.SPEAR_DASH);
            cap.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SPEAR_MOUNT_ATTACK);
            cap.addStyleSpecialAttack(CapabilityItem.WieldStyle.ONE_HAND, Skills.HEARTPIERCER);
            cap.addStyleSpecialAttack(CapabilityItem.WieldStyle.TWO_HAND, Skills.SLAUGHTER_STANCE);
            cap.addLivingMotionChanger(LivingMotion.RUNNING, Animations.BIPED_RUN_HELDING_WEAPON);
            return cap;
        }),
        GREATSWORD(() -> {
            ModWeaponCapability cap = new ModWeaponCapability(CapabilityItem.WeaponCategory.GREATSWORD, playerdata -> CapabilityItem.WieldStyle.TWO_HAND, null, Sounds.WHOOSH_BIG, Sounds.BLADE_HIT, Colliders.greatSword, CapabilityItem.HandProperty.TWO_HANDED);
            cap.addStyleCombo(CapabilityItem.WieldStyle.TWO_HAND, Animations.GREATSWORD_AUTO_1, Animations.GREATSWORD_AUTO_2, Animations.GREATSWORD_DASH);
            cap.addStyleSpecialAttack(CapabilityItem.WieldStyle.TWO_HAND, Skills.GIANT_WHIRLWIND);
            cap.addLivingMotionChanger(LivingMotion.IDLE, Animations.BIPED_IDLE_MASSIVE_HELD);
            cap.addLivingMotionChanger(LivingMotion.WALKING, Animations.BIPED_WALK_MASSIVE_HELD);
            cap.addLivingMotionChanger(LivingMotion.RUNNING, Animations.BIPED_RUN_MASSIVE_HELD);
            cap.addLivingMotionChanger(LivingMotion.JUMPING, Animations.BIPED_JUMP_MASSIVE_HELD);
            cap.addLivingMotionChanger(LivingMotion.KNEELING, Animations.BIPED_KNEEL_MASSIVE_HELD);
            cap.addLivingMotionChanger(LivingMotion.SNEAKING, Animations.BIPED_SNEAK_MASSIVE_HELD);
            return cap;
        }),
        KATANA(() -> {
            ModWeaponCapability cap = new ModWeaponCapability(CapabilityItem.WeaponCategory.KATANA, playerdata -> CapabilityItem.WieldStyle.TWO_HAND, null, Sounds.WHOOSH, Sounds.BLADE_HIT, Colliders.katana, CapabilityItem.HandProperty.TWO_HANDED);
            cap.addStyleCombo(CapabilityItem.WieldStyle.TWO_HAND, Animations.KATANA_AUTO_1, Animations.KATANA_AUTO_2, Animations.KATANA_AUTO_3, Animations.SWORD_DASH);
            cap.addStyleCombo(CapabilityItem.WieldStyle.MOUNT, Animations.SWORD_MOUNT_ATTACK);
            cap.addStyleSpecialAttack(CapabilityItem.WieldStyle.TWO_HAND, Skills.SWEEPING_EDGE);
            cap.addLivingMotionChanger(LivingMotion.IDLE, Animations.BIPED_IDLE_UNSHEATHING);
            cap.addLivingMotionChanger(LivingMotion.WALKING, Animations.BIPED_WALK_UNSHEATHING);
            cap.addLivingMotionChanger(LivingMotion.RUNNING, Animations.BIPED_RUN_UNSHEATHING);
            return cap;
        });

        Supplier<ModWeaponCapability> capabilitySupplier;
        static Map<String, WeaponType> searchByName;

        private WeaponType(Supplier<ModWeaponCapability> capabilitySupplier) {
            this.capabilitySupplier = capabilitySupplier;
        }

        public ModWeaponCapability get() {
            return this.capabilitySupplier.get();
        }

        public static WeaponType findByName(String name) {
            return searchByName.get(name);
        }

        static {
            searchByName = Maps.newHashMap();
            searchByName.put("AXE", AXE);
            searchByName.put("FIST", FIST);
            searchByName.put("HOE", HOE);
            searchByName.put("PICKAXE", PICKAXE);
            searchByName.put("SHOVEL", SHOVEL);
            searchByName.put("SWORD", SWORD);
            searchByName.put("SPEAR", SPEAR);
            searchByName.put("GREATSWORD", GREATSWORD);
            searchByName.put("KATANA", KATANA);
        }
    }

    public static class Hand {
        @Config.Name(value="armor_negation")
        public double armorNegation = 0.0;
        @Config.Name(value="max_strikes")
        public int maxStrikes = 1;
        @Config.Name(value="impact")
        public double impact = 0.5;
    }

    public static class WeaponConfig {
        @Config.Name(value="registry_name")
        public String registryName = "modid:registryname";
        @Config.Name(value="onehand")
        public Hand onehand = new Hand();
        @Config.Name(value="twohand")
        public Hand twohand = new Hand();
        @Config.Name(value="weapon_type")
        public WeaponType weaponType = WeaponType.SWORD;
    }

    public static class SampleSimpleWeapon {
        @Config.Name(value="registry_name")
        public String registryName = "modid:registryname";
        @Config.Name(value="armor_negation")
        public double armorNegation = 0.0;
        @Config.Name(value="max_strikes")
        public int makStrikes = 1;
        @Config.Name(value="impact")
        public double impact = 0.5;
        @Config.Name(value="weapon_type")
        public WeaponType weaponType = WeaponType.SWORD;
    }

    public static class ArmorConfig {
        @Config.Name(value="registry_name")
        public String registryName = "modid:registryname";
        @Config.Name(value="stun_armor")
        public double stunArmor = 0.0;
        @Config.Name(value="weight")
        public double weight = 0.0;
    }

    public static class CustomWeaponConfig {
        @Config.Name(value="sample_weapon1")
        public SampleSimpleWeapon sampleWeapon1 = new SampleSimpleWeapon();
        @Config.Name(value="sample_weapon2")
        public WeaponConfig sampleWeapon2 = new WeaponConfig();
    }

    public static class CustomArmorConfig {
        @Config.Name(value="sample_armor")
        public ArmorConfig sampleArmor = new ArmorConfig();
    }
}

