/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.entity.ai;

import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninthehouse.epicfight.network.ModNetworkManager;
import maninthehouse.epicfight.network.server.STCPlayAnimationTarget;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.MathHelper;

public class EntityAIRangeAttack
extends EntityAIBase {
    protected final EntityLiving entityHost;
    protected final BipedMobData entitydata;
    protected final StaticAnimation rangeAttackAnimation;
    protected final IRangedAttackMob rangedAttackEntityHost;
    protected EntityLivingBase attackTarget;
    protected int rangedAttackTime = -1;
    protected final double entityMoveSpeed;
    protected int seeTime;
    protected final int attackIntervalMin;
    protected final int maxRangedAttackTime;
    protected final float attackRadius;
    protected final float maxAttackDistance;
    protected final int animationFrame;

    public EntityAIRangeAttack(IRangedAttackMob attacker, BipedMobData entitydata, StaticAnimation throwingAnimation, double movespeed, int maxAttackTime, float maxAttackDistanceIn, int animationFrame) {
        this(attacker, entitydata, throwingAnimation, movespeed, maxAttackTime, maxAttackTime, maxAttackDistanceIn, animationFrame);
    }

    public EntityAIRangeAttack(IRangedAttackMob attacker, BipedMobData entitydata, StaticAnimation throwingAnimation, double movespeed, int p_i1650_4_, int maxAttackTime, float maxAttackDistanceIn, int animationFrame) {
        if (!(attacker instanceof EntityLivingBase)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.entitydata = entitydata;
        this.rangeAttackAnimation = throwingAnimation;
        this.rangedAttackEntityHost = attacker;
        this.entityHost = (EntityLiving)attacker;
        this.entityMoveSpeed = movespeed;
        this.attackIntervalMin = p_i1650_4_;
        this.maxRangedAttackTime = maxAttackTime;
        this.attackRadius = maxAttackDistanceIn;
        this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
        this.animationFrame = animationFrame;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.entityHost.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        this.attackTarget = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.entityHost.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
    }

    public void func_75246_d() {
        double d0 = this.entityHost.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
        boolean flag = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
        this.seeTime = flag ? ++this.seeTime : 0;
        if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 20) {
            this.entityHost.func_70661_as().func_75499_g();
        } else {
            this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
        }
        this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        if (--this.rangedAttackTime == this.animationFrame && !this.entitydata.isInaction()) {
            this.entitydata.getServerAnimator().playAnimation(this.rangeAttackAnimation, 0.0f);
            ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimationTarget(this.rangeAttackAnimation.getId(), this.entityHost.func_145782_y(), 0.0f, this.attackTarget.func_145782_y()), (Entity)this.entityHost);
        } else if (this.rangedAttackTime == 0) {
            if (!flag) {
                return;
            }
            float f = MathHelper.func_76133_a((double)d0) / this.attackRadius;
            float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
            this.rangedAttackEntityHost.func_82196_d(this.attackTarget, lvt_5_1_);
            this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.rangedAttackTime < 0) {
            float f2 = MathHelper.func_76133_a((double)d0) / this.attackRadius;
            this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        }
    }
}

