/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.events;

import com.google.common.collect.Lists;
import java.util.List;
import maninthehouse.epicfight.animation.Animator;
import maninthehouse.epicfight.animation.types.StaticAnimation;
import maninthehouse.epicfight.capabilities.ModCapabilities;
import maninthehouse.epicfight.capabilities.entity.CapabilityEntity;
import maninthehouse.epicfight.capabilities.entity.IRangedAttackMobCapability;
import maninthehouse.epicfight.capabilities.entity.LivingData;
import maninthehouse.epicfight.capabilities.entity.mob.BipedMobData;
import maninthehouse.epicfight.capabilities.entity.mob.EndermanData;
import maninthehouse.epicfight.capabilities.entity.player.ServerPlayerData;
import maninthehouse.epicfight.capabilities.item.CapabilityItem;
import maninthehouse.epicfight.effects.ModEffects;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.network.ModNetworkManager;
import maninthehouse.epicfight.network.client.CTSPlayAnimation;
import maninthehouse.epicfight.network.server.STCPlayAnimation;
import maninthehouse.epicfight.network.server.STCPotion;
import maninthehouse.epicfight.utils.game.IExtendedDamageSource;
import maninthehouse.epicfight.utils.game.IndirectDamageSourceExtended;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="epicfight")
public class EntityEvents {
    private static List<CapabilityEntity<?>> unInitializedEntitiesClient = Lists.newArrayList();
    private static List<CapabilityEntity<?>> unInitializedEntitiesServer = Lists.newArrayList();

    @SubscribeEvent
    public static void spawnEvent(EntityJoinWorldEvent event) {
        CapabilityEntity entitydata = (CapabilityEntity)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
        if (entitydata != null && event.getEntity().field_70173_aa == 0) {
            entitydata.onEntityJoinWorld(event.getEntity());
            if (entitydata.isRemote()) {
                unInitializedEntitiesClient.add(entitydata);
            } else {
                unInitializedEntitiesServer.add(entitydata);
            }
        }
    }

    @SubscribeEvent
    public static void updateEvent(LivingEvent.LivingUpdateEvent event) {
        LivingData entitydata = (LivingData)event.getEntityLiving().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
        if (entitydata != null && entitydata.getOriginalEntity() != null) {
            entitydata.update();
        }
    }

    @SubscribeEvent
    public static void knockBackEvent(LivingKnockBackEvent event) {
        CapabilityEntity cap = (CapabilityEntity)event.getEntityLiving().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
        if (cap != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void hurtEvent(LivingHurtEvent event) {
        IExtendedDamageSource extSource = null;
        Entity trueSource = event.getSource().func_76346_g();
        if (trueSource != null) {
            CapabilityEntity attackerdata;
            if (event.getSource() instanceof IExtendedDamageSource) {
                extSource = (IExtendedDamageSource)event.getSource();
            } else if (event.getSource() instanceof EntityDamageSourceIndirect && (attackerdata = (CapabilityEntity)trueSource.getCapability(ModCapabilities.CAPABILITY_ENTITY, null)) != null) {
                if (attackerdata instanceof IRangedAttackMobCapability) {
                    extSource = ((IRangedAttackMobCapability)((Object)attackerdata)).getRangedDamageSource(event.getSource().func_76364_f());
                } else if (event.getSource().field_76373_n.equals("arrow")) {
                    extSource = new IndirectDamageSourceExtended("arrow", trueSource, event.getSource().func_76364_f(), IExtendedDamageSource.StunType.SHORT);
                    extSource.setImpact(1.0f);
                }
            }
            if (extSource != null) {
                LivingData hitEntityData;
                int k;
                float ignoreDamage;
                float totalDamage = event.getAmount();
                float calculatedDamage = ignoreDamage = event.getAmount() * extSource.getArmorIgnoreRatio();
                EntityLivingBase hitEntity = event.getEntityLiving();
                if (hitEntity.func_70644_a(MobEffects.field_76429_m)) {
                    int i = (hitEntity.func_70660_b(MobEffects.field_76429_m).func_76458_c() + 1) * 5;
                    int j = 25 - i;
                    float f = calculatedDamage * (float)j;
                    calculatedDamage = Math.max(f / 25.0f, 0.0f);
                }
                if (calculatedDamage > 0.0f && (k = EnchantmentHelper.func_77508_a((Iterable)hitEntity.func_184193_aE(), (DamageSource)event.getSource())) > 0) {
                    calculatedDamage = CombatRules.func_188401_b((float)calculatedDamage, (float)k);
                }
                float absorpAmount = hitEntity.func_110139_bj() - calculatedDamage;
                hitEntity.func_110149_m(Math.max(absorpAmount, 0.0f));
                if (absorpAmount < 0.0f) {
                    hitEntity.func_70606_j(hitEntity.func_110143_aJ() + absorpAmount);
                    LivingData attacker = (LivingData)trueSource.getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
                    if (attacker != null) {
                        attacker.gatherDamageDealt((IExtendedDamageSource)event.getSource(), calculatedDamage);
                    }
                }
                event.setAmount(totalDamage - ignoreDamage);
                if (event.getAmount() + ignoreDamage > 0.0f && (hitEntityData = (LivingData)hitEntity.getCapability(ModCapabilities.CAPABILITY_ENTITY, null)) != null) {
                    StaticAnimation hitAnimation = null;
                    float extendStunTime = 0.0f;
                    float knockBackAmount = 0.0f;
                    float weightReduction = 40.0f / (float)hitEntityData.getWeight();
                    float currentStunResistance = hitEntityData.getStunArmor();
                    if (currentStunResistance > 0.0f) {
                        float impact = extSource.getImpact();
                        hitEntityData.setStunArmor(currentStunResistance - impact);
                    }
                    switch (extSource.getStunType()) {
                        case SHORT: {
                            if (hitEntity.func_70644_a(ModEffects.STUN_IMMUNITY) || hitEntityData.getStunArmor() != 0.0f) break;
                            int i = EnchantmentHelper.func_77501_a((EntityLivingBase)((EntityLivingBase)trueSource));
                            float totalStunTime = (0.25f + extSource.getImpact() * 0.1f + 0.1f * (float)i) * weightReduction;
                            if (!((totalStunTime *= 1.0f - hitEntityData.getStunTimeTimeReduction()) >= 0.1f)) break;
                            extendStunTime = totalStunTime - 0.1f;
                            boolean flag = totalStunTime >= 0.83f;
                            IExtendedDamageSource.StunType stunType = flag ? IExtendedDamageSource.StunType.LONG : IExtendedDamageSource.StunType.SHORT;
                            extendStunTime = flag ? 0.0f : extendStunTime;
                            hitAnimation = hitEntityData.getHitAnimation(stunType);
                            knockBackAmount = totalStunTime;
                            break;
                        }
                        case LONG: {
                            hitAnimation = hitEntity.func_70644_a(ModEffects.STUN_IMMUNITY) ? null : hitEntityData.getHitAnimation(IExtendedDamageSource.StunType.LONG);
                            knockBackAmount = extSource.getImpact() * 0.25f * weightReduction;
                            break;
                        }
                        case HOLD: {
                            hitAnimation = hitEntityData.getHitAnimation(IExtendedDamageSource.StunType.SHORT);
                            extendStunTime = extSource.getImpact() * 0.1f;
                        }
                    }
                    if (hitAnimation != null) {
                        if (!(hitEntity instanceof EntityPlayer)) {
                            hitEntityData.lookAttacker(trueSource);
                        }
                        hitEntityData.setStunTimeReduction();
                        ((Animator)hitEntityData.getAnimator()).playAnimation(hitAnimation, extendStunTime);
                        ModNetworkManager.sendToAllPlayerTrackingThisEntity(new STCPlayAnimation(hitAnimation.getId(), hitEntity.func_145782_y(), extendStunTime), (Entity)hitEntity);
                        if (hitEntity instanceof EntityPlayerMP) {
                            ModNetworkManager.sendToPlayer(new STCPlayAnimation(hitAnimation.getId(), hitEntity.func_145782_y(), extendStunTime), (EntityPlayerMP)hitEntity);
                        }
                    }
                    hitEntityData.knockBackEntity(trueSource, knockBackAmount);
                }
            }
        }
        if (event.getEntityLiving().func_184587_cr() && event.getEntityLiving().func_184607_cu().func_77973_b() == Items.field_185159_cQ && event.getEntityLiving() instanceof EntityPlayer) {
            event.getEntityLiving().field_70170_p.func_184133_a((EntityPlayer)event.getEntityLiving(), event.getEntityLiving().func_180425_c(), SoundEvents.field_187767_eL, event.getEntityLiving().func_184176_by(), 1.0f, 0.8f + event.getEntityLiving().func_70681_au().nextFloat() * 0.4f);
        }
    }

    @SubscribeEvent
    public static void damageEvent(LivingDamageEvent event) {
        LivingData attacker;
        Entity trueSource = event.getSource().func_76346_g();
        if (event.getSource() instanceof IExtendedDamageSource && trueSource != null && (attacker = (LivingData)trueSource.getCapability(ModCapabilities.CAPABILITY_ENTITY, null)) != null) {
            attacker.gatherDamageDealt((IExtendedDamageSource)event.getSource(), event.getAmount());
        }
    }

    @SubscribeEvent
    public static void attackEvent(LivingAttackEvent event) {
        LivingData entitydata = (LivingData)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
        if (entitydata != null && !event.getEntity().field_70170_p.field_72995_K && event.getEntityLiving().func_110143_aJ() > 0.0f && !entitydata.attackEntityFrom(event.getSource(), event.getAmount())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void arrowHitEvent(ProjectileImpactEvent.Arrow event) {
        if (event.getRayTraceResult().field_72308_g != null && event.getArrow() != null && event.getArrow().field_70250_c != null && event.getRayTraceResult().field_72308_g.equals((Object)event.getArrow().field_70250_c.func_184187_bx())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void equipChangeEvent(LivingEquipmentChangeEvent event) {
        if (event.getFrom().func_77973_b() == event.getTo().func_77973_b()) {
            return;
        }
        LivingData entitycap = (LivingData)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
        if (entitycap != null && entitycap.getOriginalEntity() != null) {
            if (event.getSlot() == EntityEquipmentSlot.MAINHAND) {
                CapabilityItem fromCap = ModCapabilities.stackCapabilityGetter(event.getFrom());
                CapabilityItem toCap = ModCapabilities.stackCapabilityGetter(event.getTo());
                entitycap.cancelUsingItem();
                if (fromCap != null) {
                    event.getEntityLiving().func_110140_aT().func_111148_a(fromCap.getAttributeModifiers(event.getSlot(), entitycap));
                }
                if (toCap != null) {
                    event.getEntityLiving().func_110140_aT().func_111147_b(toCap.getAttributeModifiers(event.getSlot(), entitycap));
                }
                if (entitycap instanceof ServerPlayerData) {
                    ServerPlayerData playercap = (ServerPlayerData)entitycap;
                    playercap.onHeldItemChange(toCap, event.getTo(), EnumHand.MAIN_HAND);
                }
            } else if (event.getSlot() == EntityEquipmentSlot.OFFHAND) {
                entitycap.cancelUsingItem();
                if (entitycap instanceof ServerPlayerData) {
                    ServerPlayerData playercap = (ServerPlayerData)entitycap;
                    CapabilityItem toCap = event.getTo().func_190926_b() ? null : entitycap.getHeldItemCapability(EnumHand.MAIN_HAND);
                    playercap.onHeldItemChange(toCap, event.getTo(), EnumHand.OFF_HAND);
                }
            } else if (event.getSlot().func_188453_a() == EntityEquipmentSlot.Type.ARMOR) {
                CapabilityItem fromCap = ModCapabilities.stackCapabilityGetter(event.getFrom());
                CapabilityItem toCap = ModCapabilities.stackCapabilityGetter(event.getTo());
                if (fromCap != null) {
                    event.getEntityLiving().func_110140_aT().func_111148_a(fromCap.getAttributeModifiers(event.getSlot(), entitycap));
                }
                if (toCap != null) {
                    event.getEntityLiving().func_110140_aT().func_111147_b(toCap.getAttributeModifiers(event.getSlot(), entitycap));
                }
                LivingData entitydata = (LivingData)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
                entitydata.onArmorSlotChanged(fromCap, toCap, event.getSlot());
            }
        }
    }

    @SubscribeEvent
    public static void effectAddEvent(PotionEvent.PotionAddedEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            ModNetworkManager.sendToAll(new STCPotion(event.getPotionEffect().func_188419_a(), STCPotion.Action.Active, event.getEntity().func_145782_y()));
        }
    }

    @SubscribeEvent
    public static void effectRemoveEvent(PotionEvent.PotionRemoveEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getPotionEffect() != null) {
            ModNetworkManager.sendToAll(new STCPotion(event.getPotionEffect().func_188419_a(), STCPotion.Action.Remove, event.getEntity().func_145782_y()));
        }
    }

    @SubscribeEvent
    public static void effectExpiryEvent(PotionEvent.PotionExpiryEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            ModNetworkManager.sendToAll(new STCPotion(event.getPotionEffect().func_188419_a(), STCPotion.Action.Remove, event.getEntity().func_145782_y()));
        }
    }

    @SubscribeEvent
    public static void mountEvent(EntityMountEvent event) {
        CapabilityEntity mountEntity = (CapabilityEntity)event.getEntityMounting().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
        if (!event.getWorldObj().field_72995_K && mountEntity instanceof BipedMobData && mountEntity.getOriginalEntity() != null && event.getEntityBeingMounted() instanceof EntityCreature) {
            ((BipedMobData)mountEntity).onMount(event.isMounting(), event.getEntityBeingMounted());
        }
    }

    @SubscribeEvent
    public static void tpEvent(EnderTeleportEvent event) {
        EntityEnderman enderman;
        EndermanData endermandata;
        EntityLivingBase entity = event.getEntityLiving();
        if (event.getEntityLiving() instanceof EntityEnderman && (endermandata = (EndermanData)(enderman = (EntityEnderman)entity).getCapability(ModCapabilities.CAPABILITY_ENTITY, null)) != null) {
            if (endermandata.isInaction()) {
                for (Entity collideEntity : enderman.field_70170_p.func_72872_a(Entity.class, enderman.func_174813_aQ().func_72314_b(0.2, 0.2, 0.2))) {
                    if (!(collideEntity instanceof IProjectile)) continue;
                    return;
                }
                event.setCanceled(true);
            } else if (endermandata.isRaging()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void jumpEvent(LivingEvent.LivingJumpEvent event) {
        LivingData entitydata = (LivingData)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
        if (entitydata != null && entitydata.isRemote() && !entitydata.isInaction() && !event.getEntity().func_70090_H()) {
            StaticAnimation jumpAnimation = entitydata.getClientAnimator().getJumpAnimation();
            ((Animator)entitydata.getAnimator()).playAnimation(jumpAnimation, 0.0f);
            ModNetworkManager.sendToServer(new CTSPlayAnimation(jumpAnimation.getId(), 0.0f, true, false));
        }
    }

    @SubscribeEvent
    public static void deathEvent(LivingDeathEvent event) {
        LivingData entitydata = (LivingData)event.getEntityLiving().getCapability(ModCapabilities.CAPABILITY_ENTITY, null);
        if (entitydata != null) {
            ((Animator)entitydata.getAnimator()).playDeathAnimation();
        }
    }

    @SubscribeEvent
    public static void fallEvent(LivingFallEvent event) {
        float distance;
        LivingData entitydata;
        if (event.getEntity().field_70170_p.func_82736_K().func_82766_b("hasFallAnimation") && (entitydata = (LivingData)event.getEntity().getCapability(ModCapabilities.CAPABILITY_ENTITY, null)) != null && !entitydata.isInaction() && (distance = event.getDistance()) > 5.0f) {
            ((Animator)entitydata.getAnimator()).playAnimation(Animations.BIPED_LAND_DAMAGE, 0.0f);
        }
    }

    @SubscribeEvent
    public static void tickClientEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (CapabilityEntity<?> cap : unInitializedEntitiesClient) {
                cap.postInit();
            }
            unInitializedEntitiesClient.clear();
        }
    }

    @SubscribeEvent
    public static void tickServerEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (CapabilityEntity<?> cap : unInitializedEntitiesServer) {
                cap.postInit();
            }
            unInitializedEntitiesServer.clear();
        }
    }
}

