/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.gamedata;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import maninthehouse.epicfight.animation.types.AnimationProperty;
import maninthehouse.epicfight.gamedata.Animations;
import maninthehouse.epicfight.skill.DodgeSkill;
import maninthehouse.epicfight.skill.FatalDrawSkill;
import maninthehouse.epicfight.skill.KatanaPassive;
import maninthehouse.epicfight.skill.Skill;
import maninthehouse.epicfight.skill.SkillSlot;
import maninthehouse.epicfight.skill.SpecialAttackSkill;
import maninthehouse.epicfight.utils.game.IExtendedDamageSource;
import net.minecraft.util.ResourceLocation;

public class Skills {
    public static final Map<ResourceLocation, Skill> MODIFIABLE_SKILLS = new HashMap<ResourceLocation, Skill>();
    public static Skill ROLL;
    public static Skill GUILLOTINE_AXE;
    public static Skill SWEEPING_EDGE;
    public static Skill DANCING_EDGE;
    public static Skill SLAUGHTER_STANCE;
    public static Skill HEARTPIERCER;
    public static Skill GIANT_WHIRLWIND;
    public static Skill FATAL_DRAW;
    public static Skill KATANA_GIMMICK;

    public static void init() {
        ROLL = Skills.makeSkill("roll", skillName -> new DodgeSkill(SkillSlot.DODGE, 2.0f, (String)skillName, Animations.BIPED_ROLL_FORWARD, Animations.BIPED_ROLL_BACKWARD), true);
        SWEEPING_EDGE = Skills.makeSkill("sweeping_edge", skillName -> new SpecialAttackSkill(SkillSlot.WEAPON_SPECIAL_ATTACK, 30.0f, (String)skillName, Animations.SWEEPING_EDGE).addProperty(AnimationProperty.HIT_AT_ONCE, 3).addProperty(AnimationProperty.DAMAGE_MULTIPLIER, Float.valueOf(2.0f)).addProperty(AnimationProperty.ARMOR_NEGATION, Float.valueOf(20.0f)).addProperty(AnimationProperty.STUN_TYPE, IExtendedDamageSource.StunType.LONG).registerPropertiesToAnimation(), false);
        DANCING_EDGE = Skills.makeSkill("dancing_edge", skillName -> new SpecialAttackSkill(SkillSlot.WEAPON_SPECIAL_ATTACK, 30.0f, (String)skillName, Animations.DANCING_EDGE).addProperty(AnimationProperty.HIT_AT_ONCE, 3).addProperty(AnimationProperty.IMPACT, Float.valueOf(1.5f)).registerPropertiesToAnimation(), false);
        GUILLOTINE_AXE = Skills.makeSkill("guillotine_axe", skillName -> new SpecialAttackSkill(SkillSlot.WEAPON_SPECIAL_ATTACK, 20.0f, (String)skillName, Animations.GUILLOTINE_AXE).addProperty(AnimationProperty.HIT_AT_ONCE, 1).addProperty(AnimationProperty.DAMAGE_MULTIPLIER, Float.valueOf(2.5f)).addProperty(AnimationProperty.ARMOR_NEGATION, Float.valueOf(40.0f)).addProperty(AnimationProperty.STUN_TYPE, IExtendedDamageSource.StunType.LONG).registerPropertiesToAnimation(), false);
        SLAUGHTER_STANCE = Skills.makeSkill("slaughter_stance", skillName -> new SpecialAttackSkill(SkillSlot.WEAPON_SPECIAL_ATTACK, 40.0f, (String)skillName, Animations.SPEAR_SLASH).addProperty(AnimationProperty.HIT_AT_ONCE, 8).addProperty(AnimationProperty.DAMAGE_MULTIPLIER, Float.valueOf(1.25f)).addProperty(AnimationProperty.IMPACT, Float.valueOf(2.0f)).registerPropertiesToAnimation(), false);
        HEARTPIERCER = Skills.makeSkill("heartpiercer", skillName -> new SpecialAttackSkill(SkillSlot.WEAPON_SPECIAL_ATTACK, 40.0f, (String)skillName, Animations.SPEAR_THRUST).addProperty(AnimationProperty.ARMOR_NEGATION, Float.valueOf(20.0f)).addProperty(AnimationProperty.STUN_TYPE, IExtendedDamageSource.StunType.HOLD).registerPropertiesToAnimation(), false);
        GIANT_WHIRLWIND = Skills.makeSkill("giant_whirlwind", skillName -> new SpecialAttackSkill(SkillSlot.WEAPON_SPECIAL_ATTACK, 60.0f, (String)skillName, Animations.GIANT_WHIRLWIND), false);
        FATAL_DRAW = Skills.makeSkill("fatal_draw", skillName -> new FatalDrawSkill((String)skillName).addProperty(AnimationProperty.DAMAGE_MULTIPLIER, Float.valueOf(2.0f)).addProperty(AnimationProperty.ARMOR_NEGATION, Float.valueOf(50.0f)).addProperty(AnimationProperty.HIT_AT_ONCE, 8).addProperty(AnimationProperty.STUN_TYPE, IExtendedDamageSource.StunType.HOLD).registerPropertiesToAnimation(), false);
        KATANA_GIMMICK = new KatanaPassive();
    }

    public static Skill makeSkill(String skillName, Function<String, Skill> object, boolean registerSkillBook) {
        if (registerSkillBook) {
            MODIFIABLE_SKILLS.put(new ResourceLocation("epicfight", skillName), object.apply(skillName));
        }
        return object.apply(skillName);
    }
}

