/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.network;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.nio.charset.StandardCharsets;
import maninthehouse.epicfight.network.client.CTSExecuteSkill;
import maninthehouse.epicfight.network.client.CTSPlayAnimation;
import maninthehouse.epicfight.network.client.CTSReqPlayerInfo;
import maninthehouse.epicfight.network.client.CTSReqSpawnInfo;
import maninthehouse.epicfight.network.client.CTSRotatePlayerYaw;
import maninthehouse.epicfight.network.server.STCExecuteSkill;
import maninthehouse.epicfight.network.server.STCGameruleChange;
import maninthehouse.epicfight.network.server.STCLivingMotionChange;
import maninthehouse.epicfight.network.server.STCMobInitialSetting;
import maninthehouse.epicfight.network.server.STCModifySkillVariable;
import maninthehouse.epicfight.network.server.STCNotifyPlayerYawChanged;
import maninthehouse.epicfight.network.server.STCPlayAnimation;
import maninthehouse.epicfight.network.server.STCPlayAnimationTP;
import maninthehouse.epicfight.network.server.STCPlayAnimationTarget;
import maninthehouse.epicfight.network.server.STCPotion;
import maninthehouse.epicfight.network.server.STCResetBasicAttackCool;
import maninthehouse.epicfight.network.server.STCSetSkillValue;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class ModNetworkManager {
    public static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("epicfight");
    private static final int MAX_LENGTH = Short.MAX_VALUE;

    public static void registerPackets() {
        int id = 0;
        INSTANCE.registerMessage(CTSExecuteSkill.Handler.class, CTSExecuteSkill.class, id++, Side.SERVER);
        INSTANCE.registerMessage(CTSPlayAnimation.Handler.class, CTSPlayAnimation.class, id++, Side.SERVER);
        INSTANCE.registerMessage(CTSReqSpawnInfo.Handler.class, CTSReqSpawnInfo.class, id++, Side.SERVER);
        INSTANCE.registerMessage(CTSRotatePlayerYaw.Handler.class, CTSRotatePlayerYaw.class, id++, Side.SERVER);
        INSTANCE.registerMessage(CTSReqPlayerInfo.Handler.class, CTSReqPlayerInfo.class, id++, Side.SERVER);
        INSTANCE.registerMessage(STCExecuteSkill.Handler.class, STCExecuteSkill.class, id++, Side.CLIENT);
        INSTANCE.registerMessage(STCMobInitialSetting.Handler.class, STCMobInitialSetting.class, id++, Side.CLIENT);
        INSTANCE.registerMessage(STCLivingMotionChange.Handler.class, STCLivingMotionChange.class, id++, Side.CLIENT);
        INSTANCE.registerMessage(STCSetSkillValue.Handler.class, STCSetSkillValue.class, id++, Side.CLIENT);
        INSTANCE.registerMessage(STCNotifyPlayerYawChanged.Handler.class, STCNotifyPlayerYawChanged.class, id++, Side.CLIENT);
        INSTANCE.registerMessage(STCPlayAnimation.Handler.class, STCPlayAnimation.class, id++, Side.CLIENT);
        INSTANCE.registerMessage(STCPlayAnimationTarget.Handler.class, STCPlayAnimationTarget.class, id++, Side.CLIENT);
        INSTANCE.registerMessage(STCPlayAnimationTP.Handler.class, STCPlayAnimationTP.class, id++, Side.CLIENT);
        INSTANCE.registerMessage(STCPotion.Handler.class, STCPotion.class, id++, Side.CLIENT);
        INSTANCE.registerMessage(STCResetBasicAttackCool.Handler.class, STCResetBasicAttackCool.class, id++, Side.CLIENT);
        INSTANCE.registerMessage(STCModifySkillVariable.Handler.class, STCModifySkillVariable.class, id++, Side.CLIENT);
        INSTANCE.registerMessage(STCGameruleChange.Handler.class, STCGameruleChange.class, id++, Side.CLIENT);
    }

    public static void sendToServer(IMessage message) {
        INSTANCE.sendToServer(message);
    }

    public static void sendToAll(IMessage message) {
        INSTANCE.sendToAll(message);
    }

    public static void sendToAllPlayerTrackingThisEntity(IMessage message, Entity entity) {
        INSTANCE.sendToAllTracking(message, entity);
    }

    public static void sendToPlayer(IMessage message, EntityPlayerMP player) {
        INSTANCE.sendTo(message, player);
    }

    public static void sendToAllPlayerTrackingThisEntityWithSelf(IMessage message, EntityPlayerMP entity) {
        ModNetworkManager.sendToPlayer(message, entity);
        ModNetworkManager.sendToAllPlayerTrackingThisEntity(message, (Entity)entity);
    }

    public static void writeString(String string, ByteBuf buffer) {
        byte[] abyte = string.getBytes(StandardCharsets.UTF_8);
        if (abyte.length > Short.MAX_VALUE) {
            throw new EncoderException("String too big (was " + abyte.length + " bytes encoded, max " + Short.MAX_VALUE + ")");
        }
        buffer.writeInt(abyte.length);
        buffer.writeBytes(abyte);
    }

    public static String readString(ByteBuf buffer) {
        int i = buffer.readInt();
        if (i > 131068) {
            throw new DecoderException("The received encoded string buffer length is longer than maximum allowed (" + i + " > " + 131068 + ")");
        }
        if (i < 0) {
            throw new DecoderException("The received encoded string buffer length is less than zero! Weird string!");
        }
        String s = buffer.toString(buffer.readerIndex(), i, StandardCharsets.UTF_8);
        buffer.readerIndex(buffer.readerIndex() + i);
        if (s.length() > Short.MAX_VALUE) {
            throw new DecoderException("The received string length is longer than maximum allowed (" + i + " > " + Short.MAX_VALUE + ")");
        }
        return s;
    }
}

