/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.network.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class STCPotion
implements IMessage {
    private Potion effect;
    private Action action;
    private int entityId;

    public STCPotion() {
        this.effect = null;
        this.entityId = 0;
        this.action = Action.Remove;
    }

    public STCPotion(Potion effect, Action action, int entityId) {
        this.effect = effect;
        this.entityId = entityId;
        this.action = action;
    }

    public void fromBytes(ByteBuf buf) {
        this.effect = Potion.func_188412_a((int)buf.readInt());
        this.entityId = buf.readInt();
        this.action = Action.getAction(buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(Potion.func_188409_a((Potion)this.effect));
        buf.writeInt(this.entityId);
        buf.writeInt(this.action.getSymb());
    }

    public static enum Action {
        Active(0),
        Remove(1);

        int action;

        private Action(int action) {
            this.action = action;
        }

        public int getSymb() {
            return this.action;
        }

        private static Action getAction(int symb) {
            if (symb == 0) {
                return Active;
            }
            if (symb == 1) {
                return Remove;
            }
            return null;
        }
    }

    public static class Handler
    implements IMessageHandler<STCPotion, IMessage> {
        public IMessage onMessage(STCPotion message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
                if (entity != null && entity instanceof EntityLivingBase) {
                    EntityLivingBase livEntity = (EntityLivingBase)entity;
                    switch (message.action) {
                        case Active: {
                            livEntity.func_70690_d(new PotionEffect(message.effect, 0));
                            break;
                        }
                        case Remove: {
                            livEntity.func_184589_d(message.effect);
                        }
                    }
                }
            });
            return null;
        }
    }
}

