/*
 * Decompiled with CFR 0.152.
 */
package maninthehouse.epicfight.utils.game;

import maninthehouse.epicfight.utils.game.DamageSourceExtended;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;

public interface IExtendedDamageSource {
    public static DamageSourceExtended causePlayerDamage(EntityPlayer player, StunType stunType, DamageType damageType, int id) {
        return new DamageSourceExtended("player", (Entity)player, stunType, damageType, id);
    }

    public static DamageSourceExtended causeMobDamage(EntityLivingBase mob, StunType stunType, DamageType damageType, int id) {
        return new DamageSourceExtended("mob", (Entity)mob, stunType, damageType, id);
    }

    public static DamageSourceExtended getFrom(IExtendedDamageSource original) {
        return new DamageSourceExtended(original.getType(), original.getOwner(), original.getStunType(), original.getExtDamageType(), original.getSkillId());
    }

    public void setImpact(float var1);

    public void setArmorIgnore(float var1);

    public void setStunType(StunType var1);

    public float getImpact();

    public float getArmorIgnoreRatio();

    public int getSkillId();

    public StunType getStunType();

    public DamageType getExtDamageType();

    public Entity getOwner();

    public String getType();

    public static enum DamageType {
        PHYSICAL,
        MAGIC;

    }

    public static enum StunType {
        SHORT(TextFormatting.GOLD + "SHORT" + TextFormatting.DARK_GRAY + " stun"),
        LONG(TextFormatting.GOLD + "LONG" + TextFormatting.DARK_GRAY + " stun"),
        HOLD(TextFormatting.GOLD + "HOLDING");

        private String tooltip;

        private StunType(String tooltip) {
            this.tooltip = tooltip;
        }

        public String toString() {
            return this.tooltip;
        }
    }
}

